import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageBucketConfig extends cdktf.TerraformMetaArguments {
    /**
     * Enables Bucket Policy Only access to a bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#bucket_policy_only StorageBucket#bucket_policy_only}
     */
    readonly bucketPolicyOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#default_event_based_hold StorageBucket#default_event_based_hold}.
     */
    readonly defaultEventBasedHold?: boolean | cdktf.IResolvable;
    /**
     * When deleting a bucket, this boolean option will delete all contained objects.
     *
     * If you try to delete a bucket that contains objects, Terraform will fail that run.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#force_destroy StorageBucket#force_destroy}
     */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
     * A set of key/value label pairs to assign to the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#labels StorageBucket#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The Google Cloud Storage location.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#location StorageBucket#location}
     */
    readonly location?: string;
    /**
     * The name of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#name StorageBucket#name}
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#project StorageBucket#project}
     */
    readonly project?: string;
    /**
     * Enables Requester Pays on a storage bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#requester_pays StorageBucket#requester_pays}
     */
    readonly requesterPays?: boolean | cdktf.IResolvable;
    /**
     * The Storage Class of the new bucket. Supported values include: STANDARD, MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#storage_class StorageBucket#storage_class}
     */
    readonly storageClass?: string;
    /**
     * Enables uniform bucket-level access on a bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#uniform_bucket_level_access StorageBucket#uniform_bucket_level_access}
     */
    readonly uniformBucketLevelAccess?: boolean | cdktf.IResolvable;
    /**
     * cors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#cors StorageBucket#cors}
     */
    readonly cors?: StorageBucketCors[];
    /**
     * encryption block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#encryption StorageBucket#encryption}
     */
    readonly encryption?: StorageBucketEncryption;
    /**
     * lifecycle_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#lifecycle_rule StorageBucket#lifecycle_rule}
     */
    readonly lifecycleRule?: StorageBucketLifecycleRule[];
    /**
     * logging block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#logging StorageBucket#logging}
     */
    readonly logging?: StorageBucketLogging;
    /**
     * retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#retention_policy StorageBucket#retention_policy}
     */
    readonly retentionPolicy?: StorageBucketRetentionPolicy;
    /**
     * versioning block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#versioning StorageBucket#versioning}
     */
    readonly versioning?: StorageBucketVersioning;
    /**
     * website block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#website StorageBucket#website}
     */
    readonly website?: StorageBucketWebsite;
}
export interface StorageBucketCors {
    /**
     * The value, in seconds, to return in the Access-Control-Max-Age header used in preflight responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#max_age_seconds StorageBucket#max_age_seconds}
     */
    readonly maxAgeSeconds?: number;
    /**
     * The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#method StorageBucket#method}
     */
    readonly method?: string[];
    /**
     * The list of Origins eligible to receive CORS response headers.
     *
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#origin StorageBucket#origin}
     */
    readonly origin?: string[];
    /**
     * The list of HTTP headers other than the simple response headers to give permission for the user-agent to share across domains.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#response_header StorageBucket#response_header}
     */
    readonly responseHeader?: string[];
}
export interface StorageBucketEncryption {
    /**
     * A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified.
     *
     * You must pay attention to whether the crypto key is available in the location that this bucket is created in. See the docs for more details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#default_kms_key_name StorageBucket#default_kms_key_name}
     */
    readonly defaultKmsKeyName: string;
}
export declare class StorageBucketEncryptionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _defaultKmsKeyName?;
    get defaultKmsKeyName(): string;
    set defaultKmsKeyName(value: string);
    get defaultKmsKeyNameInput(): string | undefined;
}
export interface StorageBucketLifecycleRuleAction {
    /**
     * The target Storage Class of objects affected by this Lifecycle Rule. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#storage_class StorageBucket#storage_class}
     */
    readonly storageClass?: string;
    /**
     * The type of the action of this Lifecycle Rule. Supported values include: Delete and SetStorageClass.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#type StorageBucket#type}
     */
    readonly type: string;
}
export declare class StorageBucketLifecycleRuleActionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _storageClass?;
    get storageClass(): string | undefined;
    set storageClass(value: string | undefined);
    resetStorageClass(): void;
    get storageClassInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface StorageBucketLifecycleRuleCondition {
    /**
     * Minimum age of an object in days to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#age StorageBucket#age}
     */
    readonly age?: number;
    /**
     * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#created_before StorageBucket#created_before}
     */
    readonly createdBefore?: string;
    /**
     * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#custom_time_before StorageBucket#custom_time_before}
     */
    readonly customTimeBefore?: string;
    /**
     * Number of days elapsed since the user-specified timestamp set on an object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#days_since_custom_time StorageBucket#days_since_custom_time}
     */
    readonly daysSinceCustomTime?: number;
    /**
     * Number of days elapsed since the noncurrent timestamp of an object. This 							condition is relevant only for versioned objects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#days_since_noncurrent_time StorageBucket#days_since_noncurrent_time}
     */
    readonly daysSinceNoncurrentTime?: number;
    /**
     * Storage Class of objects to satisfy this condition. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE, STANDARD, DURABLE_REDUCED_AVAILABILITY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#matches_storage_class StorageBucket#matches_storage_class}
     */
    readonly matchesStorageClass?: string[];
    /**
     * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#noncurrent_time_before StorageBucket#noncurrent_time_before}
     */
    readonly noncurrentTimeBefore?: string;
    /**
     * Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#num_newer_versions StorageBucket#num_newer_versions}
     */
    readonly numNewerVersions?: number;
    /**
     * Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: "LIVE", "ARCHIVED", "ANY".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#with_state StorageBucket#with_state}
     */
    readonly withState?: string;
}
export declare class StorageBucketLifecycleRuleConditionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _age?;
    get age(): number | undefined;
    set age(value: number | undefined);
    resetAge(): void;
    get ageInput(): number | undefined;
    private _createdBefore?;
    get createdBefore(): string | undefined;
    set createdBefore(value: string | undefined);
    resetCreatedBefore(): void;
    get createdBeforeInput(): string | undefined;
    private _customTimeBefore?;
    get customTimeBefore(): string | undefined;
    set customTimeBefore(value: string | undefined);
    resetCustomTimeBefore(): void;
    get customTimeBeforeInput(): string | undefined;
    private _daysSinceCustomTime?;
    get daysSinceCustomTime(): number | undefined;
    set daysSinceCustomTime(value: number | undefined);
    resetDaysSinceCustomTime(): void;
    get daysSinceCustomTimeInput(): number | undefined;
    private _daysSinceNoncurrentTime?;
    get daysSinceNoncurrentTime(): number | undefined;
    set daysSinceNoncurrentTime(value: number | undefined);
    resetDaysSinceNoncurrentTime(): void;
    get daysSinceNoncurrentTimeInput(): number | undefined;
    private _matchesStorageClass?;
    get matchesStorageClass(): string[] | undefined;
    set matchesStorageClass(value: string[] | undefined);
    resetMatchesStorageClass(): void;
    get matchesStorageClassInput(): string[] | undefined;
    private _noncurrentTimeBefore?;
    get noncurrentTimeBefore(): string | undefined;
    set noncurrentTimeBefore(value: string | undefined);
    resetNoncurrentTimeBefore(): void;
    get noncurrentTimeBeforeInput(): string | undefined;
    private _numNewerVersions?;
    get numNewerVersions(): number | undefined;
    set numNewerVersions(value: number | undefined);
    resetNumNewerVersions(): void;
    get numNewerVersionsInput(): number | undefined;
    private _withState?;
    get withState(): string | undefined;
    set withState(value: string | undefined);
    resetWithState(): void;
    get withStateInput(): string | undefined;
}
export interface StorageBucketLifecycleRule {
    /**
     * action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#action StorageBucket#action}
     */
    readonly action: StorageBucketLifecycleRuleAction;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#condition StorageBucket#condition}
     */
    readonly condition: StorageBucketLifecycleRuleCondition;
}
export interface StorageBucketLogging {
    /**
     * The bucket that will receive log objects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#log_bucket StorageBucket#log_bucket}
     */
    readonly logBucket: string;
    /**
     * The object prefix for log objects.
     *
     * If it's not provided, by default Google Cloud Storage sets this to this bucket's name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#log_object_prefix StorageBucket#log_object_prefix}
     */
    readonly logObjectPrefix?: string;
}
export declare class StorageBucketLoggingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _logBucket?;
    get logBucket(): string;
    set logBucket(value: string);
    get logBucketInput(): string | undefined;
    private _logObjectPrefix?;
    get logObjectPrefix(): string | undefined;
    set logObjectPrefix(value: string | undefined);
    resetLogObjectPrefix(): void;
    get logObjectPrefixInput(): string | undefined;
}
export interface StorageBucketRetentionPolicy {
    /**
     * If set to true, the bucket will be locked and permanently restrict edits to the bucket's retention policy.
     *
     * Caution: Locking a bucket is an irreversible action.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#is_locked StorageBucket#is_locked}
     */
    readonly isLocked?: boolean | cdktf.IResolvable;
    /**
     * The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived.
     *
     * The value must be less than 3,155,760,000 seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#retention_period StorageBucket#retention_period}
     */
    readonly retentionPeriod: number;
}
export declare class StorageBucketRetentionPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isLocked?;
    get isLocked(): boolean | cdktf.IResolvable | undefined;
    set isLocked(value: boolean | cdktf.IResolvable | undefined);
    resetIsLocked(): void;
    get isLockedInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPeriod?;
    get retentionPeriod(): number;
    set retentionPeriod(value: number);
    get retentionPeriodInput(): number | undefined;
}
export interface StorageBucketVersioning {
    /**
     * While set to true, versioning is fully enabled for this bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#enabled StorageBucket#enabled}
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare class StorageBucketVersioningOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StorageBucketWebsite {
    /**
     * Behaves as the bucket's directory index where missing objects are treated as potential directories.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#main_page_suffix StorageBucket#main_page_suffix}
     */
    readonly mainPageSuffix?: string;
    /**
     * The custom object to return when a requested resource is not found.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#not_found_page StorageBucket#not_found_page}
     */
    readonly notFoundPage?: string;
}
export declare class StorageBucketWebsiteOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _mainPageSuffix?;
    get mainPageSuffix(): string | undefined;
    set mainPageSuffix(value: string | undefined);
    resetMainPageSuffix(): void;
    get mainPageSuffixInput(): string | undefined;
    private _notFoundPage?;
    get notFoundPage(): string | undefined;
    set notFoundPage(value: string | undefined);
    resetNotFoundPage(): void;
    get notFoundPageInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html google_storage_bucket}.
 */
export declare class StorageBucket extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html google_storage_bucket} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: StorageBucketConfig);
    private _bucketPolicyOnly?;
    get bucketPolicyOnly(): boolean | cdktf.IResolvable | undefined;
    set bucketPolicyOnly(value: boolean | cdktf.IResolvable | undefined);
    resetBucketPolicyOnly(): void;
    get bucketPolicyOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultEventBasedHold?;
    get defaultEventBasedHold(): boolean | cdktf.IResolvable | undefined;
    set defaultEventBasedHold(value: boolean | cdktf.IResolvable | undefined);
    resetDefaultEventBasedHold(): void;
    get defaultEventBasedHoldInput(): boolean | cdktf.IResolvable | undefined;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable | undefined;
    set forceDestroy(value: boolean | cdktf.IResolvable | undefined);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _requesterPays?;
    get requesterPays(): boolean | cdktf.IResolvable | undefined;
    set requesterPays(value: boolean | cdktf.IResolvable | undefined);
    resetRequesterPays(): void;
    get requesterPaysInput(): boolean | cdktf.IResolvable | undefined;
    get selfLink(): string;
    private _storageClass?;
    get storageClass(): string | undefined;
    set storageClass(value: string | undefined);
    resetStorageClass(): void;
    get storageClassInput(): string | undefined;
    private _uniformBucketLevelAccess?;
    get uniformBucketLevelAccess(): boolean | cdktf.IResolvable | undefined;
    set uniformBucketLevelAccess(value: boolean | cdktf.IResolvable | undefined);
    resetUniformBucketLevelAccess(): void;
    get uniformBucketLevelAccessInput(): boolean | cdktf.IResolvable | undefined;
    get url(): string;
    private _cors?;
    get cors(): StorageBucketCors[] | undefined;
    set cors(value: StorageBucketCors[] | undefined);
    resetCors(): void;
    get corsInput(): StorageBucketCors[] | undefined;
    private _encryption?;
    private __encryptionOutput;
    get encryption(): StorageBucketEncryptionOutputReference;
    putEncryption(value: StorageBucketEncryption | undefined): void;
    resetEncryption(): void;
    get encryptionInput(): StorageBucketEncryption | undefined;
    private _lifecycleRule?;
    get lifecycleRule(): StorageBucketLifecycleRule[] | undefined;
    set lifecycleRule(value: StorageBucketLifecycleRule[] | undefined);
    resetLifecycleRule(): void;
    get lifecycleRuleInput(): StorageBucketLifecycleRule[] | undefined;
    private _logging?;
    private __loggingOutput;
    get logging(): StorageBucketLoggingOutputReference;
    putLogging(value: StorageBucketLogging | undefined): void;
    resetLogging(): void;
    get loggingInput(): StorageBucketLogging | undefined;
    private _retentionPolicy?;
    private __retentionPolicyOutput;
    get retentionPolicy(): StorageBucketRetentionPolicyOutputReference;
    putRetentionPolicy(value: StorageBucketRetentionPolicy | undefined): void;
    resetRetentionPolicy(): void;
    get retentionPolicyInput(): StorageBucketRetentionPolicy | undefined;
    private _versioning?;
    private __versioningOutput;
    get versioning(): StorageBucketVersioningOutputReference;
    putVersioning(value: StorageBucketVersioning | undefined): void;
    resetVersioning(): void;
    get versioningInput(): StorageBucketVersioning | undefined;
    private _website?;
    private __websiteOutput;
    get website(): StorageBucketWebsiteOutputReference;
    putWebsite(value: StorageBucketWebsite | undefined): void;
    resetWebsite(): void;
    get websiteInput(): StorageBucketWebsite | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
