import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageBucketAclConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the bucket it applies to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_acl.html#bucket StorageBucketAcl#bucket}
     */
    readonly bucket: string;
    /**
     * Configure this ACL to be the default ACL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_acl.html#default_acl StorageBucketAcl#default_acl}
     */
    readonly defaultAcl?: string;
    /**
     * The canned GCS ACL to apply. Must be set if role_entity is not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_acl.html#predefined_acl StorageBucketAcl#predefined_acl}
     */
    readonly predefinedAcl?: string;
    /**
     * List of role/entity pairs in the form ROLE:entity.
     *
     * See GCS Bucket ACL documentation  for more details. Must be set if predefined_acl is not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_acl.html#role_entity StorageBucketAcl#role_entity}
     */
    readonly roleEntity?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_acl.html google_storage_bucket_acl}.
 */
export declare class StorageBucketAcl extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_acl.html google_storage_bucket_acl} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: StorageBucketAclConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _defaultAcl?;
    get defaultAcl(): string | undefined;
    set defaultAcl(value: string | undefined);
    resetDefaultAcl(): void;
    get defaultAclInput(): string | undefined;
    get id(): string;
    private _predefinedAcl?;
    get predefinedAcl(): string | undefined;
    set predefinedAcl(value: string | undefined);
    resetPredefinedAcl(): void;
    get predefinedAclInput(): string | undefined;
    private _roleEntity?;
    get roleEntity(): string[] | undefined;
    set roleEntity(value: string[] | undefined);
    resetRoleEntity(): void;
    get roleEntityInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
