import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageBucketAccessControlConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#bucket StorageBucketAccessControl#bucket}
     */
    readonly bucket: string;
    /**
     * The entity holding the permission, in one of the following forms: user-userId user-email group-groupId group-email domain-domain project-team-projectId allUsers allAuthenticatedUsers Examples: The user liz@example.com would be user-liz@example.com. The group example@googlegroups.com would be group-example@googlegroups.com. To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#entity StorageBucketAccessControl#entity}
     */
    readonly entity: string;
    /**
     * The access permission for the entity. Possible values: ["OWNER", "READER", "WRITER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#role StorageBucketAccessControl#role}
     */
    readonly role?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#timeouts StorageBucketAccessControl#timeouts}
     */
    readonly timeouts?: StorageBucketAccessControlTimeouts;
}
export interface StorageBucketAccessControlTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#create StorageBucketAccessControl#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#delete StorageBucketAccessControl#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#update StorageBucketAccessControl#update}.
     */
    readonly update?: string;
}
export declare class StorageBucketAccessControlTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html google_storage_bucket_access_control}.
 */
export declare class StorageBucketAccessControl extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html google_storage_bucket_access_control} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: StorageBucketAccessControlConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get domain(): string;
    get email(): string;
    private _entity?;
    get entity(): string;
    set entity(value: string);
    get entityInput(): string | undefined;
    get id(): string;
    private _role?;
    get role(): string | undefined;
    set role(value: string | undefined);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): StorageBucketAccessControlTimeoutsOutputReference;
    putTimeouts(value: StorageBucketAccessControlTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): StorageBucketAccessControlTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
