import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlUserConfig extends cdktf.TerraformMetaArguments {
    /**
     * The deletion policy for the user.
     *
     * Setting ABANDON allows the resource
     * to be abandoned rather than deleted. This is useful for Postgres, where users cannot be deleted from the API if they
     * have been granted SQL roles. Possible values are: "ABANDON".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user.html#deletion_policy SqlUser#deletion_policy}
     */
    readonly deletionPolicy?: string;
    /**
     * The host the user can connect from.
     *
     * This is only supported for MySQL instances. Don't set this field for PostgreSQL instances. Can be an IP address. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user.html#host SqlUser#host}
     */
    readonly host?: string;
    /**
     * The name of the Cloud SQL instance. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user.html#instance SqlUser#instance}
     */
    readonly instance: string;
    /**
     * The name of the user. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user.html#name SqlUser#name}
     */
    readonly name: string;
    /**
     * The password for the user.
     *
     * Can be updated. For Postgres instances this is a Required field, unless type is set to
     *              either CLOUD_IAM_USER or CLOUD_IAM_SERVICE_ACCOUNT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user.html#password SqlUser#password}
     */
    readonly password?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user.html#project SqlUser#project}
     */
    readonly project?: string;
    /**
     * The user type.
     *
     * It determines the method to authenticate the user during login.
     *              The default is the database's built-in user type. Flags include "BUILT_IN", "CLOUD_IAM_USER", or "CLOUD_IAM_SERVICE_ACCOUNT".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user.html#type SqlUser#type}
     */
    readonly type?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user.html#timeouts SqlUser#timeouts}
     */
    readonly timeouts?: SqlUserTimeouts;
}
export interface SqlUserTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user.html#create SqlUser#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user.html#delete SqlUser#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user.html#update SqlUser#update}.
     */
    readonly update?: string;
}
export declare class SqlUserTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/sql_user.html google_sql_user}.
 */
export declare class SqlUser extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/sql_user.html google_sql_user} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: SqlUserConfig);
    private _deletionPolicy?;
    get deletionPolicy(): string | undefined;
    set deletionPolicy(value: string | undefined);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    get id(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    resetType(): void;
    get typeInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): SqlUserTimeoutsOutputReference;
    putTimeouts(value: SqlUserTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): SqlUserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
