import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlSourceRepresentationInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The MySQL version running on your source database server. Possible values: ["MYSQL_5_5", "MYSQL_5_6", "MYSQL_5_7", "MYSQL_8_0"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#database_version SqlSourceRepresentationInstance#database_version}
     */
    readonly databaseVersion: string;
    /**
     * The externally accessible IPv4 address for the source database server.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#host SqlSourceRepresentationInstance#host}
     */
    readonly host: string;
    /**
     * The name of the source representation instance. Use any valid Cloud SQL instance name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#name SqlSourceRepresentationInstance#name}
     */
    readonly name: string;
    /**
     * The externally accessible port for the source database server. Defaults to 3306.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#port SqlSourceRepresentationInstance#port}
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#project SqlSourceRepresentationInstance#project}.
     */
    readonly project?: string;
    /**
     * The Region in which the created instance should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#region SqlSourceRepresentationInstance#region}
     */
    readonly region?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#timeouts SqlSourceRepresentationInstance#timeouts}
     */
    readonly timeouts?: SqlSourceRepresentationInstanceTimeouts;
}
export interface SqlSourceRepresentationInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#create SqlSourceRepresentationInstance#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html#delete SqlSourceRepresentationInstance#delete}.
     */
    readonly delete?: string;
}
export declare class SqlSourceRepresentationInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html google_sql_source_representation_instance}.
 */
export declare class SqlSourceRepresentationInstance extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/sql_source_representation_instance.html google_sql_source_representation_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: SqlSourceRepresentationInstanceConfig);
    private _databaseVersion?;
    get databaseVersion(): string;
    set databaseVersion(value: string);
    get databaseVersionInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): SqlSourceRepresentationInstanceTimeoutsOutputReference;
    putTimeouts(value: SqlSourceRepresentationInstanceTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): SqlSourceRepresentationInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
