import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlDatabaseInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The MySQL, PostgreSQL or SQL Server (beta) version to use.
     *
     * Supported values include MYSQL_5_6, MYSQL_5_7, MYSQL_8_0, POSTGRES_9_6, POSTGRES_10, POSTGRES_11, POSTGRES_12, POSTGRES_13, SQLSERVER_2017_STANDARD, SQLSERVER_2017_ENTERPRISE, SQLSERVER_2017_EXPRESS, SQLSERVER_2017_WEB. Database Version Policies includes an up-to-date reference of supported versions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#database_version SqlDatabaseInstance#database_version}
     */
    readonly databaseVersion?: string;
    /**
     * Used to block Terraform from deleting a SQL Instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#deletion_protection SqlDatabaseInstance#deletion_protection}
     */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
     * The name of the instance that will act as the master in the replication setup.
     *
     * Note, this requires the master to have binary_log_enabled set, as well as existing backups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#master_instance_name SqlDatabaseInstance#master_instance_name}
     */
    readonly masterInstanceName?: string;
    /**
     * The name of the instance.
     *
     * If the name is left blank, Terraform will randomly generate one when the instance is first created. This is done because after a name is used, it cannot be reused for up to one week.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#name SqlDatabaseInstance#name}
     */
    readonly name?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#project SqlDatabaseInstance#project}
     */
    readonly project?: string;
    /**
     * The region the instance will sit in.
     *
     * Note, Cloud SQL is not available in all regions. A valid region must be provided to use this resource. If a region is not provided in the resource definition, the provider region will be used instead, but this will be an apply-time error for instances if the provider region is not supported with Cloud SQL. If you choose not to provide the region argument for this resource, make sure you understand this.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#region SqlDatabaseInstance#region}
     */
    readonly region?: string;
    /**
     * Initial root password. Required for MS SQL Server, ignored by MySQL and PostgreSQL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#root_password SqlDatabaseInstance#root_password}
     */
    readonly rootPassword?: string;
    /**
     * clone block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#clone SqlDatabaseInstance#clone}
     */
    readonly clone?: SqlDatabaseInstanceClone;
    /**
     * replica_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#replica_configuration SqlDatabaseInstance#replica_configuration}
     */
    readonly replicaConfiguration?: SqlDatabaseInstanceReplicaConfiguration;
    /**
     * restore_backup_context block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#restore_backup_context SqlDatabaseInstance#restore_backup_context}
     */
    readonly restoreBackupContext?: SqlDatabaseInstanceRestoreBackupContext;
    /**
     * settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#settings SqlDatabaseInstance#settings}
     */
    readonly settings?: SqlDatabaseInstanceSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#timeouts SqlDatabaseInstance#timeouts}
     */
    readonly timeouts?: SqlDatabaseInstanceTimeouts;
}
export declare class SqlDatabaseInstanceIpAddress extends cdktf.ComplexComputedList {
    get ipAddress(): string;
    get timeToRetire(): string;
    get type(): string;
}
export declare class SqlDatabaseInstanceServerCaCert extends cdktf.ComplexComputedList {
    get cert(): string;
    get commonName(): string;
    get createTime(): string;
    get expirationTime(): string;
    get sha1Fingerprint(): string;
}
export interface SqlDatabaseInstanceClone {
    /**
     * The timestamp of the point in time that should be restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#point_in_time SqlDatabaseInstance#point_in_time}
     */
    readonly pointInTime?: string;
    /**
     * The name of the instance from which the point in time should be restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#source_instance_name SqlDatabaseInstance#source_instance_name}
     */
    readonly sourceInstanceName: string;
}
export declare class SqlDatabaseInstanceCloneOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _pointInTime?;
    get pointInTime(): string | undefined;
    set pointInTime(value: string | undefined);
    resetPointInTime(): void;
    get pointInTimeInput(): string | undefined;
    private _sourceInstanceName?;
    get sourceInstanceName(): string;
    set sourceInstanceName(value: string);
    get sourceInstanceNameInput(): string | undefined;
}
export interface SqlDatabaseInstanceReplicaConfiguration {
    /**
     * PEM representation of the trusted CA's x509 certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#ca_certificate SqlDatabaseInstance#ca_certificate}
     */
    readonly caCertificate?: string;
    /**
     * PEM representation of the replica's x509 certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#client_certificate SqlDatabaseInstance#client_certificate}
     */
    readonly clientCertificate?: string;
    /**
     * PEM representation of the replica's private key. The corresponding public key in encoded in the client_certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#client_key SqlDatabaseInstance#client_key}
     */
    readonly clientKey?: string;
    /**
     * The number of seconds between connect retries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#connect_retry_interval SqlDatabaseInstance#connect_retry_interval}
     */
    readonly connectRetryInterval?: number;
    /**
     * Path to a SQL file in Google Cloud Storage from which replica instances are created. Format is gs://bucket/filename.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#dump_file_path SqlDatabaseInstance#dump_file_path}
     */
    readonly dumpFilePath?: string;
    /**
     * Specifies if the replica is the failover target.
     *
     * If the field is set to true the replica will be designated as a failover replica. If the master instance fails, the replica instance will be promoted as the new master instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#failover_target SqlDatabaseInstance#failover_target}
     */
    readonly failoverTarget?: boolean | cdktf.IResolvable;
    /**
     * Time in ms between replication heartbeats.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#master_heartbeat_period SqlDatabaseInstance#master_heartbeat_period}
     */
    readonly masterHeartbeatPeriod?: number;
    /**
     * Password for the replication connection.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#password SqlDatabaseInstance#password}
     */
    readonly password?: string;
    /**
     * Permissible ciphers for use in SSL encryption.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#ssl_cipher SqlDatabaseInstance#ssl_cipher}
     */
    readonly sslCipher?: string;
    /**
     * Username for replication connection.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#username SqlDatabaseInstance#username}
     */
    readonly username?: string;
    /**
     * True if the master's common name value is checked during the SSL handshake.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#verify_server_certificate SqlDatabaseInstance#verify_server_certificate}
     */
    readonly verifyServerCertificate?: boolean | cdktf.IResolvable;
}
export declare class SqlDatabaseInstanceReplicaConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _caCertificate?;
    get caCertificate(): string | undefined;
    set caCertificate(value: string | undefined);
    resetCaCertificate(): void;
    get caCertificateInput(): string | undefined;
    private _clientCertificate?;
    get clientCertificate(): string | undefined;
    set clientCertificate(value: string | undefined);
    resetClientCertificate(): void;
    get clientCertificateInput(): string | undefined;
    private _clientKey?;
    get clientKey(): string | undefined;
    set clientKey(value: string | undefined);
    resetClientKey(): void;
    get clientKeyInput(): string | undefined;
    private _connectRetryInterval?;
    get connectRetryInterval(): number | undefined;
    set connectRetryInterval(value: number | undefined);
    resetConnectRetryInterval(): void;
    get connectRetryIntervalInput(): number | undefined;
    private _dumpFilePath?;
    get dumpFilePath(): string | undefined;
    set dumpFilePath(value: string | undefined);
    resetDumpFilePath(): void;
    get dumpFilePathInput(): string | undefined;
    private _failoverTarget?;
    get failoverTarget(): boolean | cdktf.IResolvable | undefined;
    set failoverTarget(value: boolean | cdktf.IResolvable | undefined);
    resetFailoverTarget(): void;
    get failoverTargetInput(): boolean | cdktf.IResolvable | undefined;
    private _masterHeartbeatPeriod?;
    get masterHeartbeatPeriod(): number | undefined;
    set masterHeartbeatPeriod(value: number | undefined);
    resetMasterHeartbeatPeriod(): void;
    get masterHeartbeatPeriodInput(): number | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sslCipher?;
    get sslCipher(): string | undefined;
    set sslCipher(value: string | undefined);
    resetSslCipher(): void;
    get sslCipherInput(): string | undefined;
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _verifyServerCertificate?;
    get verifyServerCertificate(): boolean | cdktf.IResolvable | undefined;
    set verifyServerCertificate(value: boolean | cdktf.IResolvable | undefined);
    resetVerifyServerCertificate(): void;
    get verifyServerCertificateInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SqlDatabaseInstanceRestoreBackupContext {
    /**
     * The ID of the backup run to restore from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#backup_run_id SqlDatabaseInstance#backup_run_id}
     */
    readonly backupRunId: number;
    /**
     * The ID of the instance that the backup was taken from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#instance_id SqlDatabaseInstance#instance_id}
     */
    readonly instanceId?: string;
    /**
     * The full project ID of the source instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#project SqlDatabaseInstance#project}
     */
    readonly project?: string;
}
export declare class SqlDatabaseInstanceRestoreBackupContextOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _backupRunId?;
    get backupRunId(): number;
    set backupRunId(value: number);
    get backupRunIdInput(): number | undefined;
    private _instanceId?;
    get instanceId(): string | undefined;
    set instanceId(value: string | undefined);
    resetInstanceId(): void;
    get instanceIdInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
}
export interface SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings {
    /**
     * Number of backups to retain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#retained_backups SqlDatabaseInstance#retained_backups}
     */
    readonly retainedBackups: number;
    /**
     * The unit that 'retainedBackups' represents. Defaults to COUNT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#retention_unit SqlDatabaseInstance#retention_unit}
     */
    readonly retentionUnit?: string;
}
export declare class SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _retainedBackups?;
    get retainedBackups(): number;
    set retainedBackups(value: number);
    get retainedBackupsInput(): number | undefined;
    private _retentionUnit?;
    get retentionUnit(): string | undefined;
    set retentionUnit(value: string | undefined);
    resetRetentionUnit(): void;
    get retentionUnitInput(): string | undefined;
}
export interface SqlDatabaseInstanceSettingsBackupConfiguration {
    /**
     * True if binary logging is enabled.
     *
     * If settings.backup_configuration.enabled is false, this must be as well. Cannot be used with Postgres.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#binary_log_enabled SqlDatabaseInstance#binary_log_enabled}
     */
    readonly binaryLogEnabled?: boolean | cdktf.IResolvable;
    /**
     * True if backup configuration is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#enabled SqlDatabaseInstance#enabled}
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Location of the backup configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#location SqlDatabaseInstance#location}
     */
    readonly location?: string;
    /**
     * True if Point-in-time recovery is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#point_in_time_recovery_enabled SqlDatabaseInstance#point_in_time_recovery_enabled}
     */
    readonly pointInTimeRecoveryEnabled?: boolean | cdktf.IResolvable;
    /**
     * HH:MM format time indicating when backup configuration starts.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#start_time SqlDatabaseInstance#start_time}
     */
    readonly startTime?: string;
    /**
     * The number of days of transaction logs we retain for point in time restore, from 1-7.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#transaction_log_retention_days SqlDatabaseInstance#transaction_log_retention_days}
     */
    readonly transactionLogRetentionDays?: number;
    /**
     * backup_retention_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#backup_retention_settings SqlDatabaseInstance#backup_retention_settings}
     */
    readonly backupRetentionSettings?: SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings;
}
export declare class SqlDatabaseInstanceSettingsBackupConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _binaryLogEnabled?;
    get binaryLogEnabled(): boolean | cdktf.IResolvable | undefined;
    set binaryLogEnabled(value: boolean | cdktf.IResolvable | undefined);
    resetBinaryLogEnabled(): void;
    get binaryLogEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable | undefined;
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _pointInTimeRecoveryEnabled?;
    get pointInTimeRecoveryEnabled(): boolean | cdktf.IResolvable | undefined;
    set pointInTimeRecoveryEnabled(value: boolean | cdktf.IResolvable | undefined);
    resetPointInTimeRecoveryEnabled(): void;
    get pointInTimeRecoveryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _startTime?;
    get startTime(): string | undefined;
    set startTime(value: string | undefined);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _transactionLogRetentionDays?;
    get transactionLogRetentionDays(): number | undefined;
    set transactionLogRetentionDays(value: number | undefined);
    resetTransactionLogRetentionDays(): void;
    get transactionLogRetentionDaysInput(): number | undefined;
    private _backupRetentionSettings?;
    private __backupRetentionSettingsOutput;
    get backupRetentionSettings(): SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsOutputReference;
    putBackupRetentionSettings(value: SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings | undefined): void;
    resetBackupRetentionSettings(): void;
    get backupRetentionSettingsInput(): SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings | undefined;
}
export interface SqlDatabaseInstanceSettingsDatabaseFlags {
    /**
     * Name of the flag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#name SqlDatabaseInstance#name}
     */
    readonly name: string;
    /**
     * Value of the flag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#value SqlDatabaseInstance#value}
     */
    readonly value: string;
}
export interface SqlDatabaseInstanceSettingsInsightsConfig {
    /**
     * True if Query Insights feature is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#query_insights_enabled SqlDatabaseInstance#query_insights_enabled}
     */
    readonly queryInsightsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Maximum query length stored in bytes. Between 256 and 4500. Default to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#query_string_length SqlDatabaseInstance#query_string_length}
     */
    readonly queryStringLength?: number;
    /**
     * True if Query Insights will record application tags from query when enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#record_application_tags SqlDatabaseInstance#record_application_tags}
     */
    readonly recordApplicationTags?: boolean | cdktf.IResolvable;
    /**
     * True if Query Insights will record client address when enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#record_client_address SqlDatabaseInstance#record_client_address}
     */
    readonly recordClientAddress?: boolean | cdktf.IResolvable;
}
export declare class SqlDatabaseInstanceSettingsInsightsConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _queryInsightsEnabled?;
    get queryInsightsEnabled(): boolean | cdktf.IResolvable | undefined;
    set queryInsightsEnabled(value: boolean | cdktf.IResolvable | undefined);
    resetQueryInsightsEnabled(): void;
    get queryInsightsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _queryStringLength?;
    get queryStringLength(): number | undefined;
    set queryStringLength(value: number | undefined);
    resetQueryStringLength(): void;
    get queryStringLengthInput(): number | undefined;
    private _recordApplicationTags?;
    get recordApplicationTags(): boolean | cdktf.IResolvable | undefined;
    set recordApplicationTags(value: boolean | cdktf.IResolvable | undefined);
    resetRecordApplicationTags(): void;
    get recordApplicationTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _recordClientAddress?;
    get recordClientAddress(): boolean | cdktf.IResolvable | undefined;
    set recordClientAddress(value: boolean | cdktf.IResolvable | undefined);
    resetRecordClientAddress(): void;
    get recordClientAddressInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#expiration_time SqlDatabaseInstance#expiration_time}.
     */
    readonly expirationTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#name SqlDatabaseInstance#name}.
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#value SqlDatabaseInstance#value}.
     */
    readonly value: string;
}
export interface SqlDatabaseInstanceSettingsIpConfiguration {
    /**
     * Whether this Cloud SQL instance should be assigned a public IPV4 address.
     *
     * At least ipv4_enabled must be enabled or a private_network must be configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#ipv4_enabled SqlDatabaseInstance#ipv4_enabled}
     */
    readonly ipv4Enabled?: boolean | cdktf.IResolvable;
    /**
     * The VPC network from which the Cloud SQL instance is accessible for private IP.
     *
     * For example, projects/myProject/global/networks/default. Specifying a network enables private IP. At least ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#private_network SqlDatabaseInstance#private_network}
     */
    readonly privateNetwork?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#require_ssl SqlDatabaseInstance#require_ssl}.
     */
    readonly requireSsl?: boolean | cdktf.IResolvable;
    /**
     * authorized_networks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#authorized_networks SqlDatabaseInstance#authorized_networks}
     */
    readonly authorizedNetworks?: SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[];
}
export declare class SqlDatabaseInstanceSettingsIpConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _ipv4Enabled?;
    get ipv4Enabled(): boolean | cdktf.IResolvable | undefined;
    set ipv4Enabled(value: boolean | cdktf.IResolvable | undefined);
    resetIpv4Enabled(): void;
    get ipv4EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _privateNetwork?;
    get privateNetwork(): string | undefined;
    set privateNetwork(value: string | undefined);
    resetPrivateNetwork(): void;
    get privateNetworkInput(): string | undefined;
    private _requireSsl?;
    get requireSsl(): boolean | cdktf.IResolvable | undefined;
    set requireSsl(value: boolean | cdktf.IResolvable | undefined);
    resetRequireSsl(): void;
    get requireSslInput(): boolean | cdktf.IResolvable | undefined;
    private _authorizedNetworks?;
    get authorizedNetworks(): SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | undefined;
    set authorizedNetworks(value: SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | undefined);
    resetAuthorizedNetworks(): void;
    get authorizedNetworksInput(): SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | undefined;
}
export interface SqlDatabaseInstanceSettingsLocationPreference {
    /**
     * A Google App Engine application whose zone to remain in. Must be in the same region as this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#follow_gae_application SqlDatabaseInstance#follow_gae_application}
     */
    readonly followGaeApplication?: string;
    /**
     * The preferred compute engine zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#zone SqlDatabaseInstance#zone}
     */
    readonly zone?: string;
}
export declare class SqlDatabaseInstanceSettingsLocationPreferenceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _followGaeApplication?;
    get followGaeApplication(): string | undefined;
    set followGaeApplication(value: string | undefined);
    resetFollowGaeApplication(): void;
    get followGaeApplicationInput(): string | undefined;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
}
export interface SqlDatabaseInstanceSettingsMaintenanceWindow {
    /**
     * Day of week (1-7), starting on Monday.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#day SqlDatabaseInstance#day}
     */
    readonly day?: number;
    /**
     * Hour of day (0-23), ignored if day not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#hour SqlDatabaseInstance#hour}
     */
    readonly hour?: number;
    /**
     * Receive updates earlier (canary) or later (stable).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#update_track SqlDatabaseInstance#update_track}
     */
    readonly updateTrack?: string;
}
export declare class SqlDatabaseInstanceSettingsMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _day?;
    get day(): number | undefined;
    set day(value: number | undefined);
    resetDay(): void;
    get dayInput(): number | undefined;
    private _hour?;
    get hour(): number | undefined;
    set hour(value: number | undefined);
    resetHour(): void;
    get hourInput(): number | undefined;
    private _updateTrack?;
    get updateTrack(): string | undefined;
    set updateTrack(value: string | undefined);
    resetUpdateTrack(): void;
    get updateTrackInput(): string | undefined;
}
export interface SqlDatabaseInstanceSettings {
    /**
     * This specifies when the instance should be active. Can be either ALWAYS, NEVER or ON_DEMAND.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#activation_policy SqlDatabaseInstance#activation_policy}
     */
    readonly activationPolicy?: string;
    /**
     * This property is only applicable to First Generation instances.
     *
     * First Generation instances are now deprecated, see https://cloud.google.com/sql/docs/mysql/deprecation-notice for information on how to upgrade to Second Generation instances. A list of Google App Engine project names that are allowed to access this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#authorized_gae_applications SqlDatabaseInstance#authorized_gae_applications}
     */
    readonly authorizedGaeApplications?: string[];
    /**
     * The availability type of the Cloud SQL instance, high availability (REGIONAL) or single zone (ZONAL).
     *
     * For MySQL instances, ensure that
     * settings.backup_configuration.enabled and
     * settings.backup_configuration.binary_log_enabled are both set to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#availability_type SqlDatabaseInstance#availability_type}
     */
    readonly availabilityType?: string;
    /**
     * The name of server instance collation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#collation SqlDatabaseInstance#collation}
     */
    readonly collation?: string;
    /**
     * This property is only applicable to First Generation instances.
     *
     * First Generation instances are now deprecated, see here for information on how to upgrade to Second Generation instances. Specific to read instances, indicates when crash-safe replication flags are enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#crash_safe_replication SqlDatabaseInstance#crash_safe_replication}
     */
    readonly crashSafeReplication?: boolean | cdktf.IResolvable;
    /**
     * Configuration to increase storage size automatically.
     *
     * Note that future terraform apply calls will attempt to resize the disk to the value specified in disk_size - if this is set, do not set disk_size.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#disk_autoresize SqlDatabaseInstance#disk_autoresize}
     */
    readonly diskAutoresize?: boolean | cdktf.IResolvable;
    /**
     * The maximum size, in GB, to which storage capacity can be automatically increased.
     *
     * The default value is 0, which specifies that there is no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#disk_autoresize_limit SqlDatabaseInstance#disk_autoresize_limit}
     */
    readonly diskAutoresizeLimit?: number;
    /**
     * The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#disk_size SqlDatabaseInstance#disk_size}
     */
    readonly diskSize?: number;
    /**
     * The type of data disk: PD_SSD or PD_HDD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#disk_type SqlDatabaseInstance#disk_type}
     */
    readonly diskType?: string;
    /**
     * Pricing plan for this instance, can only be PER_USE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#pricing_plan SqlDatabaseInstance#pricing_plan}
     */
    readonly pricingPlan?: string;
    /**
     * This property is only applicable to First Generation instances.
     *
     * First Generation instances are now deprecated, see here for information on how to upgrade to Second Generation instances. Replication type for this instance, can be one of ASYNCHRONOUS or SYNCHRONOUS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#replication_type SqlDatabaseInstance#replication_type}
     */
    readonly replicationType?: string;
    /**
     * The machine type to use.
     *
     * See tiers for more details and supported versions. Postgres supports only shared-core machine types, and custom machine types such as db-custom-2-13312. See the Custom Machine Type Documentation to learn about specifying custom machine types.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#tier SqlDatabaseInstance#tier}
     */
    readonly tier: string;
    /**
     * A set of key/value user label pairs to assign to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#user_labels SqlDatabaseInstance#user_labels}
     */
    readonly userLabels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * backup_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#backup_configuration SqlDatabaseInstance#backup_configuration}
     */
    readonly backupConfiguration?: SqlDatabaseInstanceSettingsBackupConfiguration;
    /**
     * database_flags block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#database_flags SqlDatabaseInstance#database_flags}
     */
    readonly databaseFlags?: SqlDatabaseInstanceSettingsDatabaseFlags[];
    /**
     * insights_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#insights_config SqlDatabaseInstance#insights_config}
     */
    readonly insightsConfig?: SqlDatabaseInstanceSettingsInsightsConfig;
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#ip_configuration SqlDatabaseInstance#ip_configuration}
     */
    readonly ipConfiguration?: SqlDatabaseInstanceSettingsIpConfiguration;
    /**
     * location_preference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#location_preference SqlDatabaseInstance#location_preference}
     */
    readonly locationPreference?: SqlDatabaseInstanceSettingsLocationPreference;
    /**
     * maintenance_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#maintenance_window SqlDatabaseInstance#maintenance_window}
     */
    readonly maintenanceWindow?: SqlDatabaseInstanceSettingsMaintenanceWindow;
}
export declare class SqlDatabaseInstanceSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _activationPolicy?;
    get activationPolicy(): string | undefined;
    set activationPolicy(value: string | undefined);
    resetActivationPolicy(): void;
    get activationPolicyInput(): string | undefined;
    private _authorizedGaeApplications?;
    get authorizedGaeApplications(): string[] | undefined;
    set authorizedGaeApplications(value: string[] | undefined);
    resetAuthorizedGaeApplications(): void;
    get authorizedGaeApplicationsInput(): string[] | undefined;
    private _availabilityType?;
    get availabilityType(): string | undefined;
    set availabilityType(value: string | undefined);
    resetAvailabilityType(): void;
    get availabilityTypeInput(): string | undefined;
    private _collation?;
    get collation(): string | undefined;
    set collation(value: string | undefined);
    resetCollation(): void;
    get collationInput(): string | undefined;
    private _crashSafeReplication?;
    get crashSafeReplication(): boolean | cdktf.IResolvable | undefined;
    set crashSafeReplication(value: boolean | cdktf.IResolvable | undefined);
    resetCrashSafeReplication(): void;
    get crashSafeReplicationInput(): boolean | cdktf.IResolvable | undefined;
    private _diskAutoresize?;
    get diskAutoresize(): boolean | cdktf.IResolvable | undefined;
    set diskAutoresize(value: boolean | cdktf.IResolvable | undefined);
    resetDiskAutoresize(): void;
    get diskAutoresizeInput(): boolean | cdktf.IResolvable | undefined;
    private _diskAutoresizeLimit?;
    get diskAutoresizeLimit(): number | undefined;
    set diskAutoresizeLimit(value: number | undefined);
    resetDiskAutoresizeLimit(): void;
    get diskAutoresizeLimitInput(): number | undefined;
    private _diskSize?;
    get diskSize(): number | undefined;
    set diskSize(value: number | undefined);
    resetDiskSize(): void;
    get diskSizeInput(): number | undefined;
    private _diskType?;
    get diskType(): string | undefined;
    set diskType(value: string | undefined);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _pricingPlan?;
    get pricingPlan(): string | undefined;
    set pricingPlan(value: string | undefined);
    resetPricingPlan(): void;
    get pricingPlanInput(): string | undefined;
    private _replicationType?;
    get replicationType(): string | undefined;
    set replicationType(value: string | undefined);
    resetReplicationType(): void;
    get replicationTypeInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _userLabels?;
    get userLabels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set userLabels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetUserLabels(): void;
    get userLabelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _backupConfiguration?;
    private __backupConfigurationOutput;
    get backupConfiguration(): SqlDatabaseInstanceSettingsBackupConfigurationOutputReference;
    putBackupConfiguration(value: SqlDatabaseInstanceSettingsBackupConfiguration | undefined): void;
    resetBackupConfiguration(): void;
    get backupConfigurationInput(): SqlDatabaseInstanceSettingsBackupConfiguration | undefined;
    private _databaseFlags?;
    get databaseFlags(): SqlDatabaseInstanceSettingsDatabaseFlags[] | undefined;
    set databaseFlags(value: SqlDatabaseInstanceSettingsDatabaseFlags[] | undefined);
    resetDatabaseFlags(): void;
    get databaseFlagsInput(): SqlDatabaseInstanceSettingsDatabaseFlags[] | undefined;
    private _insightsConfig?;
    private __insightsConfigOutput;
    get insightsConfig(): SqlDatabaseInstanceSettingsInsightsConfigOutputReference;
    putInsightsConfig(value: SqlDatabaseInstanceSettingsInsightsConfig | undefined): void;
    resetInsightsConfig(): void;
    get insightsConfigInput(): SqlDatabaseInstanceSettingsInsightsConfig | undefined;
    private _ipConfiguration?;
    private __ipConfigurationOutput;
    get ipConfiguration(): SqlDatabaseInstanceSettingsIpConfigurationOutputReference;
    putIpConfiguration(value: SqlDatabaseInstanceSettingsIpConfiguration | undefined): void;
    resetIpConfiguration(): void;
    get ipConfigurationInput(): SqlDatabaseInstanceSettingsIpConfiguration | undefined;
    private _locationPreference?;
    private __locationPreferenceOutput;
    get locationPreference(): SqlDatabaseInstanceSettingsLocationPreferenceOutputReference;
    putLocationPreference(value: SqlDatabaseInstanceSettingsLocationPreference | undefined): void;
    resetLocationPreference(): void;
    get locationPreferenceInput(): SqlDatabaseInstanceSettingsLocationPreference | undefined;
    private _maintenanceWindow?;
    private __maintenanceWindowOutput;
    get maintenanceWindow(): SqlDatabaseInstanceSettingsMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: SqlDatabaseInstanceSettingsMaintenanceWindow | undefined): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): SqlDatabaseInstanceSettingsMaintenanceWindow | undefined;
}
export interface SqlDatabaseInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#create SqlDatabaseInstance#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#delete SqlDatabaseInstance#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#update SqlDatabaseInstance#update}.
     */
    readonly update?: string;
}
export declare class SqlDatabaseInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html google_sql_database_instance}.
 */
export declare class SqlDatabaseInstance extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html google_sql_database_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: SqlDatabaseInstanceConfig);
    get connectionName(): string;
    private _databaseVersion?;
    get databaseVersion(): string | undefined;
    set databaseVersion(value: string | undefined);
    resetDatabaseVersion(): void;
    get databaseVersionInput(): string | undefined;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable | undefined;
    set deletionProtection(value: boolean | cdktf.IResolvable | undefined);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    get firstIpAddress(): string;
    get id(): string;
    ipAddress(index: string): SqlDatabaseInstanceIpAddress;
    private _masterInstanceName?;
    get masterInstanceName(): string | undefined;
    set masterInstanceName(value: string | undefined);
    resetMasterInstanceName(): void;
    get masterInstanceNameInput(): string | undefined;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    get privateIpAddress(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get publicIpAddress(): string;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _rootPassword?;
    get rootPassword(): string | undefined;
    set rootPassword(value: string | undefined);
    resetRootPassword(): void;
    get rootPasswordInput(): string | undefined;
    get selfLink(): string;
    serverCaCert(index: string): SqlDatabaseInstanceServerCaCert;
    get serviceAccountEmailAddress(): string;
    private _clone?;
    private __cloneOutput;
    get clone(): SqlDatabaseInstanceCloneOutputReference;
    putClone(value: SqlDatabaseInstanceClone | undefined): void;
    resetClone(): void;
    get cloneInput(): SqlDatabaseInstanceClone | undefined;
    private _replicaConfiguration?;
    private __replicaConfigurationOutput;
    get replicaConfiguration(): SqlDatabaseInstanceReplicaConfigurationOutputReference;
    putReplicaConfiguration(value: SqlDatabaseInstanceReplicaConfiguration | undefined): void;
    resetReplicaConfiguration(): void;
    get replicaConfigurationInput(): SqlDatabaseInstanceReplicaConfiguration | undefined;
    private _restoreBackupContext?;
    private __restoreBackupContextOutput;
    get restoreBackupContext(): SqlDatabaseInstanceRestoreBackupContextOutputReference;
    putRestoreBackupContext(value: SqlDatabaseInstanceRestoreBackupContext | undefined): void;
    resetRestoreBackupContext(): void;
    get restoreBackupContextInput(): SqlDatabaseInstanceRestoreBackupContext | undefined;
    private _settings?;
    private __settingsOutput;
    get settings(): SqlDatabaseInstanceSettingsOutputReference;
    putSettings(value: SqlDatabaseInstanceSettings | undefined): void;
    resetSettings(): void;
    get settingsInput(): SqlDatabaseInstanceSettings | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): SqlDatabaseInstanceTimeoutsOutputReference;
    putTimeouts(value: SqlDatabaseInstanceTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): SqlDatabaseInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
