import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpannerDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional list of DDL statements to run inside the newly created database.
     *
     * Statements can create tables, indexes, etc. These statements
     * execute atomically with the creation of the database: if there is an
     * error in any statement, the database is not created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#ddl SpannerDatabase#ddl}
     */
    readonly ddl?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#deletion_protection SpannerDatabase#deletion_protection}.
     */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
     * The instance to create the database on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#instance SpannerDatabase#instance}
     */
    readonly instance: string;
    /**
     * A unique identifier for the database, which cannot be changed after the instance is created.
     *
     * Values are of the form [a-z][-a-z0-9]*[a-z0-9].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#name SpannerDatabase#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#project SpannerDatabase#project}.
     */
    readonly project?: string;
    /**
     * encryption_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#encryption_config SpannerDatabase#encryption_config}
     */
    readonly encryptionConfig?: SpannerDatabaseEncryptionConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#timeouts SpannerDatabase#timeouts}
     */
    readonly timeouts?: SpannerDatabaseTimeouts;
}
export interface SpannerDatabaseEncryptionConfig {
    /**
     * Fully qualified name of the KMS key to use to encrypt this database.
     *
     * This key must exist
     * in the same location as the Spanner Database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#kms_key_name SpannerDatabase#kms_key_name}
     */
    readonly kmsKeyName: string;
}
export declare class SpannerDatabaseEncryptionConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface SpannerDatabaseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#create SpannerDatabase#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#delete SpannerDatabase#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#update SpannerDatabase#update}.
     */
    readonly update?: string;
}
export declare class SpannerDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html google_spanner_database}.
 */
export declare class SpannerDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html google_spanner_database} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: SpannerDatabaseConfig);
    private _ddl?;
    get ddl(): string[] | undefined;
    set ddl(value: string[] | undefined);
    resetDdl(): void;
    get ddlInput(): string[] | undefined;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable | undefined;
    set deletionProtection(value: boolean | cdktf.IResolvable | undefined);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _encryptionConfig?;
    private __encryptionConfigOutput;
    get encryptionConfig(): SpannerDatabaseEncryptionConfigOutputReference;
    putEncryptionConfig(value: SpannerDatabaseEncryptionConfig | undefined): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): SpannerDatabaseEncryptionConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): SpannerDatabaseTimeoutsOutputReference;
    putTimeouts(value: SpannerDatabaseTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): SpannerDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
