import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SourcerepoRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Resource name of the repository, of the form '{{repo}}'. The repo name may contain slashes. eg, 'name/with/slash'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository.html#name SourcerepoRepository#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository.html#project SourcerepoRepository#project}.
     */
    readonly project?: string;
    /**
     * pubsub_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository.html#pubsub_configs SourcerepoRepository#pubsub_configs}
     */
    readonly pubsubConfigs?: SourcerepoRepositoryPubsubConfigs[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository.html#timeouts SourcerepoRepository#timeouts}
     */
    readonly timeouts?: SourcerepoRepositoryTimeouts;
}
export interface SourcerepoRepositoryPubsubConfigs {
    /**
     * The format of the Cloud Pub/Sub messages.
     *
     * - PROTOBUF: The message payload is a serialized protocol buffer of SourceRepoEvent.
     * - JSON: The message payload is a JSON string of SourceRepoEvent. Possible values: ["PROTOBUF", "JSON"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository.html#message_format SourcerepoRepository#message_format}
     */
    readonly messageFormat: string;
    /**
     * Email address of the service account used for publishing Cloud Pub/Sub messages.
     *
     * This service account needs to be in the same project as the PubsubConfig. When added,
     * the caller needs to have iam.serviceAccounts.actAs permission on this service account.
     * If unspecified, it defaults to the compute engine default service account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository.html#service_account_email SourcerepoRepository#service_account_email}
     */
    readonly serviceAccountEmail?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository.html#topic SourcerepoRepository#topic}.
     */
    readonly topic: string;
}
export interface SourcerepoRepositoryTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository.html#create SourcerepoRepository#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository.html#delete SourcerepoRepository#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository.html#update SourcerepoRepository#update}.
     */
    readonly update?: string;
}
export declare class SourcerepoRepositoryTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository.html google_sourcerepo_repository}.
 */
export declare class SourcerepoRepository extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository.html google_sourcerepo_repository} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: SourcerepoRepositoryConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get size(): number;
    get url(): string;
    private _pubsubConfigs?;
    get pubsubConfigs(): SourcerepoRepositoryPubsubConfigs[] | undefined;
    set pubsubConfigs(value: SourcerepoRepositoryPubsubConfigs[] | undefined);
    resetPubsubConfigs(): void;
    get pubsubConfigsInput(): SourcerepoRepositoryPubsubConfigs[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): SourcerepoRepositoryTimeoutsOutputReference;
    putTimeouts(value: SourcerepoRepositoryTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): SourcerepoRepositoryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
