import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SourcerepoRepositoryIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_policy.html#policy_data SourcerepoRepositoryIamPolicy#policy_data}.
     */
    readonly policyData: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_policy.html#project SourcerepoRepositoryIamPolicy#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_policy.html#repository SourcerepoRepositoryIamPolicy#repository}.
     */
    readonly repository: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_policy.html google_sourcerepo_repository_iam_policy}.
 */
export declare class SourcerepoRepositoryIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_policy.html google_sourcerepo_repository_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: SourcerepoRepositoryIamPolicyConfig);
    get etag(): string;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
