import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceNetworkingPeeredDnsDomainConfig extends cdktf.TerraformMetaArguments {
    /**
     * The DNS domain name suffix of the peered DNS domain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#dns_suffix ServiceNetworkingPeeredDnsDomain#dns_suffix}
     */
    readonly dnsSuffix: string;
    /**
     * Name of the peered DNS domain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#name ServiceNetworkingPeeredDnsDomain#name}
     */
    readonly name: string;
    /**
     * Network in the consumer project to peer with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#network ServiceNetworkingPeeredDnsDomain#network}
     */
    readonly network: string;
    /**
     * The ID of the project that the service account will be created in. Defaults to the provider project configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#project ServiceNetworkingPeeredDnsDomain#project}
     */
    readonly project?: string;
    /**
     * The name of the service to create a peered DNS domain for, e.g. servicenetworking.googleapis.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#service ServiceNetworkingPeeredDnsDomain#service}
     */
    readonly service?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#timeouts ServiceNetworkingPeeredDnsDomain#timeouts}
     */
    readonly timeouts?: ServiceNetworkingPeeredDnsDomainTimeouts;
}
export interface ServiceNetworkingPeeredDnsDomainTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#create ServiceNetworkingPeeredDnsDomain#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#delete ServiceNetworkingPeeredDnsDomain#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html#read ServiceNetworkingPeeredDnsDomain#read}.
     */
    readonly read?: string;
}
export declare class ServiceNetworkingPeeredDnsDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string | undefined;
    set read(value: string | undefined);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html google_service_networking_peered_dns_domain}.
 */
export declare class ServiceNetworkingPeeredDnsDomain extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain.html google_service_networking_peered_dns_domain} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ServiceNetworkingPeeredDnsDomainConfig);
    private _dnsSuffix?;
    get dnsSuffix(): string;
    set dnsSuffix(value: string);
    get dnsSuffixInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    get parent(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string | undefined;
    set service(value: string | undefined);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ServiceNetworkingPeeredDnsDomainTimeoutsOutputReference;
    putTimeouts(value: ServiceNetworkingPeeredDnsDomainTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServiceNetworkingPeeredDnsDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
