import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * The account id that is used to generate the service account email address and a stable unique id.
     *
     * It is unique within a project, must be 6-30 characters long, and match the regular expression [a-z]([-a-z0-9]*[a-z0-9]) to comply with RFC1035. Changing this forces a new service account to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account.html#account_id ServiceAccount#account_id}
     */
    readonly accountId: string;
    /**
     * A text description of the service account. Must be less than or equal to 256 UTF-8 bytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account.html#description ServiceAccount#description}
     */
    readonly description?: string;
    /**
     * Whether the service account is disabled. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account.html#disabled ServiceAccount#disabled}
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * The display name for the service account. Can be updated without creating a new resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account.html#display_name ServiceAccount#display_name}
     */
    readonly displayName?: string;
    /**
     * The ID of the project that the service account will be created in. Defaults to the provider project configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account.html#project ServiceAccount#project}
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account.html#timeouts ServiceAccount#timeouts}
     */
    readonly timeouts?: ServiceAccountTimeouts;
}
export interface ServiceAccountTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account.html#create ServiceAccount#create}.
     */
    readonly create?: string;
}
export declare class ServiceAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/service_account.html google_service_account}.
 */
export declare class ServiceAccount extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_account.html google_service_account} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ServiceAccountConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable | undefined;
    set disabled(value: boolean | cdktf.IResolvable | undefined);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get email(): string;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get uniqueId(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ServiceAccountTimeoutsOutputReference;
    putTimeouts(value: ServiceAccountTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServiceAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
