import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecretManagerSecretConfig extends cdktf.TerraformMetaArguments {
    /**
     * Timestamp in UTC when the Secret is scheduled to expire.
     *
     * This is always provided on output, regardless of what was sent on input.
     * A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#expire_time SecretManagerSecret#expire_time}
     */
    readonly expireTime?: string;
    /**
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
     * and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
     * and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
     *
     * No more than 64 labels can be assigned to a given resource.
     *
     * An object containing a list of "key": value pairs. Example:
     * { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#labels SecretManagerSecret#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#project SecretManagerSecret#project}.
     */
    readonly project?: string;
    /**
     * This must be unique within the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#secret_id SecretManagerSecret#secret_id}
     */
    readonly secretId: string;
    /**
     * The TTL for the Secret. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#ttl SecretManagerSecret#ttl}
     */
    readonly ttl?: string;
    /**
     * replication block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#replication SecretManagerSecret#replication}
     */
    readonly replication: SecretManagerSecretReplication;
    /**
     * rotation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#rotation SecretManagerSecret#rotation}
     */
    readonly rotation?: SecretManagerSecretRotation;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#timeouts SecretManagerSecret#timeouts}
     */
    readonly timeouts?: SecretManagerSecretTimeouts;
    /**
     * topics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#topics SecretManagerSecret#topics}
     */
    readonly topics?: SecretManagerSecretTopics[];
}
export interface SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination secret.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#kms_key_name SecretManagerSecret#kms_key_name}
     */
    readonly kmsKeyName: string;
}
export declare class SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface SecretManagerSecretReplicationUserManagedReplicas {
    /**
     * The canonical IDs of the location to replicate data. For example: "us-east1".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#location SecretManagerSecret#location}
     */
    readonly location: string;
    /**
     * customer_managed_encryption block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#customer_managed_encryption SecretManagerSecret#customer_managed_encryption}
     */
    readonly customerManagedEncryption?: SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption;
}
export interface SecretManagerSecretReplicationUserManaged {
    /**
     * replicas block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#replicas SecretManagerSecret#replicas}
     */
    readonly replicas: SecretManagerSecretReplicationUserManagedReplicas[];
}
export declare class SecretManagerSecretReplicationUserManagedOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _replicas?;
    get replicas(): SecretManagerSecretReplicationUserManagedReplicas[];
    set replicas(value: SecretManagerSecretReplicationUserManagedReplicas[]);
    get replicasInput(): SecretManagerSecretReplicationUserManagedReplicas[] | undefined;
}
export interface SecretManagerSecretReplication {
    /**
     * The Secret will automatically be replicated without any restrictions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#automatic SecretManagerSecret#automatic}
     */
    readonly automatic?: boolean | cdktf.IResolvable;
    /**
     * user_managed block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#user_managed SecretManagerSecret#user_managed}
     */
    readonly userManaged?: SecretManagerSecretReplicationUserManaged;
}
export declare class SecretManagerSecretReplicationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _automatic?;
    get automatic(): boolean | cdktf.IResolvable | undefined;
    set automatic(value: boolean | cdktf.IResolvable | undefined);
    resetAutomatic(): void;
    get automaticInput(): boolean | cdktf.IResolvable | undefined;
    private _userManaged?;
    private __userManagedOutput;
    get userManaged(): SecretManagerSecretReplicationUserManagedOutputReference;
    putUserManaged(value: SecretManagerSecretReplicationUserManaged | undefined): void;
    resetUserManaged(): void;
    get userManagedInput(): SecretManagerSecretReplicationUserManaged | undefined;
}
export interface SecretManagerSecretRotation {
    /**
     * Timestamp in UTC at which the Secret is scheduled to rotate.
     *
     * A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#next_rotation_time SecretManagerSecret#next_rotation_time}
     */
    readonly nextRotationTime?: string;
    /**
     * The Duration between rotation notifications.
     *
     * Must be in seconds and at least 3600s (1h) and at most 3153600000s (100 years).
     * If rotationPeriod is set, 'next_rotation_time' must be set. 'next_rotation_time' will be advanced by this period when the service automatically sends rotation notifications.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#rotation_period SecretManagerSecret#rotation_period}
     */
    readonly rotationPeriod?: string;
}
export declare class SecretManagerSecretRotationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nextRotationTime?;
    get nextRotationTime(): string | undefined;
    set nextRotationTime(value: string | undefined);
    resetNextRotationTime(): void;
    get nextRotationTimeInput(): string | undefined;
    private _rotationPeriod?;
    get rotationPeriod(): string | undefined;
    set rotationPeriod(value: string | undefined);
    resetRotationPeriod(): void;
    get rotationPeriodInput(): string | undefined;
}
export interface SecretManagerSecretTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#create SecretManagerSecret#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#delete SecretManagerSecret#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#update SecretManagerSecret#update}.
     */
    readonly update?: string;
}
export declare class SecretManagerSecretTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface SecretManagerSecretTopics {
    /**
     * The resource name of the Pub/Sub topic that will be published to, in the following format: projects/*\/topics/*.
     *
     * For publication to succeed, the Secret Manager Service Agent service account must have pubsub.publisher permissions on the topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#name SecretManagerSecret#name}
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html google_secret_manager_secret}.
 */
export declare class SecretManagerSecret extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html google_secret_manager_secret} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: SecretManagerSecretConfig);
    get createTime(): string;
    private _expireTime?;
    get expireTime(): string | undefined;
    set expireTime(value: string | undefined);
    resetExpireTime(): void;
    get expireTimeInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
    private _ttl?;
    get ttl(): string | undefined;
    set ttl(value: string | undefined);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _replication?;
    private __replicationOutput;
    get replication(): SecretManagerSecretReplicationOutputReference;
    putReplication(value: SecretManagerSecretReplication): void;
    get replicationInput(): SecretManagerSecretReplication | undefined;
    private _rotation?;
    private __rotationOutput;
    get rotation(): SecretManagerSecretRotationOutputReference;
    putRotation(value: SecretManagerSecretRotation | undefined): void;
    resetRotation(): void;
    get rotationInput(): SecretManagerSecretRotation | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): SecretManagerSecretTimeoutsOutputReference;
    putTimeouts(value: SecretManagerSecretTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): SecretManagerSecretTimeouts | undefined;
    private _topics?;
    get topics(): SecretManagerSecretTopics[] | undefined;
    set topics(value: SecretManagerSecretTopics[] | undefined);
    resetTopics(): void;
    get topicsInput(): SecretManagerSecretTopics[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
