import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecretManagerSecretIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_policy.html#policy_data SecretManagerSecretIamPolicy#policy_data}.
     */
    readonly policyData: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_policy.html#project SecretManagerSecretIamPolicy#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_policy.html#secret_id SecretManagerSecretIamPolicy#secret_id}.
     */
    readonly secretId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_policy.html google_secret_manager_secret_iam_policy}.
 */
export declare class SecretManagerSecretIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_policy.html google_secret_manager_secret_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: SecretManagerSecretIamPolicyConfig);
    get etag(): string;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
