import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SccNotificationConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * This must be unique within the organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#config_id SccNotificationConfig#config_id}
     */
    readonly configId: string;
    /**
     * The description of the notification config (max of 1024 characters).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#description SccNotificationConfig#description}
     */
    readonly description?: string;
    /**
     * The organization whose Cloud Security Command Center the Notification Config lives in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#organization SccNotificationConfig#organization}
     */
    readonly organization: string;
    /**
     * The Pub/Sub topic to send notifications to. Its format is "projects/[project_id]/topics/[topic]".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#pubsub_topic SccNotificationConfig#pubsub_topic}
     */
    readonly pubsubTopic: string;
    /**
     * streaming_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#streaming_config SccNotificationConfig#streaming_config}
     */
    readonly streamingConfig: SccNotificationConfigStreamingConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#timeouts SccNotificationConfig#timeouts}
     */
    readonly timeouts?: SccNotificationConfigTimeouts;
}
export interface SccNotificationConfigStreamingConfig {
    /**
     * Expression that defines the filter to apply across create/update events of assets or findings as specified by the event type.
     *
     * The
     * expression is a list of zero or more restrictions combined via
     * logical operators AND and OR. Parentheses are supported, and OR
     * has higher precedence than AND.
     *
     * Restrictions have the form <field> <operator> <value> and may have
     * a - character in front of them to indicate negation. The fields
     * map to those defined in the corresponding resource.
     *
     * The supported operators are:
     *
     * = for all value types.
     * >, <, >=, <= for integer values.
     * :, meaning substring matching, for strings.
     *
     * The supported value types are:
     *
     * string literals in quotes.
     * integer literals without quotes.
     * boolean literals true and false without quotes.
     *
     * See
     * [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
     * for information on how to write a filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#filter SccNotificationConfig#filter}
     */
    readonly filter: string;
}
export declare class SccNotificationConfigStreamingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
}
export interface SccNotificationConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#create SccNotificationConfig#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#delete SccNotificationConfig#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html#update SccNotificationConfig#update}.
     */
    readonly update?: string;
}
export declare class SccNotificationConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html google_scc_notification_config}.
 */
export declare class SccNotificationConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/scc_notification_config.html google_scc_notification_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: SccNotificationConfigConfig);
    private _configId?;
    get configId(): string;
    set configId(value: string);
    get configIdInput(): string | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _pubsubTopic?;
    get pubsubTopic(): string;
    set pubsubTopic(value: string);
    get pubsubTopicInput(): string | undefined;
    get serviceAccount(): string;
    private _streamingConfig?;
    private __streamingConfigOutput;
    get streamingConfig(): SccNotificationConfigStreamingConfigOutputReference;
    putStreamingConfig(value: SccNotificationConfigStreamingConfig): void;
    get streamingConfigInput(): SccNotificationConfigStreamingConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): SccNotificationConfigTimeoutsOutputReference;
    putTimeouts(value: SccNotificationConfigTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): SccNotificationConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
