import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RuntimeconfigVariableConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the variable to manage. Note that variable names can be hierarchical using slashes (e.g. "prod-variables/hostname").
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_variable.html#name RuntimeconfigVariable#name}
     */
    readonly name: string;
    /**
     * The name of the RuntimeConfig resource containing this variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_variable.html#parent RuntimeconfigVariable#parent}
     */
    readonly parent: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_variable.html#project RuntimeconfigVariable#project}
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_variable.html#text RuntimeconfigVariable#text}.
     */
    readonly text?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_variable.html#value RuntimeconfigVariable#value}.
     */
    readonly value?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_variable.html google_runtimeconfig_variable}.
 */
export declare class RuntimeconfigVariable extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_variable.html google_runtimeconfig_variable} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: RuntimeconfigVariableConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _text?;
    get text(): string | undefined;
    set text(value: string | undefined);
    resetText(): void;
    get textInput(): string | undefined;
    get updateTime(): string;
    private _value?;
    get value(): string | undefined;
    set value(value: string | undefined);
    resetValue(): void;
    get valueInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
