import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RuntimeconfigConfigIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_policy.html#config RuntimeconfigConfigIamPolicy#config}.
     */
    readonly config: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_policy.html#policy_data RuntimeconfigConfigIamPolicy#policy_data}.
     */
    readonly policyData: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_policy.html#project RuntimeconfigConfigIamPolicy#project}.
     */
    readonly project?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_policy.html google_runtimeconfig_config_iam_policy}.
 */
export declare class RuntimeconfigConfigIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_policy.html google_runtimeconfig_config_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: RuntimeconfigConfigIamPolicyConfig);
    private _config?;
    get config(): string;
    set config(value: string);
    get configInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
