import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PubsubTopicConfig extends cdktf.TerraformMetaArguments {
    /**
     * The resource name of the Cloud KMS CryptoKey to be used to protect access to messages published on this topic.
     *
     * Your project's PubSub service account
     * ('service-{{PROJECT_NUMBER}}@gcp-sa-pubsub.iam.gserviceaccount.com') must have
     * 'roles/cloudkms.cryptoKeyEncrypterDecrypter' to use this feature.
     * The expected format is 'projects/*\/locations/*\/keyRings/*\/cryptoKeys/*'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#kms_key_name PubsubTopic#kms_key_name}
     */
    readonly kmsKeyName?: string;
    /**
     * A set of key/value label pairs to assign to this Topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#labels PubsubTopic#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#name PubsubTopic#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#project PubsubTopic#project}.
     */
    readonly project?: string;
    /**
     * message_storage_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#message_storage_policy PubsubTopic#message_storage_policy}
     */
    readonly messageStoragePolicy?: PubsubTopicMessageStoragePolicy;
    /**
     * schema_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#schema_settings PubsubTopic#schema_settings}
     */
    readonly schemaSettings?: PubsubTopicSchemaSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#timeouts PubsubTopic#timeouts}
     */
    readonly timeouts?: PubsubTopicTimeouts;
}
export interface PubsubTopicMessageStoragePolicy {
    /**
     * A list of IDs of GCP regions where messages that are published to the topic may be persisted in storage.
     *
     * Messages published by
     * publishers running in non-allowed GCP regions (or running outside
     * of GCP altogether) will be routed for storage in one of the
     * allowed regions. An empty list means that no regions are allowed,
     * and is not a valid configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#allowed_persistence_regions PubsubTopic#allowed_persistence_regions}
     */
    readonly allowedPersistenceRegions: string[];
}
export declare class PubsubTopicMessageStoragePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowedPersistenceRegions?;
    get allowedPersistenceRegions(): string[];
    set allowedPersistenceRegions(value: string[]);
    get allowedPersistenceRegionsInput(): string[] | undefined;
}
export interface PubsubTopicSchemaSettings {
    /**
     * The encoding of messages validated against schema. Default value: "ENCODING_UNSPECIFIED" Possible values: ["ENCODING_UNSPECIFIED", "JSON", "BINARY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#encoding PubsubTopic#encoding}
     */
    readonly encoding?: string;
    /**
     * The name of the schema that messages published should be validated against.
     *
     * Format is projects/{project}/schemas/{schema}.
     * The value of this field will be _deleted-schema_
     * if the schema has been deleted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#schema PubsubTopic#schema}
     */
    readonly schema: string;
}
export declare class PubsubTopicSchemaSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _encoding?;
    get encoding(): string | undefined;
    set encoding(value: string | undefined);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
}
export interface PubsubTopicTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#create PubsubTopic#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#delete PubsubTopic#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html#update PubsubTopic#update}.
     */
    readonly update?: string;
}
export declare class PubsubTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html google_pubsub_topic}.
 */
export declare class PubsubTopic extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic.html google_pubsub_topic} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: PubsubTopicConfig);
    get id(): string;
    private _kmsKeyName?;
    get kmsKeyName(): string | undefined;
    set kmsKeyName(value: string | undefined);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _messageStoragePolicy?;
    private __messageStoragePolicyOutput;
    get messageStoragePolicy(): PubsubTopicMessageStoragePolicyOutputReference;
    putMessageStoragePolicy(value: PubsubTopicMessageStoragePolicy | undefined): void;
    resetMessageStoragePolicy(): void;
    get messageStoragePolicyInput(): PubsubTopicMessageStoragePolicy | undefined;
    private _schemaSettings?;
    private __schemaSettingsOutput;
    get schemaSettings(): PubsubTopicSchemaSettingsOutputReference;
    putSchemaSettings(value: PubsubTopicSchemaSettings | undefined): void;
    resetSchemaSettings(): void;
    get schemaSettingsInput(): PubsubTopicSchemaSettings | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): PubsubTopicTimeoutsOutputReference;
    putTimeouts(value: PubsubTopicTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): PubsubTopicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
