import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PubsubSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * This value is the maximum time after a subscriber receives a message before the subscriber should acknowledge the message.
     *
     * After message
     * delivery but before the ack deadline expires and before the message is
     * acknowledged, it is an outstanding message and will not be delivered
     * again during that time (on a best-effort basis).
     *
     * For pull subscriptions, this value is used as the initial value for
     * the ack deadline. To override this value for a given message, call
     * subscriptions.modifyAckDeadline with the corresponding ackId if using
     * pull. The minimum custom deadline you can specify is 10 seconds. The
     * maximum custom deadline you can specify is 600 seconds (10 minutes).
     * If this parameter is 0, a default value of 10 seconds is used.
     *
     * For push delivery, this value is also used to set the request timeout
     * for the call to the push endpoint.
     *
     * If the subscriber never acknowledges the message, the Pub/Sub system
     * will eventually redeliver the message.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#ack_deadline_seconds PubsubSubscription#ack_deadline_seconds}
     */
    readonly ackDeadlineSeconds?: number;
    /**
     * If 'true', messages published with the same orderingKey in PubsubMessage will be delivered to the subscribers in the order in which they are received by the Pub/Sub system.
     *
     * Otherwise, they
     * may be delivered in any order.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#enable_message_ordering PubsubSubscription#enable_message_ordering}
     */
    readonly enableMessageOrdering?: boolean | cdktf.IResolvable;
    /**
     * The subscription only delivers the messages that match the filter.
     *
     * Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
     * by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
     * you can't modify the filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#filter PubsubSubscription#filter}
     */
    readonly filter?: string;
    /**
     * A set of key/value label pairs to assign to this Subscription.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#labels PubsubSubscription#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * How long to retain unacknowledged messages in the subscription's backlog, from the moment a message is published.
     *
     * If
     * retainAckedMessages is true, then this also configures the retention
     * of acknowledged messages, and thus configures how far back in time a
     * subscriptions.seek can be done. Defaults to 7 days. Cannot be more
     * than 7 days ('"604800s"') or less than 10 minutes ('"600s"').
     *
     * A duration in seconds with up to nine fractional digits, terminated
     * by 's'. Example: '"600.5s"'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#message_retention_duration PubsubSubscription#message_retention_duration}
     */
    readonly messageRetentionDuration?: string;
    /**
     * Name of the subscription.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#name PubsubSubscription#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#project PubsubSubscription#project}.
     */
    readonly project?: string;
    /**
     * Indicates whether to retain acknowledged messages.
     *
     * If 'true', then
     * messages are not expunged from the subscription's backlog, even if
     * they are acknowledged, until they fall out of the
     * messageRetentionDuration window.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#retain_acked_messages PubsubSubscription#retain_acked_messages}
     */
    readonly retainAckedMessages?: boolean | cdktf.IResolvable;
    /**
     * A reference to a Topic resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#topic PubsubSubscription#topic}
     */
    readonly topic: string;
    /**
     * dead_letter_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#dead_letter_policy PubsubSubscription#dead_letter_policy}
     */
    readonly deadLetterPolicy?: PubsubSubscriptionDeadLetterPolicy;
    /**
     * expiration_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#expiration_policy PubsubSubscription#expiration_policy}
     */
    readonly expirationPolicy?: PubsubSubscriptionExpirationPolicy;
    /**
     * push_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#push_config PubsubSubscription#push_config}
     */
    readonly pushConfig?: PubsubSubscriptionPushConfig;
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#retry_policy PubsubSubscription#retry_policy}
     */
    readonly retryPolicy?: PubsubSubscriptionRetryPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#timeouts PubsubSubscription#timeouts}
     */
    readonly timeouts?: PubsubSubscriptionTimeouts;
}
export interface PubsubSubscriptionDeadLetterPolicy {
    /**
     * The name of the topic to which dead letter messages should be published. Format is 'projects/{project}/topics/{topic}'.
     *
     * The Cloud Pub/Sub service account associated with the enclosing subscription's
     * parent project (i.e.,
     * service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Publish() to this topic.
     *
     * The operation will fail if the topic does not exist.
     * Users should ensure that there is a subscription attached to this topic
     * since messages published to a topic with no subscriptions are lost.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#dead_letter_topic PubsubSubscription#dead_letter_topic}
     */
    readonly deadLetterTopic?: string;
    /**
     * The maximum number of delivery attempts for any message. The value must be between 5 and 100.
     *
     * The number of delivery attempts is defined as 1 + (the sum of number of
     * NACKs and number of times the acknowledgement deadline has been exceeded for the message).
     *
     * A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
     * client libraries may automatically extend ack_deadlines.
     *
     * This field will be honored on a best effort basis.
     *
     * If this parameter is 0, a default value of 5 is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#max_delivery_attempts PubsubSubscription#max_delivery_attempts}
     */
    readonly maxDeliveryAttempts?: number;
}
export declare class PubsubSubscriptionDeadLetterPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _deadLetterTopic?;
    get deadLetterTopic(): string | undefined;
    set deadLetterTopic(value: string | undefined);
    resetDeadLetterTopic(): void;
    get deadLetterTopicInput(): string | undefined;
    private _maxDeliveryAttempts?;
    get maxDeliveryAttempts(): number | undefined;
    set maxDeliveryAttempts(value: number | undefined);
    resetMaxDeliveryAttempts(): void;
    get maxDeliveryAttemptsInput(): number | undefined;
}
export interface PubsubSubscriptionExpirationPolicy {
    /**
     * Specifies the "time-to-live" duration for an associated resource.
     *
     * The
     * resource expires if it is not active for a period of ttl.
     * If ttl is not set, the associated resource never expires.
     * A duration in seconds with up to nine fractional digits, terminated by 's'.
     * Example - "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#ttl PubsubSubscription#ttl}
     */
    readonly ttl: string;
}
export declare class PubsubSubscriptionExpirationPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    get ttlInput(): string | undefined;
}
export interface PubsubSubscriptionPushConfigOidcToken {
    /**
     * Audience to be used when generating OIDC token.
     *
     * The audience claim
     * identifies the recipients that the JWT is intended for. The audience
     * value is a single case-sensitive string. Having multiple values (array)
     * for the audience field is not supported. More info about the OIDC JWT
     * token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
     * Note: if not specified, the Push endpoint URL will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#audience PubsubSubscription#audience}
     */
    readonly audience?: string;
    /**
     * Service account email to be used for generating the OIDC token.
     *
     * The caller (for subscriptions.create, subscriptions.patch, and
     * subscriptions.modifyPushConfig RPCs) must have the
     * iam.serviceAccounts.actAs permission for the service account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#service_account_email PubsubSubscription#service_account_email}
     */
    readonly serviceAccountEmail: string;
}
export declare class PubsubSubscriptionPushConfigOidcTokenOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _audience?;
    get audience(): string | undefined;
    set audience(value: string | undefined);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    get serviceAccountEmailInput(): string | undefined;
}
export interface PubsubSubscriptionPushConfig {
    /**
     * Endpoint configuration attributes.
     *
     * Every endpoint has a set of API supported attributes that can
     * be used to control different aspects of the message delivery.
     *
     * The currently supported attribute is x-goog-version, which you
     * can use to change the format of the pushed message. This
     * attribute indicates the version of the data expected by
     * the endpoint. This controls the shape of the pushed message
     * (i.e., its fields and metadata). The endpoint version is
     * based on the version of the Pub/Sub API.
     *
     * If not present during the subscriptions.create call,
     * it will default to the version of the API used to make
     * such call. If not present during a subscriptions.modifyPushConfig
     * call, its value will not be changed. subscriptions.get
     * calls will always return a valid version, even if the
     * subscription was created without this attribute.
     *
     * The possible values for this attribute are:
     *
     * - v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.
     * - v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#attributes PubsubSubscription#attributes}
     */
    readonly attributes?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * A URL locating the endpoint to which messages should be pushed. For example, a Webhook endpoint might use "https://example.com/push".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#push_endpoint PubsubSubscription#push_endpoint}
     */
    readonly pushEndpoint: string;
    /**
     * oidc_token block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#oidc_token PubsubSubscription#oidc_token}
     */
    readonly oidcToken?: PubsubSubscriptionPushConfigOidcToken;
}
export declare class PubsubSubscriptionPushConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _attributes?;
    get attributes(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set attributes(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetAttributes(): void;
    get attributesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _pushEndpoint?;
    get pushEndpoint(): string;
    set pushEndpoint(value: string);
    get pushEndpointInput(): string | undefined;
    private _oidcToken?;
    private __oidcTokenOutput;
    get oidcToken(): PubsubSubscriptionPushConfigOidcTokenOutputReference;
    putOidcToken(value: PubsubSubscriptionPushConfigOidcToken | undefined): void;
    resetOidcToken(): void;
    get oidcTokenInput(): PubsubSubscriptionPushConfigOidcToken | undefined;
}
export interface PubsubSubscriptionRetryPolicy {
    /**
     * The maximum delay between consecutive deliveries of a given message.
     *
     * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#maximum_backoff PubsubSubscription#maximum_backoff}
     */
    readonly maximumBackoff?: string;
    /**
     * The minimum delay between consecutive deliveries of a given message.
     *
     * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#minimum_backoff PubsubSubscription#minimum_backoff}
     */
    readonly minimumBackoff?: string;
}
export declare class PubsubSubscriptionRetryPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maximumBackoff?;
    get maximumBackoff(): string | undefined;
    set maximumBackoff(value: string | undefined);
    resetMaximumBackoff(): void;
    get maximumBackoffInput(): string | undefined;
    private _minimumBackoff?;
    get minimumBackoff(): string | undefined;
    set minimumBackoff(value: string | undefined);
    resetMinimumBackoff(): void;
    get minimumBackoffInput(): string | undefined;
}
export interface PubsubSubscriptionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#create PubsubSubscription#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#delete PubsubSubscription#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#update PubsubSubscription#update}.
     */
    readonly update?: string;
}
export declare class PubsubSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html google_pubsub_subscription}.
 */
export declare class PubsubSubscription extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html google_pubsub_subscription} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: PubsubSubscriptionConfig);
    private _ackDeadlineSeconds?;
    get ackDeadlineSeconds(): number | undefined;
    set ackDeadlineSeconds(value: number | undefined);
    resetAckDeadlineSeconds(): void;
    get ackDeadlineSecondsInput(): number | undefined;
    private _enableMessageOrdering?;
    get enableMessageOrdering(): boolean | cdktf.IResolvable | undefined;
    set enableMessageOrdering(value: boolean | cdktf.IResolvable | undefined);
    resetEnableMessageOrdering(): void;
    get enableMessageOrderingInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string | undefined;
    set filter(value: string | undefined);
    resetFilter(): void;
    get filterInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _messageRetentionDuration?;
    get messageRetentionDuration(): string | undefined;
    set messageRetentionDuration(value: string | undefined);
    resetMessageRetentionDuration(): void;
    get messageRetentionDurationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get path(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _retainAckedMessages?;
    get retainAckedMessages(): boolean | cdktf.IResolvable | undefined;
    set retainAckedMessages(value: boolean | cdktf.IResolvable | undefined);
    resetRetainAckedMessages(): void;
    get retainAckedMessagesInput(): boolean | cdktf.IResolvable | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
    private _deadLetterPolicy?;
    private __deadLetterPolicyOutput;
    get deadLetterPolicy(): PubsubSubscriptionDeadLetterPolicyOutputReference;
    putDeadLetterPolicy(value: PubsubSubscriptionDeadLetterPolicy | undefined): void;
    resetDeadLetterPolicy(): void;
    get deadLetterPolicyInput(): PubsubSubscriptionDeadLetterPolicy | undefined;
    private _expirationPolicy?;
    private __expirationPolicyOutput;
    get expirationPolicy(): PubsubSubscriptionExpirationPolicyOutputReference;
    putExpirationPolicy(value: PubsubSubscriptionExpirationPolicy | undefined): void;
    resetExpirationPolicy(): void;
    get expirationPolicyInput(): PubsubSubscriptionExpirationPolicy | undefined;
    private _pushConfig?;
    private __pushConfigOutput;
    get pushConfig(): PubsubSubscriptionPushConfigOutputReference;
    putPushConfig(value: PubsubSubscriptionPushConfig | undefined): void;
    resetPushConfig(): void;
    get pushConfigInput(): PubsubSubscriptionPushConfig | undefined;
    private _retryPolicy?;
    private __retryPolicyOutput;
    get retryPolicy(): PubsubSubscriptionRetryPolicyOutputReference;
    putRetryPolicy(value: PubsubSubscriptionRetryPolicy | undefined): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): PubsubSubscriptionRetryPolicy | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): PubsubSubscriptionTimeoutsOutputReference;
    putTimeouts(value: PubsubSubscriptionTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): PubsubSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
