import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PubsubSchemaConfig extends cdktf.TerraformMetaArguments {
    /**
     * The definition of the schema.
     *
     * This should contain a string representing the full definition of the schema
     * that is a valid schema definition of the type specified in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema.html#definition PubsubSchema#definition}
     */
    readonly definition?: string;
    /**
     * The ID to use for the schema, which will become the final component of the schema's resource name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema.html#name PubsubSchema#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema.html#project PubsubSchema#project}.
     */
    readonly project?: string;
    /**
     * The type of the schema definition Default value: "TYPE_UNSPECIFIED" Possible values: ["TYPE_UNSPECIFIED", "PROTOCOL_BUFFER", "AVRO"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema.html#type PubsubSchema#type}
     */
    readonly type?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema.html#timeouts PubsubSchema#timeouts}
     */
    readonly timeouts?: PubsubSchemaTimeouts;
}
export interface PubsubSchemaTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema.html#create PubsubSchema#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema.html#delete PubsubSchema#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema.html#update PubsubSchema#update}.
     */
    readonly update?: string;
}
export declare class PubsubSchemaTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema.html google_pubsub_schema}.
 */
export declare class PubsubSchema extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_schema.html google_pubsub_schema} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: PubsubSchemaConfig);
    private _definition?;
    get definition(): string | undefined;
    set definition(value: string | undefined);
    resetDefinition(): void;
    get definitionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    resetType(): void;
    get typeInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): PubsubSchemaTimeoutsOutputReference;
    putTimeouts(value: PubsubSchemaTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): PubsubSchemaTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
