import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PubsubLiteTopicConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#name PubsubLiteTopic#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#project PubsubLiteTopic#project}.
     */
    readonly project?: string;
    /**
     * The region of the pubsub lite topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#region PubsubLiteTopic#region}
     */
    readonly region?: string;
    /**
     * The zone of the pubsub lite topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#zone PubsubLiteTopic#zone}
     */
    readonly zone?: string;
    /**
     * partition_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#partition_config PubsubLiteTopic#partition_config}
     */
    readonly partitionConfig?: PubsubLiteTopicPartitionConfig;
    /**
     * reservation_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#reservation_config PubsubLiteTopic#reservation_config}
     */
    readonly reservationConfig?: PubsubLiteTopicReservationConfig;
    /**
     * retention_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#retention_config PubsubLiteTopic#retention_config}
     */
    readonly retentionConfig?: PubsubLiteTopicRetentionConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#timeouts PubsubLiteTopic#timeouts}
     */
    readonly timeouts?: PubsubLiteTopicTimeouts;
}
export interface PubsubLiteTopicPartitionConfigCapacity {
    /**
     * Subscribe throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#publish_mib_per_sec PubsubLiteTopic#publish_mib_per_sec}
     */
    readonly publishMibPerSec: number;
    /**
     * Publish throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#subscribe_mib_per_sec PubsubLiteTopic#subscribe_mib_per_sec}
     */
    readonly subscribeMibPerSec: number;
}
export declare class PubsubLiteTopicPartitionConfigCapacityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _publishMibPerSec?;
    get publishMibPerSec(): number;
    set publishMibPerSec(value: number);
    get publishMibPerSecInput(): number | undefined;
    private _subscribeMibPerSec?;
    get subscribeMibPerSec(): number;
    set subscribeMibPerSec(value: number);
    get subscribeMibPerSecInput(): number | undefined;
}
export interface PubsubLiteTopicPartitionConfig {
    /**
     * The number of partitions in the topic. Must be at least 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#count PubsubLiteTopic#count}
     */
    readonly count: number;
    /**
     * capacity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#capacity PubsubLiteTopic#capacity}
     */
    readonly capacity?: PubsubLiteTopicPartitionConfigCapacity;
}
export declare class PubsubLiteTopicPartitionConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _capacity?;
    private __capacityOutput;
    get capacity(): PubsubLiteTopicPartitionConfigCapacityOutputReference;
    putCapacity(value: PubsubLiteTopicPartitionConfigCapacity | undefined): void;
    resetCapacity(): void;
    get capacityInput(): PubsubLiteTopicPartitionConfigCapacity | undefined;
}
export interface PubsubLiteTopicReservationConfig {
    /**
     * The Reservation to use for this topic's throughput capacity.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#throughput_reservation PubsubLiteTopic#throughput_reservation}
     */
    readonly throughputReservation?: string;
}
export declare class PubsubLiteTopicReservationConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _throughputReservation?;
    get throughputReservation(): string | undefined;
    set throughputReservation(value: string | undefined);
    resetThroughputReservation(): void;
    get throughputReservationInput(): string | undefined;
}
export interface PubsubLiteTopicRetentionConfig {
    /**
     * The provisioned storage, in bytes, per partition.
     *
     * If the number of bytes stored
     * in any of the topic's partitions grows beyond this value, older messages will be
     * dropped to make room for newer ones, regardless of the value of period.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#per_partition_bytes PubsubLiteTopic#per_partition_bytes}
     */
    readonly perPartitionBytes: string;
    /**
     * How long a published message is retained.
     *
     * If unset, messages will be retained as
     * long as the bytes retained for each partition is below perPartitionBytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#period PubsubLiteTopic#period}
     */
    readonly period?: string;
}
export declare class PubsubLiteTopicRetentionConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _perPartitionBytes?;
    get perPartitionBytes(): string;
    set perPartitionBytes(value: string);
    get perPartitionBytesInput(): string | undefined;
    private _period?;
    get period(): string | undefined;
    set period(value: string | undefined);
    resetPeriod(): void;
    get periodInput(): string | undefined;
}
export interface PubsubLiteTopicTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#create PubsubLiteTopic#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#delete PubsubLiteTopic#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#update PubsubLiteTopic#update}.
     */
    readonly update?: string;
}
export declare class PubsubLiteTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html google_pubsub_lite_topic}.
 */
export declare class PubsubLiteTopic extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html google_pubsub_lite_topic} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: PubsubLiteTopicConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _partitionConfig?;
    private __partitionConfigOutput;
    get partitionConfig(): PubsubLiteTopicPartitionConfigOutputReference;
    putPartitionConfig(value: PubsubLiteTopicPartitionConfig | undefined): void;
    resetPartitionConfig(): void;
    get partitionConfigInput(): PubsubLiteTopicPartitionConfig | undefined;
    private _reservationConfig?;
    private __reservationConfigOutput;
    get reservationConfig(): PubsubLiteTopicReservationConfigOutputReference;
    putReservationConfig(value: PubsubLiteTopicReservationConfig | undefined): void;
    resetReservationConfig(): void;
    get reservationConfigInput(): PubsubLiteTopicReservationConfig | undefined;
    private _retentionConfig?;
    private __retentionConfigOutput;
    get retentionConfig(): PubsubLiteTopicRetentionConfigOutputReference;
    putRetentionConfig(value: PubsubLiteTopicRetentionConfig | undefined): void;
    resetRetentionConfig(): void;
    get retentionConfigInput(): PubsubLiteTopicRetentionConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): PubsubLiteTopicTimeoutsOutputReference;
    putTimeouts(value: PubsubLiteTopicTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): PubsubLiteTopicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
