import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PubsubLiteReservationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the reservation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_reservation.html#name PubsubLiteReservation#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_reservation.html#project PubsubLiteReservation#project}.
     */
    readonly project?: string;
    /**
     * The region of the pubsub lite reservation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_reservation.html#region PubsubLiteReservation#region}
     */
    readonly region?: string;
    /**
     * The reserved throughput capacity.
     *
     * Every unit of throughput capacity is
     * equivalent to 1 MiB/s of published messages or 2 MiB/s of subscribed
     * messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_reservation.html#throughput_capacity PubsubLiteReservation#throughput_capacity}
     */
    readonly throughputCapacity: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_reservation.html#timeouts PubsubLiteReservation#timeouts}
     */
    readonly timeouts?: PubsubLiteReservationTimeouts;
}
export interface PubsubLiteReservationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_reservation.html#create PubsubLiteReservation#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_reservation.html#delete PubsubLiteReservation#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_reservation.html#update PubsubLiteReservation#update}.
     */
    readonly update?: string;
}
export declare class PubsubLiteReservationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_reservation.html google_pubsub_lite_reservation}.
 */
export declare class PubsubLiteReservation extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_reservation.html google_pubsub_lite_reservation} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: PubsubLiteReservationConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _throughputCapacity?;
    get throughputCapacity(): number;
    set throughputCapacity(value: number);
    get throughputCapacityInput(): number | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): PubsubLiteReservationTimeoutsOutputReference;
    putTimeouts(value: PubsubLiteReservationTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): PubsubLiteReservationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
