import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#constraint ProjectOrganizationPolicy#constraint}
     */
    readonly constraint: string;
    /**
     * The project ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#project ProjectOrganizationPolicy#project}
     */
    readonly project: string;
    /**
     * Version of the Policy. Default version is 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#version ProjectOrganizationPolicy#version}
     */
    readonly version?: number;
    /**
     * boolean_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#boolean_policy ProjectOrganizationPolicy#boolean_policy}
     */
    readonly booleanPolicy?: ProjectOrganizationPolicyBooleanPolicy;
    /**
     * list_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#list_policy ProjectOrganizationPolicy#list_policy}
     */
    readonly listPolicy?: ProjectOrganizationPolicyListPolicy;
    /**
     * restore_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#restore_policy ProjectOrganizationPolicy#restore_policy}
     */
    readonly restorePolicy?: ProjectOrganizationPolicyRestorePolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#timeouts ProjectOrganizationPolicy#timeouts}
     */
    readonly timeouts?: ProjectOrganizationPolicyTimeouts;
}
export interface ProjectOrganizationPolicyBooleanPolicy {
    /**
     * If true, then the Policy is enforced. If false, then any configuration is acceptable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#enforced ProjectOrganizationPolicy#enforced}
     */
    readonly enforced: boolean | cdktf.IResolvable;
}
export declare class ProjectOrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enforced?;
    get enforced(): boolean | cdktf.IResolvable;
    set enforced(value: boolean | cdktf.IResolvable);
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ProjectOrganizationPolicyListPolicyAllow {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#all ProjectOrganizationPolicy#all}
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#values ProjectOrganizationPolicy#values}
     */
    readonly values?: string[];
}
export declare class ProjectOrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _all?;
    get all(): boolean | cdktf.IResolvable | undefined;
    set all(value: boolean | cdktf.IResolvable | undefined);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[] | undefined;
    set values(value: string[] | undefined);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface ProjectOrganizationPolicyListPolicyDeny {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#all ProjectOrganizationPolicy#all}
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#values ProjectOrganizationPolicy#values}
     */
    readonly values?: string[];
}
export declare class ProjectOrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _all?;
    get all(): boolean | cdktf.IResolvable | undefined;
    set all(value: boolean | cdktf.IResolvable | undefined);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[] | undefined;
    set values(value: string[] | undefined);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface ProjectOrganizationPolicyListPolicy {
    /**
     * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#inherit_from_parent ProjectOrganizationPolicy#inherit_from_parent}
     */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
     * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#suggested_value ProjectOrganizationPolicy#suggested_value}
     */
    readonly suggestedValue?: string;
    /**
     * allow block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#allow ProjectOrganizationPolicy#allow}
     */
    readonly allow?: ProjectOrganizationPolicyListPolicyAllow;
    /**
     * deny block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#deny ProjectOrganizationPolicy#deny}
     */
    readonly deny?: ProjectOrganizationPolicyListPolicyDeny;
}
export declare class ProjectOrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _inheritFromParent?;
    get inheritFromParent(): boolean | cdktf.IResolvable | undefined;
    set inheritFromParent(value: boolean | cdktf.IResolvable | undefined);
    resetInheritFromParent(): void;
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _suggestedValue?;
    get suggestedValue(): string | undefined;
    set suggestedValue(value: string | undefined);
    resetSuggestedValue(): void;
    get suggestedValueInput(): string | undefined;
    private _allow?;
    private __allowOutput;
    get allow(): ProjectOrganizationPolicyListPolicyAllowOutputReference;
    putAllow(value: ProjectOrganizationPolicyListPolicyAllow | undefined): void;
    resetAllow(): void;
    get allowInput(): ProjectOrganizationPolicyListPolicyAllow | undefined;
    private _deny?;
    private __denyOutput;
    get deny(): ProjectOrganizationPolicyListPolicyDenyOutputReference;
    putDeny(value: ProjectOrganizationPolicyListPolicyDeny | undefined): void;
    resetDeny(): void;
    get denyInput(): ProjectOrganizationPolicyListPolicyDeny | undefined;
}
export interface ProjectOrganizationPolicyRestorePolicy {
    /**
     * May only be set to true. If set, then the default Policy is restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#default ProjectOrganizationPolicy#default}
     */
    readonly default: boolean | cdktf.IResolvable;
}
export declare class ProjectOrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _default?;
    get default(): boolean | cdktf.IResolvable;
    set default(value: boolean | cdktf.IResolvable);
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ProjectOrganizationPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#create ProjectOrganizationPolicy#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#delete ProjectOrganizationPolicy#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#read ProjectOrganizationPolicy#read}.
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#update ProjectOrganizationPolicy#update}.
     */
    readonly update?: string;
}
export declare class ProjectOrganizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string | undefined;
    set read(value: string | undefined);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html google_project_organization_policy}.
 */
export declare class ProjectOrganizationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html google_project_organization_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ProjectOrganizationPolicyConfig);
    private _constraint?;
    get constraint(): string;
    set constraint(value: string);
    get constraintInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _version?;
    get version(): number | undefined;
    set version(value: number | undefined);
    resetVersion(): void;
    get versionInput(): number | undefined;
    private _booleanPolicy?;
    private __booleanPolicyOutput;
    get booleanPolicy(): ProjectOrganizationPolicyBooleanPolicyOutputReference;
    putBooleanPolicy(value: ProjectOrganizationPolicyBooleanPolicy | undefined): void;
    resetBooleanPolicy(): void;
    get booleanPolicyInput(): ProjectOrganizationPolicyBooleanPolicy | undefined;
    private _listPolicy?;
    private __listPolicyOutput;
    get listPolicy(): ProjectOrganizationPolicyListPolicyOutputReference;
    putListPolicy(value: ProjectOrganizationPolicyListPolicy | undefined): void;
    resetListPolicy(): void;
    get listPolicyInput(): ProjectOrganizationPolicyListPolicy | undefined;
    private _restorePolicy?;
    private __restorePolicyOutput;
    get restorePolicy(): ProjectOrganizationPolicyRestorePolicyOutputReference;
    putRestorePolicy(value: ProjectOrganizationPolicyRestorePolicy | undefined): void;
    resetRestorePolicy(): void;
    get restorePolicyInput(): ProjectOrganizationPolicyRestorePolicy | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ProjectOrganizationPolicyTimeoutsOutputReference;
    putTimeouts(value: ProjectOrganizationPolicyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ProjectOrganizationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
