import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectDefaultServiceAccountsConfig extends cdktf.TerraformMetaArguments {
    /**
     * The action to be performed in the default service accounts.
     *
     * Valid values are: DEPRIVILEGE, DELETE, DISABLE.
     * Note that DEPRIVILEGE action will ignore the REVERT configuration in the restore_policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#action ProjectDefaultServiceAccounts#action}
     */
    readonly action: string;
    /**
     * The project ID where service accounts are created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#project ProjectDefaultServiceAccounts#project}
     */
    readonly project: string;
    /**
     * The action to be performed in the default service accounts on the resource destroy.
     *
     * Valid values are NONE, REVERT and REVERT_AND_IGNORE_FAILURE. It is applied for any action but in the DEPRIVILEGE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#restore_policy ProjectDefaultServiceAccounts#restore_policy}
     */
    readonly restorePolicy?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#timeouts ProjectDefaultServiceAccounts#timeouts}
     */
    readonly timeouts?: ProjectDefaultServiceAccountsTimeouts;
}
export interface ProjectDefaultServiceAccountsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#create ProjectDefaultServiceAccounts#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#delete ProjectDefaultServiceAccounts#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html#read ProjectDefaultServiceAccounts#read}.
     */
    readonly read?: string;
}
export declare class ProjectDefaultServiceAccountsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string | undefined;
    set read(value: string | undefined);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html google_project_default_service_accounts}.
 */
export declare class ProjectDefaultServiceAccounts extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_default_service_accounts.html google_project_default_service_accounts} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ProjectDefaultServiceAccountsConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _restorePolicy?;
    get restorePolicy(): string | undefined;
    set restorePolicy(value: string | undefined);
    resetRestorePolicy(): void;
    get restorePolicyInput(): string | undefined;
    serviceAccounts(key: string): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ProjectDefaultServiceAccountsTimeoutsOutputReference;
    putTimeouts(value: ProjectDefaultServiceAccountsTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ProjectDefaultServiceAccountsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
