import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectAccessApprovalSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of email addresses to which notifications relating to approval requests should be sent.
     *
     * Notifications relating to a resource will be sent to all emails in the settings of ancestor
     * resources of that resource. A maximum of 50 email addresses are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#notification_emails ProjectAccessApprovalSettings#notification_emails}
     */
    readonly notificationEmails?: string[];
    /**
     * Deprecated in favor of 'project_id'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#project ProjectAccessApprovalSettings#project}
     */
    readonly project?: string;
    /**
     * ID of the project of the access approval settings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#project_id ProjectAccessApprovalSettings#project_id}
     */
    readonly projectId: string;
    /**
     * enrolled_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#enrolled_services ProjectAccessApprovalSettings#enrolled_services}
     */
    readonly enrolledServices: ProjectAccessApprovalSettingsEnrolledServices[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#timeouts ProjectAccessApprovalSettings#timeouts}
     */
    readonly timeouts?: ProjectAccessApprovalSettingsTimeouts;
}
export interface ProjectAccessApprovalSettingsEnrolledServices {
    /**
     * The product for which Access Approval will be enrolled. Allowed values are listed (case-sensitive): all appengine.googleapis.com bigquery.googleapis.com bigtable.googleapis.com cloudkms.googleapis.com compute.googleapis.com dataflow.googleapis.com iam.googleapis.com pubsub.googleapis.com storage.googleapis.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#cloud_product ProjectAccessApprovalSettings#cloud_product}
     */
    readonly cloudProduct: string;
    /**
     * The enrollment level of the service. Default value: "BLOCK_ALL" Possible values: ["BLOCK_ALL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#enrollment_level ProjectAccessApprovalSettings#enrollment_level}
     */
    readonly enrollmentLevel?: string;
}
export interface ProjectAccessApprovalSettingsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#create ProjectAccessApprovalSettings#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#delete ProjectAccessApprovalSettings#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#update ProjectAccessApprovalSettings#update}.
     */
    readonly update?: string;
}
export declare class ProjectAccessApprovalSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html google_project_access_approval_settings}.
 */
export declare class ProjectAccessApprovalSettings extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html google_project_access_approval_settings} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ProjectAccessApprovalSettingsConfig);
    get enrolledAncestor(): any;
    get id(): string;
    get name(): string;
    private _notificationEmails?;
    get notificationEmails(): string[] | undefined;
    set notificationEmails(value: string[] | undefined);
    resetNotificationEmails(): void;
    get notificationEmailsInput(): string[] | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _enrolledServices?;
    get enrolledServices(): ProjectAccessApprovalSettingsEnrolledServices[];
    set enrolledServices(value: ProjectAccessApprovalSettingsEnrolledServices[]);
    get enrolledServicesInput(): ProjectAccessApprovalSettingsEnrolledServices[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ProjectAccessApprovalSettingsTimeoutsOutputReference;
    putTimeouts(value: ProjectAccessApprovalSettingsTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ProjectAccessApprovalSettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
