import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatecaCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Certificate Authority name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#certificate_authority PrivatecaCertificate#certificate_authority}
     */
    readonly certificateAuthority?: string;
    /**
     * The resource name for a CertificateTemplate used to issue this certificate, in the format 'projects/*\/locations/*\/certificateTemplates/*'.
     *
     * If this is specified,
     * the caller must have the necessary permission to use this template. If this is
     * omitted, no template will be used. This template must be in the same location
     * as the Certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#certificate_template PrivatecaCertificate#certificate_template}
     */
    readonly certificateTemplate?: string;
    /**
     * Labels with user-defined metadata to apply to this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#labels PrivatecaCertificate#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The desired lifetime of the CA certificate.
     *
     * Used to create the "notBeforeTime" and
     * "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
     * fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#lifetime PrivatecaCertificate#lifetime}
     */
    readonly lifetime?: string;
    /**
     * Location of the Certificate. A full list of valid locations can be found by running 'gcloud privateca locations list'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#location PrivatecaCertificate#location}
     */
    readonly location: string;
    /**
     * The name for this Certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#name PrivatecaCertificate#name}
     */
    readonly name: string;
    /**
     * Immutable. A pem-encoded X.509 certificate signing request (CSR).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#pem_csr PrivatecaCertificate#pem_csr}
     */
    readonly pemCsr?: string;
    /**
     * The name of the CaPool this Certificate belongs to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#pool PrivatecaCertificate#pool}
     */
    readonly pool: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#project PrivatecaCertificate#project}.
     */
    readonly project?: string;
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#config PrivatecaCertificate#config}
     */
    readonly config?: PrivatecaCertificateConfigA;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#timeouts PrivatecaCertificate#timeouts}
     */
    readonly timeouts?: PrivatecaCertificateTimeouts;
}
export declare class PrivatecaCertificateCertificateDescriptionAuthorityKeyId extends cdktf.ComplexComputedList {
    get keyId(): string;
}
export declare class PrivatecaCertificateCertificateDescriptionCertFingerprint extends cdktf.ComplexComputedList {
    get sha256Hash(): string;
}
export declare class PrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptions extends cdktf.ComplexComputedList {
    get certSign(): any;
    get contentCommitment(): any;
    get crlSign(): any;
    get dataEncipherment(): any;
    get decipherOnly(): any;
    get digitalSignature(): any;
    get encipherOnly(): any;
    get keyAgreement(): any;
    get keyEncipherment(): any;
}
export declare class PrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsage extends cdktf.ComplexComputedList {
    get keyUsageOptions(): any;
}
export declare class PrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsage extends cdktf.ComplexComputedList {
    get clientAuth(): any;
    get codeSigning(): any;
    get emailProtection(): any;
    get ocspSigning(): any;
    get serverAuth(): any;
    get timeStamping(): any;
}
export declare class PrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsagesObectId extends cdktf.ComplexComputedList {
    get objectIdPath(): any;
}
export declare class PrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsages extends cdktf.ComplexComputedList {
    get obectId(): any;
}
export declare class PrivatecaCertificateCertificateDescriptionConfigValuesKeyUsage extends cdktf.ComplexComputedList {
    get baseKeyUsage(): any;
    get extendedKeyUsage(): any;
    get unknownExtendedKeyUsages(): any;
}
export declare class PrivatecaCertificateCertificateDescriptionConfigValues extends cdktf.ComplexComputedList {
    get keyUsage(): any;
}
export declare class PrivatecaCertificateCertificateDescriptionPublicKey extends cdktf.ComplexComputedList {
    get format(): string;
    get key(): string;
}
export declare class PrivatecaCertificateCertificateDescriptionSubjectDescriptionSubject extends cdktf.ComplexComputedList {
    get commonName(): string;
    get countryCode(): string;
    get locality(): string;
    get organization(): string;
    get organizationalUnit(): string;
    get postalCode(): string;
    get province(): string;
    get streetAddress(): string;
}
export declare class PrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectId extends cdktf.ComplexComputedList {
    get objectIdPath(): any;
}
export declare class PrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSans extends cdktf.ComplexComputedList {
    get critical(): any;
    get obectId(): any;
    get value(): string;
}
export declare class PrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltName extends cdktf.ComplexComputedList {
    get customSans(): any;
    get dnsNames(): string[];
    get emailAddresses(): string[];
    get ipAddresses(): string[];
    get uris(): string[];
}
export declare class PrivatecaCertificateCertificateDescriptionSubjectDescription extends cdktf.ComplexComputedList {
    get hexSerialNumber(): string;
    get lifetime(): string;
    get notAfterTime(): string;
    get notBeforeTime(): string;
    get subject(): any;
    get subjectAltName(): any;
}
export declare class PrivatecaCertificateCertificateDescriptionSubjectKeyId extends cdktf.ComplexComputedList {
    get keyId(): string;
}
export declare class PrivatecaCertificateCertificateDescription extends cdktf.ComplexComputedList {
    get aiaIssuingCertificateUrls(): string[];
    get authorityKeyId(): any;
    get certFingerprint(): any;
    get configValues(): any;
    get crlDistributionPoints(): string[];
    get publicKey(): any;
    get subjectDescription(): any;
    get subjectKeyId(): any;
}
export declare class PrivatecaCertificateRevocationDetails extends cdktf.ComplexComputedList {
    get revocationState(): string;
    get revocationTime(): string;
}
export interface PrivatecaCertificateConfigPublicKey {
    /**
     * The format of the public key. Currently, only PEM format is supported. Possible values: ["KEY_TYPE_UNSPECIFIED", "PEM"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#format PrivatecaCertificate#format}
     */
    readonly format: string;
    /**
     * Required.
     *
     * A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 SubjectPublicKeyInfo structure containing an algorithm identifier and a key. A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#key PrivatecaCertificate#key}
     */
    readonly key?: string;
}
export declare class PrivatecaCertificateConfigPublicKeyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _format?;
    get format(): string;
    set format(value: string);
    get formatInput(): string | undefined;
    private _key?;
    get key(): string | undefined;
    set key(value: string | undefined);
    resetKey(): void;
    get keyInput(): string | undefined;
}
export interface PrivatecaCertificateConfigSubjectConfigSubject {
    /**
     * The common name of the distinguished name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#common_name PrivatecaCertificate#common_name}
     */
    readonly commonName: string;
    /**
     * The country code of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#country_code PrivatecaCertificate#country_code}
     */
    readonly countryCode?: string;
    /**
     * The locality or city of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#locality PrivatecaCertificate#locality}
     */
    readonly locality?: string;
    /**
     * The organization of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#organization PrivatecaCertificate#organization}
     */
    readonly organization: string;
    /**
     * The organizational unit of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#organizational_unit PrivatecaCertificate#organizational_unit}
     */
    readonly organizationalUnit?: string;
    /**
     * The postal code of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#postal_code PrivatecaCertificate#postal_code}
     */
    readonly postalCode?: string;
    /**
     * The province, territory, or regional state of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#province PrivatecaCertificate#province}
     */
    readonly province?: string;
    /**
     * The street address of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#street_address PrivatecaCertificate#street_address}
     */
    readonly streetAddress?: string;
}
export declare class PrivatecaCertificateConfigSubjectConfigSubjectOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    private _countryCode?;
    get countryCode(): string | undefined;
    set countryCode(value: string | undefined);
    resetCountryCode(): void;
    get countryCodeInput(): string | undefined;
    private _locality?;
    get locality(): string | undefined;
    set locality(value: string | undefined);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _organizationalUnit?;
    get organizationalUnit(): string | undefined;
    set organizationalUnit(value: string | undefined);
    resetOrganizationalUnit(): void;
    get organizationalUnitInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string | undefined;
    set postalCode(value: string | undefined);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _province?;
    get province(): string | undefined;
    set province(value: string | undefined);
    resetProvince(): void;
    get provinceInput(): string | undefined;
    private _streetAddress?;
    get streetAddress(): string | undefined;
    set streetAddress(value: string | undefined);
    resetStreetAddress(): void;
    get streetAddressInput(): string | undefined;
}
export interface PrivatecaCertificateConfigSubjectConfigSubjectAltName {
    /**
     * Contains only valid, fully-qualified host names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#dns_names PrivatecaCertificate#dns_names}
     */
    readonly dnsNames?: string[];
    /**
     * Contains only valid RFC 2822 E-mail addresses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#email_addresses PrivatecaCertificate#email_addresses}
     */
    readonly emailAddresses?: string[];
    /**
     * Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#ip_addresses PrivatecaCertificate#ip_addresses}
     */
    readonly ipAddresses?: string[];
    /**
     * Contains only valid RFC 3986 URIs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#uris PrivatecaCertificate#uris}
     */
    readonly uris?: string[];
}
export declare class PrivatecaCertificateConfigSubjectConfigSubjectAltNameOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dnsNames?;
    get dnsNames(): string[] | undefined;
    set dnsNames(value: string[] | undefined);
    resetDnsNames(): void;
    get dnsNamesInput(): string[] | undefined;
    private _emailAddresses?;
    get emailAddresses(): string[] | undefined;
    set emailAddresses(value: string[] | undefined);
    resetEmailAddresses(): void;
    get emailAddressesInput(): string[] | undefined;
    private _ipAddresses?;
    get ipAddresses(): string[] | undefined;
    set ipAddresses(value: string[] | undefined);
    resetIpAddresses(): void;
    get ipAddressesInput(): string[] | undefined;
    private _uris?;
    get uris(): string[] | undefined;
    set uris(value: string[] | undefined);
    resetUris(): void;
    get urisInput(): string[] | undefined;
}
export interface PrivatecaCertificateConfigSubjectConfig {
    /**
     * subject block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#subject PrivatecaCertificate#subject}
     */
    readonly subject: PrivatecaCertificateConfigSubjectConfigSubject;
    /**
     * subject_alt_name block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#subject_alt_name PrivatecaCertificate#subject_alt_name}
     */
    readonly subjectAltName?: PrivatecaCertificateConfigSubjectConfigSubjectAltName;
}
export declare class PrivatecaCertificateConfigSubjectConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _subject?;
    private __subjectOutput;
    get subject(): PrivatecaCertificateConfigSubjectConfigSubjectOutputReference;
    putSubject(value: PrivatecaCertificateConfigSubjectConfigSubject): void;
    get subjectInput(): PrivatecaCertificateConfigSubjectConfigSubject | undefined;
    private _subjectAltName?;
    private __subjectAltNameOutput;
    get subjectAltName(): PrivatecaCertificateConfigSubjectConfigSubjectAltNameOutputReference;
    putSubjectAltName(value: PrivatecaCertificateConfigSubjectConfigSubjectAltName | undefined): void;
    resetSubjectAltName(): void;
    get subjectAltNameInput(): PrivatecaCertificateConfigSubjectConfigSubjectAltName | undefined;
}
export interface PrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectId {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#object_id_path PrivatecaCertificate#object_id_path}
     */
    readonly objectIdPath: number[];
}
export declare class PrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export interface PrivatecaCertificateConfigX509ConfigAdditionalExtensions {
    /**
     * Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#critical PrivatecaCertificate#critical}
     */
    readonly critical: boolean | cdktf.IResolvable;
    /**
     * The value of this X.509 extension. A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#value PrivatecaCertificate#value}
     */
    readonly value: string;
    /**
     * object_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#object_id PrivatecaCertificate#object_id}
     */
    readonly objectId: PrivatecaCertificateConfigX509ConfigAdditionalExtensionsObjectId;
}
export interface PrivatecaCertificateConfigX509ConfigCaOptions {
    /**
     * Refers to the "CA" X.509 extension, which is a boolean value. When this value is missing, the extension will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#is_ca PrivatecaCertificate#is_ca}
     */
    readonly isCa?: boolean | cdktf.IResolvable;
    /**
     * Refers to the path length restriction X.509 extension. For a CA certificate, this value describes the depth of subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. If this value is missing, the max path length will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#max_issuer_path_length PrivatecaCertificate#max_issuer_path_length}
     */
    readonly maxIssuerPathLength?: number;
}
export declare class PrivatecaCertificateConfigX509ConfigCaOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isCa?;
    get isCa(): boolean | cdktf.IResolvable | undefined;
    set isCa(value: boolean | cdktf.IResolvable | undefined);
    resetIsCa(): void;
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    get maxIssuerPathLength(): number | undefined;
    set maxIssuerPathLength(value: number | undefined);
    resetMaxIssuerPathLength(): void;
    get maxIssuerPathLengthInput(): number | undefined;
}
export interface PrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage {
    /**
     * The key may be used to sign certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#cert_sign PrivatecaCertificate#cert_sign}
     */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#content_commitment PrivatecaCertificate#content_commitment}
     */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used sign certificate revocation lists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#crl_sign PrivatecaCertificate#crl_sign}
     */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#data_encipherment PrivatecaCertificate#data_encipherment}
     */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to decipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#decipher_only PrivatecaCertificate#decipher_only}
     */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for digital signatures.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#digital_signature PrivatecaCertificate#digital_signature}
     */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#encipher_only PrivatecaCertificate#encipher_only}
     */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used in a key agreement protocol.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#key_agreement PrivatecaCertificate#key_agreement}
     */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher other keys.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#key_encipherment PrivatecaCertificate#key_encipherment}
     */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
export declare class PrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _certSign?;
    get certSign(): boolean | cdktf.IResolvable | undefined;
    set certSign(value: boolean | cdktf.IResolvable | undefined);
    resetCertSign(): void;
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    get contentCommitment(): boolean | cdktf.IResolvable | undefined;
    set contentCommitment(value: boolean | cdktf.IResolvable | undefined);
    resetContentCommitment(): void;
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    get crlSign(): boolean | cdktf.IResolvable | undefined;
    set crlSign(value: boolean | cdktf.IResolvable | undefined);
    resetCrlSign(): void;
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    get dataEncipherment(): boolean | cdktf.IResolvable | undefined;
    set dataEncipherment(value: boolean | cdktf.IResolvable | undefined);
    resetDataEncipherment(): void;
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    get decipherOnly(): boolean | cdktf.IResolvable | undefined;
    set decipherOnly(value: boolean | cdktf.IResolvable | undefined);
    resetDecipherOnly(): void;
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    get digitalSignature(): boolean | cdktf.IResolvable | undefined;
    set digitalSignature(value: boolean | cdktf.IResolvable | undefined);
    resetDigitalSignature(): void;
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    get encipherOnly(): boolean | cdktf.IResolvable | undefined;
    set encipherOnly(value: boolean | cdktf.IResolvable | undefined);
    resetEncipherOnly(): void;
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    get keyAgreement(): boolean | cdktf.IResolvable | undefined;
    set keyAgreement(value: boolean | cdktf.IResolvable | undefined);
    resetKeyAgreement(): void;
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    get keyEncipherment(): boolean | cdktf.IResolvable | undefined;
    set keyEncipherment(value: boolean | cdktf.IResolvable | undefined);
    resetKeyEncipherment(): void;
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage {
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#client_auth PrivatecaCertificate#client_auth}
     */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#code_signing PrivatecaCertificate#code_signing}
     */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#email_protection PrivatecaCertificate#email_protection}
     */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#ocsp_signing PrivatecaCertificate#ocsp_signing}
     */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#server_auth PrivatecaCertificate#server_auth}
     */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#time_stamping PrivatecaCertificate#time_stamping}
     */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
export declare class PrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _clientAuth?;
    get clientAuth(): boolean | cdktf.IResolvable | undefined;
    set clientAuth(value: boolean | cdktf.IResolvable | undefined);
    resetClientAuth(): void;
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    get codeSigning(): boolean | cdktf.IResolvable | undefined;
    set codeSigning(value: boolean | cdktf.IResolvable | undefined);
    resetCodeSigning(): void;
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    get emailProtection(): boolean | cdktf.IResolvable | undefined;
    set emailProtection(value: boolean | cdktf.IResolvable | undefined);
    resetEmailProtection(): void;
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    get ocspSigning(): boolean | cdktf.IResolvable | undefined;
    set ocspSigning(value: boolean | cdktf.IResolvable | undefined);
    resetOcspSigning(): void;
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    get serverAuth(): boolean | cdktf.IResolvable | undefined;
    set serverAuth(value: boolean | cdktf.IResolvable | undefined);
    resetServerAuth(): void;
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    get timeStamping(): boolean | cdktf.IResolvable | undefined;
    set timeStamping(value: boolean | cdktf.IResolvable | undefined);
    resetTimeStamping(): void;
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#object_id_path PrivatecaCertificate#object_id_path}
     */
    readonly objectIdPath: number[];
}
export interface PrivatecaCertificateConfigX509ConfigKeyUsage {
    /**
     * base_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#base_key_usage PrivatecaCertificate#base_key_usage}
     */
    readonly baseKeyUsage: PrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage;
    /**
     * extended_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#extended_key_usage PrivatecaCertificate#extended_key_usage}
     */
    readonly extendedKeyUsage: PrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage;
    /**
     * unknown_extended_key_usages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#unknown_extended_key_usages PrivatecaCertificate#unknown_extended_key_usages}
     */
    readonly unknownExtendedKeyUsages?: PrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[];
}
export declare class PrivatecaCertificateConfigX509ConfigKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _baseKeyUsage?;
    private __baseKeyUsageOutput;
    get baseKeyUsage(): PrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsageOutputReference;
    putBaseKeyUsage(value: PrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage): void;
    get baseKeyUsageInput(): PrivatecaCertificateConfigX509ConfigKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage?;
    private __extendedKeyUsageOutput;
    get extendedKeyUsage(): PrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference;
    putExtendedKeyUsage(value: PrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage): void;
    get extendedKeyUsageInput(): PrivatecaCertificateConfigX509ConfigKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages?;
    get unknownExtendedKeyUsages(): PrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | undefined;
    set unknownExtendedKeyUsages(value: PrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | undefined);
    resetUnknownExtendedKeyUsages(): void;
    get unknownExtendedKeyUsagesInput(): PrivatecaCertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
export interface PrivatecaCertificateConfigX509ConfigPolicyIds {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#object_id_path PrivatecaCertificate#object_id_path}
     */
    readonly objectIdPath: number[];
}
export interface PrivatecaCertificateConfigX509Config {
    /**
     * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#aia_ocsp_servers PrivatecaCertificate#aia_ocsp_servers}
     */
    readonly aiaOcspServers?: string[];
    /**
     * additional_extensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#additional_extensions PrivatecaCertificate#additional_extensions}
     */
    readonly additionalExtensions?: PrivatecaCertificateConfigX509ConfigAdditionalExtensions[];
    /**
     * ca_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#ca_options PrivatecaCertificate#ca_options}
     */
    readonly caOptions?: PrivatecaCertificateConfigX509ConfigCaOptions;
    /**
     * key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#key_usage PrivatecaCertificate#key_usage}
     */
    readonly keyUsage: PrivatecaCertificateConfigX509ConfigKeyUsage;
    /**
     * policy_ids block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#policy_ids PrivatecaCertificate#policy_ids}
     */
    readonly policyIds?: PrivatecaCertificateConfigX509ConfigPolicyIds[];
}
export declare class PrivatecaCertificateConfigX509ConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aiaOcspServers?;
    get aiaOcspServers(): string[] | undefined;
    set aiaOcspServers(value: string[] | undefined);
    resetAiaOcspServers(): void;
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions?;
    get additionalExtensions(): PrivatecaCertificateConfigX509ConfigAdditionalExtensions[] | undefined;
    set additionalExtensions(value: PrivatecaCertificateConfigX509ConfigAdditionalExtensions[] | undefined);
    resetAdditionalExtensions(): void;
    get additionalExtensionsInput(): PrivatecaCertificateConfigX509ConfigAdditionalExtensions[] | undefined;
    private _caOptions?;
    private __caOptionsOutput;
    get caOptions(): PrivatecaCertificateConfigX509ConfigCaOptionsOutputReference;
    putCaOptions(value: PrivatecaCertificateConfigX509ConfigCaOptions | undefined): void;
    resetCaOptions(): void;
    get caOptionsInput(): PrivatecaCertificateConfigX509ConfigCaOptions | undefined;
    private _keyUsage?;
    private __keyUsageOutput;
    get keyUsage(): PrivatecaCertificateConfigX509ConfigKeyUsageOutputReference;
    putKeyUsage(value: PrivatecaCertificateConfigX509ConfigKeyUsage): void;
    get keyUsageInput(): PrivatecaCertificateConfigX509ConfigKeyUsage | undefined;
    private _policyIds?;
    get policyIds(): PrivatecaCertificateConfigX509ConfigPolicyIds[] | undefined;
    set policyIds(value: PrivatecaCertificateConfigX509ConfigPolicyIds[] | undefined);
    resetPolicyIds(): void;
    get policyIdsInput(): PrivatecaCertificateConfigX509ConfigPolicyIds[] | undefined;
}
export interface PrivatecaCertificateConfigA {
    /**
     * public_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#public_key PrivatecaCertificate#public_key}
     */
    readonly publicKey: PrivatecaCertificateConfigPublicKey;
    /**
     * subject_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#subject_config PrivatecaCertificate#subject_config}
     */
    readonly subjectConfig: PrivatecaCertificateConfigSubjectConfig;
    /**
     * x509_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#x509_config PrivatecaCertificate#x509_config}
     */
    readonly x509Config: PrivatecaCertificateConfigX509Config;
}
export declare class PrivatecaCertificateConfigAOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _publicKey?;
    private __publicKeyOutput;
    get publicKey(): PrivatecaCertificateConfigPublicKeyOutputReference;
    putPublicKey(value: PrivatecaCertificateConfigPublicKey): void;
    get publicKeyInput(): PrivatecaCertificateConfigPublicKey | undefined;
    private _subjectConfig?;
    private __subjectConfigOutput;
    get subjectConfig(): PrivatecaCertificateConfigSubjectConfigOutputReference;
    putSubjectConfig(value: PrivatecaCertificateConfigSubjectConfig): void;
    get subjectConfigInput(): PrivatecaCertificateConfigSubjectConfig | undefined;
    private _x509Config?;
    private __x509ConfigOutput;
    get x509Config(): PrivatecaCertificateConfigX509ConfigOutputReference;
    putX509Config(value: PrivatecaCertificateConfigX509Config): void;
    get x509ConfigInput(): PrivatecaCertificateConfigX509Config | undefined;
}
export interface PrivatecaCertificateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#create PrivatecaCertificate#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html#delete PrivatecaCertificate#delete}.
     */
    readonly delete?: string;
}
export declare class PrivatecaCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html google_privateca_certificate}.
 */
export declare class PrivatecaCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate.html google_privateca_certificate} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: PrivatecaCertificateConfig);
    private _certificateAuthority?;
    get certificateAuthority(): string | undefined;
    set certificateAuthority(value: string | undefined);
    resetCertificateAuthority(): void;
    get certificateAuthorityInput(): string | undefined;
    certificateDescription(index: string): PrivatecaCertificateCertificateDescription;
    private _certificateTemplate?;
    get certificateTemplate(): string | undefined;
    set certificateTemplate(value: string | undefined);
    resetCertificateTemplate(): void;
    get certificateTemplateInput(): string | undefined;
    get createTime(): string;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _lifetime?;
    get lifetime(): string | undefined;
    set lifetime(value: string | undefined);
    resetLifetime(): void;
    get lifetimeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get pemCertificate(): string;
    get pemCertificates(): string[];
    private _pemCsr?;
    get pemCsr(): string | undefined;
    set pemCsr(value: string | undefined);
    resetPemCsr(): void;
    get pemCsrInput(): string | undefined;
    private _pool?;
    get pool(): string;
    set pool(value: string);
    get poolInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    revocationDetails(index: string): PrivatecaCertificateRevocationDetails;
    get updateTime(): string;
    private _config?;
    private __configOutput;
    get config(): PrivatecaCertificateConfigAOutputReference;
    putConfig(value: PrivatecaCertificateConfigA | undefined): void;
    resetConfig(): void;
    get configInput(): PrivatecaCertificateConfigA | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): PrivatecaCertificateTimeoutsOutputReference;
    putTimeouts(value: PrivatecaCertificateTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): PrivatecaCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
