import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatecaCertificateTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Optional. A human-readable description of scenarios this template is intended for.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#description PrivatecaCertificateTemplate#description}
     */
    readonly description?: string;
    /**
     * Optional. Labels with user-defined metadata.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#labels PrivatecaCertificateTemplate#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The location for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#location PrivatecaCertificateTemplate#location}
     */
    readonly location: string;
    /**
     * The resource name for this CertificateTemplate in the format `projects/*\/locations/*\/certificateTemplates/*`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#name PrivatecaCertificateTemplate#name}
     */
    readonly name: string;
    /**
     * The project for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#project PrivatecaCertificateTemplate#project}
     */
    readonly project?: string;
    /**
     * identity_constraints block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#identity_constraints PrivatecaCertificateTemplate#identity_constraints}
     */
    readonly identityConstraints?: PrivatecaCertificateTemplateIdentityConstraints;
    /**
     * passthrough_extensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#passthrough_extensions PrivatecaCertificateTemplate#passthrough_extensions}
     */
    readonly passthroughExtensions?: PrivatecaCertificateTemplatePassthroughExtensions;
    /**
     * predefined_values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#predefined_values PrivatecaCertificateTemplate#predefined_values}
     */
    readonly predefinedValues?: PrivatecaCertificateTemplatePredefinedValues;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#timeouts PrivatecaCertificateTemplate#timeouts}
     */
    readonly timeouts?: PrivatecaCertificateTemplateTimeouts;
}
export interface PrivatecaCertificateTemplateIdentityConstraintsCelExpression {
    /**
     * Optional.
     *
     * Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#description PrivatecaCertificateTemplate#description}
     */
    readonly description?: string;
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#expression PrivatecaCertificateTemplate#expression}
     */
    readonly expression?: string;
    /**
     * Optional.
     *
     * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#location PrivatecaCertificateTemplate#location}
     */
    readonly location?: string;
    /**
     * Optional.
     *
     * Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#title PrivatecaCertificateTemplate#title}
     */
    readonly title?: string;
}
export declare class PrivatecaCertificateTemplateIdentityConstraintsCelExpressionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string | undefined;
    set expression(value: string | undefined);
    resetExpression(): void;
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string | undefined;
    set title(value: string | undefined);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface PrivatecaCertificateTemplateIdentityConstraints {
    /**
     * Required.
     *
     * If this is true, the SubjectAltNames extension may be copied from a certificate request into the signed certificate. Otherwise, the requested SubjectAltNames will be discarded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#allow_subject_alt_names_passthrough PrivatecaCertificateTemplate#allow_subject_alt_names_passthrough}
     */
    readonly allowSubjectAltNamesPassthrough: boolean | cdktf.IResolvable;
    /**
     * Required.
     *
     * If this is true, the Subject field may be copied from a certificate request into the signed certificate. Otherwise, the requested Subject will be discarded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#allow_subject_passthrough PrivatecaCertificateTemplate#allow_subject_passthrough}
     */
    readonly allowSubjectPassthrough: boolean | cdktf.IResolvable;
    /**
     * cel_expression block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#cel_expression PrivatecaCertificateTemplate#cel_expression}
     */
    readonly celExpression?: PrivatecaCertificateTemplateIdentityConstraintsCelExpression;
}
export declare class PrivatecaCertificateTemplateIdentityConstraintsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowSubjectAltNamesPassthrough?;
    get allowSubjectAltNamesPassthrough(): boolean | cdktf.IResolvable;
    set allowSubjectAltNamesPassthrough(value: boolean | cdktf.IResolvable);
    get allowSubjectAltNamesPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _allowSubjectPassthrough?;
    get allowSubjectPassthrough(): boolean | cdktf.IResolvable;
    set allowSubjectPassthrough(value: boolean | cdktf.IResolvable);
    get allowSubjectPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _celExpression?;
    private __celExpressionOutput;
    get celExpression(): PrivatecaCertificateTemplateIdentityConstraintsCelExpressionOutputReference;
    putCelExpression(value: PrivatecaCertificateTemplateIdentityConstraintsCelExpression | undefined): void;
    resetCelExpression(): void;
    get celExpressionInput(): PrivatecaCertificateTemplateIdentityConstraintsCelExpression | undefined;
}
export interface PrivatecaCertificateTemplatePassthroughExtensionsAdditionalExtensions {
    /**
     * Required. The parts of an OID path. The most significant parts of the path come first.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#object_id_path PrivatecaCertificateTemplate#object_id_path}
     */
    readonly objectIdPath: number[];
}
export interface PrivatecaCertificateTemplatePassthroughExtensions {
    /**
     * Optional.
     *
     * A set of named X.509 extensions. Will be combined with additional_extensions to determine the full set of X.509 extensions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#known_extensions PrivatecaCertificateTemplate#known_extensions}
     */
    readonly knownExtensions?: string[];
    /**
     * additional_extensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#additional_extensions PrivatecaCertificateTemplate#additional_extensions}
     */
    readonly additionalExtensions?: PrivatecaCertificateTemplatePassthroughExtensionsAdditionalExtensions[];
}
export declare class PrivatecaCertificateTemplatePassthroughExtensionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _knownExtensions?;
    get knownExtensions(): string[] | undefined;
    set knownExtensions(value: string[] | undefined);
    resetKnownExtensions(): void;
    get knownExtensionsInput(): string[] | undefined;
    private _additionalExtensions?;
    get additionalExtensions(): PrivatecaCertificateTemplatePassthroughExtensionsAdditionalExtensions[] | undefined;
    set additionalExtensions(value: PrivatecaCertificateTemplatePassthroughExtensionsAdditionalExtensions[] | undefined);
    resetAdditionalExtensions(): void;
    get additionalExtensionsInput(): PrivatecaCertificateTemplatePassthroughExtensionsAdditionalExtensions[] | undefined;
}
export interface PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensionsObjectId {
    /**
     * Required. The parts of an OID path. The most significant parts of the path come first.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#object_id_path PrivatecaCertificateTemplate#object_id_path}
     */
    readonly objectIdPath: number[];
}
export declare class PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export interface PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensions {
    /**
     * Optional.
     *
     * Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#critical PrivatecaCertificateTemplate#critical}
     */
    readonly critical?: boolean | cdktf.IResolvable;
    /**
     * Required. The value of this X.509 extension.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#value PrivatecaCertificateTemplate#value}
     */
    readonly value: string;
    /**
     * object_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#object_id PrivatecaCertificateTemplate#object_id}
     */
    readonly objectId: PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensionsObjectId;
}
export interface PrivatecaCertificateTemplatePredefinedValuesCaOptions {
    /**
     * Optional.
     *
     * Refers to the "CA" X.509 extension, which is a boolean value. When this value is missing, the extension will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#is_ca PrivatecaCertificateTemplate#is_ca}
     */
    readonly isCa?: boolean | cdktf.IResolvable;
    /**
     * Optional.
     *
     * Refers to the path length restriction X.509 extension. For a CA certificate, this value describes the depth of subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. If this value is missing, the max path length will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#max_issuer_path_length PrivatecaCertificateTemplate#max_issuer_path_length}
     */
    readonly maxIssuerPathLength?: number;
}
export declare class PrivatecaCertificateTemplatePredefinedValuesCaOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isCa?;
    get isCa(): boolean | cdktf.IResolvable | undefined;
    set isCa(value: boolean | cdktf.IResolvable | undefined);
    resetIsCa(): void;
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    get maxIssuerPathLength(): number | undefined;
    set maxIssuerPathLength(value: number | undefined);
    resetMaxIssuerPathLength(): void;
    get maxIssuerPathLengthInput(): number | undefined;
}
export interface PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage {
    /**
     * The key may be used to sign certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#cert_sign PrivatecaCertificateTemplate#cert_sign}
     */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#content_commitment PrivatecaCertificateTemplate#content_commitment}
     */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used sign certificate revocation lists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#crl_sign PrivatecaCertificateTemplate#crl_sign}
     */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#data_encipherment PrivatecaCertificateTemplate#data_encipherment}
     */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to decipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#decipher_only PrivatecaCertificateTemplate#decipher_only}
     */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for digital signatures.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#digital_signature PrivatecaCertificateTemplate#digital_signature}
     */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#encipher_only PrivatecaCertificateTemplate#encipher_only}
     */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used in a key agreement protocol.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#key_agreement PrivatecaCertificateTemplate#key_agreement}
     */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher other keys.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#key_encipherment PrivatecaCertificateTemplate#key_encipherment}
     */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
export declare class PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _certSign?;
    get certSign(): boolean | cdktf.IResolvable | undefined;
    set certSign(value: boolean | cdktf.IResolvable | undefined);
    resetCertSign(): void;
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    get contentCommitment(): boolean | cdktf.IResolvable | undefined;
    set contentCommitment(value: boolean | cdktf.IResolvable | undefined);
    resetContentCommitment(): void;
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    get crlSign(): boolean | cdktf.IResolvable | undefined;
    set crlSign(value: boolean | cdktf.IResolvable | undefined);
    resetCrlSign(): void;
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    get dataEncipherment(): boolean | cdktf.IResolvable | undefined;
    set dataEncipherment(value: boolean | cdktf.IResolvable | undefined);
    resetDataEncipherment(): void;
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    get decipherOnly(): boolean | cdktf.IResolvable | undefined;
    set decipherOnly(value: boolean | cdktf.IResolvable | undefined);
    resetDecipherOnly(): void;
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    get digitalSignature(): boolean | cdktf.IResolvable | undefined;
    set digitalSignature(value: boolean | cdktf.IResolvable | undefined);
    resetDigitalSignature(): void;
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    get encipherOnly(): boolean | cdktf.IResolvable | undefined;
    set encipherOnly(value: boolean | cdktf.IResolvable | undefined);
    resetEncipherOnly(): void;
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    get keyAgreement(): boolean | cdktf.IResolvable | undefined;
    set keyAgreement(value: boolean | cdktf.IResolvable | undefined);
    resetKeyAgreement(): void;
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    get keyEncipherment(): boolean | cdktf.IResolvable | undefined;
    set keyEncipherment(value: boolean | cdktf.IResolvable | undefined);
    resetKeyEncipherment(): void;
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage {
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#client_auth PrivatecaCertificateTemplate#client_auth}
     */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#code_signing PrivatecaCertificateTemplate#code_signing}
     */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#email_protection PrivatecaCertificateTemplate#email_protection}
     */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#ocsp_signing PrivatecaCertificateTemplate#ocsp_signing}
     */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#server_auth PrivatecaCertificateTemplate#server_auth}
     */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#time_stamping PrivatecaCertificateTemplate#time_stamping}
     */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
export declare class PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _clientAuth?;
    get clientAuth(): boolean | cdktf.IResolvable | undefined;
    set clientAuth(value: boolean | cdktf.IResolvable | undefined);
    resetClientAuth(): void;
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    get codeSigning(): boolean | cdktf.IResolvable | undefined;
    set codeSigning(value: boolean | cdktf.IResolvable | undefined);
    resetCodeSigning(): void;
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    get emailProtection(): boolean | cdktf.IResolvable | undefined;
    set emailProtection(value: boolean | cdktf.IResolvable | undefined);
    resetEmailProtection(): void;
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    get ocspSigning(): boolean | cdktf.IResolvable | undefined;
    set ocspSigning(value: boolean | cdktf.IResolvable | undefined);
    resetOcspSigning(): void;
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    get serverAuth(): boolean | cdktf.IResolvable | undefined;
    set serverAuth(value: boolean | cdktf.IResolvable | undefined);
    resetServerAuth(): void;
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    get timeStamping(): boolean | cdktf.IResolvable | undefined;
    set timeStamping(value: boolean | cdktf.IResolvable | undefined);
    resetTimeStamping(): void;
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsages {
    /**
     * Required. The parts of an OID path. The most significant parts of the path come first.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#object_id_path PrivatecaCertificateTemplate#object_id_path}
     */
    readonly objectIdPath: number[];
}
export interface PrivatecaCertificateTemplatePredefinedValuesKeyUsage {
    /**
     * base_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#base_key_usage PrivatecaCertificateTemplate#base_key_usage}
     */
    readonly baseKeyUsage?: PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage;
    /**
     * extended_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#extended_key_usage PrivatecaCertificateTemplate#extended_key_usage}
     */
    readonly extendedKeyUsage?: PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage;
    /**
     * unknown_extended_key_usages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#unknown_extended_key_usages PrivatecaCertificateTemplate#unknown_extended_key_usages}
     */
    readonly unknownExtendedKeyUsages?: PrivatecaCertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsages[];
}
export declare class PrivatecaCertificateTemplatePredefinedValuesKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _baseKeyUsage?;
    private __baseKeyUsageOutput;
    get baseKeyUsage(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsageOutputReference;
    putBaseKeyUsage(value: PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage | undefined): void;
    resetBaseKeyUsage(): void;
    get baseKeyUsageInput(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage?;
    private __extendedKeyUsageOutput;
    get extendedKeyUsage(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsageOutputReference;
    putExtendedKeyUsage(value: PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage | undefined): void;
    resetExtendedKeyUsage(): void;
    get extendedKeyUsageInput(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages?;
    get unknownExtendedKeyUsages(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsages[] | undefined;
    set unknownExtendedKeyUsages(value: PrivatecaCertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsages[] | undefined);
    resetUnknownExtendedKeyUsages(): void;
    get unknownExtendedKeyUsagesInput(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
export interface PrivatecaCertificateTemplatePredefinedValuesPolicyIds {
    /**
     * Required. The parts of an OID path. The most significant parts of the path come first.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#object_id_path PrivatecaCertificateTemplate#object_id_path}
     */
    readonly objectIdPath: number[];
}
export interface PrivatecaCertificateTemplatePredefinedValues {
    /**
     * Optional.
     *
     * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#aia_ocsp_servers PrivatecaCertificateTemplate#aia_ocsp_servers}
     */
    readonly aiaOcspServers?: string[];
    /**
     * additional_extensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#additional_extensions PrivatecaCertificateTemplate#additional_extensions}
     */
    readonly additionalExtensions?: PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensions[];
    /**
     * ca_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#ca_options PrivatecaCertificateTemplate#ca_options}
     */
    readonly caOptions?: PrivatecaCertificateTemplatePredefinedValuesCaOptions;
    /**
     * key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#key_usage PrivatecaCertificateTemplate#key_usage}
     */
    readonly keyUsage?: PrivatecaCertificateTemplatePredefinedValuesKeyUsage;
    /**
     * policy_ids block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#policy_ids PrivatecaCertificateTemplate#policy_ids}
     */
    readonly policyIds?: PrivatecaCertificateTemplatePredefinedValuesPolicyIds[];
}
export declare class PrivatecaCertificateTemplatePredefinedValuesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aiaOcspServers?;
    get aiaOcspServers(): string[] | undefined;
    set aiaOcspServers(value: string[] | undefined);
    resetAiaOcspServers(): void;
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions?;
    get additionalExtensions(): PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensions[] | undefined;
    set additionalExtensions(value: PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensions[] | undefined);
    resetAdditionalExtensions(): void;
    get additionalExtensionsInput(): PrivatecaCertificateTemplatePredefinedValuesAdditionalExtensions[] | undefined;
    private _caOptions?;
    private __caOptionsOutput;
    get caOptions(): PrivatecaCertificateTemplatePredefinedValuesCaOptionsOutputReference;
    putCaOptions(value: PrivatecaCertificateTemplatePredefinedValuesCaOptions | undefined): void;
    resetCaOptions(): void;
    get caOptionsInput(): PrivatecaCertificateTemplatePredefinedValuesCaOptions | undefined;
    private _keyUsage?;
    private __keyUsageOutput;
    get keyUsage(): PrivatecaCertificateTemplatePredefinedValuesKeyUsageOutputReference;
    putKeyUsage(value: PrivatecaCertificateTemplatePredefinedValuesKeyUsage | undefined): void;
    resetKeyUsage(): void;
    get keyUsageInput(): PrivatecaCertificateTemplatePredefinedValuesKeyUsage | undefined;
    private _policyIds?;
    get policyIds(): PrivatecaCertificateTemplatePredefinedValuesPolicyIds[] | undefined;
    set policyIds(value: PrivatecaCertificateTemplatePredefinedValuesPolicyIds[] | undefined);
    resetPolicyIds(): void;
    get policyIdsInput(): PrivatecaCertificateTemplatePredefinedValuesPolicyIds[] | undefined;
}
export interface PrivatecaCertificateTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#create PrivatecaCertificateTemplate#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#delete PrivatecaCertificateTemplate#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html#update PrivatecaCertificateTemplate#update}.
     */
    readonly update?: string;
}
export declare class PrivatecaCertificateTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html google_privateca_certificate_template}.
 */
export declare class PrivatecaCertificateTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template.html google_privateca_certificate_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: PrivatecaCertificateTemplateConfig);
    get createTime(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _identityConstraints?;
    private __identityConstraintsOutput;
    get identityConstraints(): PrivatecaCertificateTemplateIdentityConstraintsOutputReference;
    putIdentityConstraints(value: PrivatecaCertificateTemplateIdentityConstraints | undefined): void;
    resetIdentityConstraints(): void;
    get identityConstraintsInput(): PrivatecaCertificateTemplateIdentityConstraints | undefined;
    private _passthroughExtensions?;
    private __passthroughExtensionsOutput;
    get passthroughExtensions(): PrivatecaCertificateTemplatePassthroughExtensionsOutputReference;
    putPassthroughExtensions(value: PrivatecaCertificateTemplatePassthroughExtensions | undefined): void;
    resetPassthroughExtensions(): void;
    get passthroughExtensionsInput(): PrivatecaCertificateTemplatePassthroughExtensions | undefined;
    private _predefinedValues?;
    private __predefinedValuesOutput;
    get predefinedValues(): PrivatecaCertificateTemplatePredefinedValuesOutputReference;
    putPredefinedValues(value: PrivatecaCertificateTemplatePredefinedValues | undefined): void;
    resetPredefinedValues(): void;
    get predefinedValuesInput(): PrivatecaCertificateTemplatePredefinedValues | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): PrivatecaCertificateTemplateTimeoutsOutputReference;
    putTimeouts(value: PrivatecaCertificateTemplateTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): PrivatecaCertificateTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
