import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatecaCertificateAuthorityConfig extends cdktf.TerraformMetaArguments {
    /**
     * The user provided Resource ID for this Certificate Authority.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#certificate_authority_id PrivatecaCertificateAuthority#certificate_authority_id}
     */
    readonly certificateAuthorityId: string;
    /**
     * The name of a Cloud Storage bucket where this CertificateAuthority will publish content, such as the CA certificate and CRLs.
     *
     * This must be a bucket name, without any prefixes
     * (such as 'gs://') or suffixes (such as '.googleapis.com'). For example, to use a bucket named
     * my-bucket, you would simply specify 'my-bucket'. If not specified, a managed bucket will be
     * created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#gcs_bucket PrivatecaCertificateAuthority#gcs_bucket}
     */
    readonly gcsBucket?: string;
    /**
     * This field allows the CA to be deleted even if the CA has active certs.
     *
     * Active certs include both unrevoked and unexpired certs.
     * Use with care. Defaults to 'false'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#ignore_active_certificates_on_deletion PrivatecaCertificateAuthority#ignore_active_certificates_on_deletion}
     */
    readonly ignoreActiveCertificatesOnDeletion?: boolean | cdktf.IResolvable;
    /**
     * Labels with user-defined metadata.
     *
     * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
     * "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#labels PrivatecaCertificateAuthority#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The desired lifetime of the CA certificate.
     *
     * Used to create the "notBeforeTime" and
     * "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
     * fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#lifetime PrivatecaCertificateAuthority#lifetime}
     */
    readonly lifetime?: string;
    /**
     * Location of the CertificateAuthority. A full list of valid locations can be found by running 'gcloud privateca locations list'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#location PrivatecaCertificateAuthority#location}
     */
    readonly location: string;
    /**
     * The name of the CaPool this Certificate Authority belongs to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#pool PrivatecaCertificateAuthority#pool}
     */
    readonly pool: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#project PrivatecaCertificateAuthority#project}.
     */
    readonly project?: string;
    /**
     * The Type of this CertificateAuthority.
     *
     * ~> **Note:** For 'SUBORDINATE' Certificate Authorities, they need to
     * be manually activated (via Cloud Console of 'gcloud') before they can
     * issue certificates. Default value: "SELF_SIGNED" Possible values: ["SELF_SIGNED", "SUBORDINATE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#type PrivatecaCertificateAuthority#type}
     */
    readonly type?: string;
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#config PrivatecaCertificateAuthority#config}
     */
    readonly config: PrivatecaCertificateAuthorityConfigA;
    /**
     * key_spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#key_spec PrivatecaCertificateAuthority#key_spec}
     */
    readonly keySpec: PrivatecaCertificateAuthorityKeySpec;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#timeouts PrivatecaCertificateAuthority#timeouts}
     */
    readonly timeouts?: PrivatecaCertificateAuthorityTimeouts;
}
export declare class PrivatecaCertificateAuthorityAccessUrls extends cdktf.ComplexComputedList {
    get caCertificateAccessUrl(): string;
    get crlAccessUrl(): string;
}
export interface PrivatecaCertificateAuthorityConfigSubjectConfigSubject {
    /**
     * The common name of the distinguished name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#common_name PrivatecaCertificateAuthority#common_name}
     */
    readonly commonName: string;
    /**
     * The country code of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#country_code PrivatecaCertificateAuthority#country_code}
     */
    readonly countryCode?: string;
    /**
     * The locality or city of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#locality PrivatecaCertificateAuthority#locality}
     */
    readonly locality?: string;
    /**
     * The organization of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#organization PrivatecaCertificateAuthority#organization}
     */
    readonly organization: string;
    /**
     * The organizational unit of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#organizational_unit PrivatecaCertificateAuthority#organizational_unit}
     */
    readonly organizationalUnit?: string;
    /**
     * The postal code of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#postal_code PrivatecaCertificateAuthority#postal_code}
     */
    readonly postalCode?: string;
    /**
     * The province, territory, or regional state of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#province PrivatecaCertificateAuthority#province}
     */
    readonly province?: string;
    /**
     * The street address of the subject.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#street_address PrivatecaCertificateAuthority#street_address}
     */
    readonly streetAddress?: string;
}
export declare class PrivatecaCertificateAuthorityConfigSubjectConfigSubjectOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    private _countryCode?;
    get countryCode(): string | undefined;
    set countryCode(value: string | undefined);
    resetCountryCode(): void;
    get countryCodeInput(): string | undefined;
    private _locality?;
    get locality(): string | undefined;
    set locality(value: string | undefined);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _organizationalUnit?;
    get organizationalUnit(): string | undefined;
    set organizationalUnit(value: string | undefined);
    resetOrganizationalUnit(): void;
    get organizationalUnitInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string | undefined;
    set postalCode(value: string | undefined);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _province?;
    get province(): string | undefined;
    set province(value: string | undefined);
    resetProvince(): void;
    get provinceInput(): string | undefined;
    private _streetAddress?;
    get streetAddress(): string | undefined;
    set streetAddress(value: string | undefined);
    resetStreetAddress(): void;
    get streetAddressInput(): string | undefined;
}
export interface PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName {
    /**
     * Contains only valid, fully-qualified host names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#dns_names PrivatecaCertificateAuthority#dns_names}
     */
    readonly dnsNames?: string[];
    /**
     * Contains only valid RFC 2822 E-mail addresses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#email_addresses PrivatecaCertificateAuthority#email_addresses}
     */
    readonly emailAddresses?: string[];
    /**
     * Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#ip_addresses PrivatecaCertificateAuthority#ip_addresses}
     */
    readonly ipAddresses?: string[];
    /**
     * Contains only valid RFC 3986 URIs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#uris PrivatecaCertificateAuthority#uris}
     */
    readonly uris?: string[];
}
export declare class PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dnsNames?;
    get dnsNames(): string[] | undefined;
    set dnsNames(value: string[] | undefined);
    resetDnsNames(): void;
    get dnsNamesInput(): string[] | undefined;
    private _emailAddresses?;
    get emailAddresses(): string[] | undefined;
    set emailAddresses(value: string[] | undefined);
    resetEmailAddresses(): void;
    get emailAddressesInput(): string[] | undefined;
    private _ipAddresses?;
    get ipAddresses(): string[] | undefined;
    set ipAddresses(value: string[] | undefined);
    resetIpAddresses(): void;
    get ipAddressesInput(): string[] | undefined;
    private _uris?;
    get uris(): string[] | undefined;
    set uris(value: string[] | undefined);
    resetUris(): void;
    get urisInput(): string[] | undefined;
}
export interface PrivatecaCertificateAuthorityConfigSubjectConfig {
    /**
     * subject block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#subject PrivatecaCertificateAuthority#subject}
     */
    readonly subject: PrivatecaCertificateAuthorityConfigSubjectConfigSubject;
    /**
     * subject_alt_name block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#subject_alt_name PrivatecaCertificateAuthority#subject_alt_name}
     */
    readonly subjectAltName?: PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName;
}
export declare class PrivatecaCertificateAuthorityConfigSubjectConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _subject?;
    private __subjectOutput;
    get subject(): PrivatecaCertificateAuthorityConfigSubjectConfigSubjectOutputReference;
    putSubject(value: PrivatecaCertificateAuthorityConfigSubjectConfigSubject): void;
    get subjectInput(): PrivatecaCertificateAuthorityConfigSubjectConfigSubject | undefined;
    private _subjectAltName?;
    private __subjectAltNameOutput;
    get subjectAltName(): PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameOutputReference;
    putSubjectAltName(value: PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName | undefined): void;
    resetSubjectAltName(): void;
    get subjectAltNameInput(): PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName | undefined;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#object_id_path PrivatecaCertificateAuthority#object_id_path}
     */
    readonly objectIdPath: number[];
}
export declare class PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions {
    /**
     * Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#critical PrivatecaCertificateAuthority#critical}
     */
    readonly critical: boolean | cdktf.IResolvable;
    /**
     * The value of this X.509 extension. A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#value PrivatecaCertificateAuthority#value}
     */
    readonly value: string;
    /**
     * object_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#object_id PrivatecaCertificateAuthority#object_id}
     */
    readonly objectId: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigCaOptions {
    /**
     * Refers to the "CA" X.509 extension, which is a boolean value. When this value is missing, the extension will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#is_ca PrivatecaCertificateAuthority#is_ca}
     */
    readonly isCa: boolean | cdktf.IResolvable;
    /**
     * Refers to the path length restriction X.509 extension. For a CA certificate, this value describes the depth of subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. If this value is missing, the max path length will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#max_issuer_path_length PrivatecaCertificateAuthority#max_issuer_path_length}
     */
    readonly maxIssuerPathLength?: number;
}
export declare class PrivatecaCertificateAuthorityConfigX509ConfigCaOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isCa?;
    get isCa(): boolean | cdktf.IResolvable;
    set isCa(value: boolean | cdktf.IResolvable);
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    get maxIssuerPathLength(): number | undefined;
    set maxIssuerPathLength(value: number | undefined);
    resetMaxIssuerPathLength(): void;
    get maxIssuerPathLengthInput(): number | undefined;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage {
    /**
     * The key may be used to sign certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#cert_sign PrivatecaCertificateAuthority#cert_sign}
     */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#content_commitment PrivatecaCertificateAuthority#content_commitment}
     */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used sign certificate revocation lists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#crl_sign PrivatecaCertificateAuthority#crl_sign}
     */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#data_encipherment PrivatecaCertificateAuthority#data_encipherment}
     */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to decipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#decipher_only PrivatecaCertificateAuthority#decipher_only}
     */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for digital signatures.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#digital_signature PrivatecaCertificateAuthority#digital_signature}
     */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#encipher_only PrivatecaCertificateAuthority#encipher_only}
     */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used in a key agreement protocol.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#key_agreement PrivatecaCertificateAuthority#key_agreement}
     */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher other keys.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#key_encipherment PrivatecaCertificateAuthority#key_encipherment}
     */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
export declare class PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _certSign?;
    get certSign(): boolean | cdktf.IResolvable | undefined;
    set certSign(value: boolean | cdktf.IResolvable | undefined);
    resetCertSign(): void;
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    get contentCommitment(): boolean | cdktf.IResolvable | undefined;
    set contentCommitment(value: boolean | cdktf.IResolvable | undefined);
    resetContentCommitment(): void;
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    get crlSign(): boolean | cdktf.IResolvable | undefined;
    set crlSign(value: boolean | cdktf.IResolvable | undefined);
    resetCrlSign(): void;
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    get dataEncipherment(): boolean | cdktf.IResolvable | undefined;
    set dataEncipherment(value: boolean | cdktf.IResolvable | undefined);
    resetDataEncipherment(): void;
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    get decipherOnly(): boolean | cdktf.IResolvable | undefined;
    set decipherOnly(value: boolean | cdktf.IResolvable | undefined);
    resetDecipherOnly(): void;
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    get digitalSignature(): boolean | cdktf.IResolvable | undefined;
    set digitalSignature(value: boolean | cdktf.IResolvable | undefined);
    resetDigitalSignature(): void;
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    get encipherOnly(): boolean | cdktf.IResolvable | undefined;
    set encipherOnly(value: boolean | cdktf.IResolvable | undefined);
    resetEncipherOnly(): void;
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    get keyAgreement(): boolean | cdktf.IResolvable | undefined;
    set keyAgreement(value: boolean | cdktf.IResolvable | undefined);
    resetKeyAgreement(): void;
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    get keyEncipherment(): boolean | cdktf.IResolvable | undefined;
    set keyEncipherment(value: boolean | cdktf.IResolvable | undefined);
    resetKeyEncipherment(): void;
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage {
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#client_auth PrivatecaCertificateAuthority#client_auth}
     */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#code_signing PrivatecaCertificateAuthority#code_signing}
     */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#email_protection PrivatecaCertificateAuthority#email_protection}
     */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#ocsp_signing PrivatecaCertificateAuthority#ocsp_signing}
     */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#server_auth PrivatecaCertificateAuthority#server_auth}
     */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#time_stamping PrivatecaCertificateAuthority#time_stamping}
     */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
export declare class PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _clientAuth?;
    get clientAuth(): boolean | cdktf.IResolvable | undefined;
    set clientAuth(value: boolean | cdktf.IResolvable | undefined);
    resetClientAuth(): void;
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    get codeSigning(): boolean | cdktf.IResolvable | undefined;
    set codeSigning(value: boolean | cdktf.IResolvable | undefined);
    resetCodeSigning(): void;
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    get emailProtection(): boolean | cdktf.IResolvable | undefined;
    set emailProtection(value: boolean | cdktf.IResolvable | undefined);
    resetEmailProtection(): void;
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    get ocspSigning(): boolean | cdktf.IResolvable | undefined;
    set ocspSigning(value: boolean | cdktf.IResolvable | undefined);
    resetOcspSigning(): void;
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    get serverAuth(): boolean | cdktf.IResolvable | undefined;
    set serverAuth(value: boolean | cdktf.IResolvable | undefined);
    resetServerAuth(): void;
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    get timeStamping(): boolean | cdktf.IResolvable | undefined;
    set timeStamping(value: boolean | cdktf.IResolvable | undefined);
    resetTimeStamping(): void;
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#object_id_path PrivatecaCertificateAuthority#object_id_path}
     */
    readonly objectIdPath: number[];
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage {
    /**
     * base_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#base_key_usage PrivatecaCertificateAuthority#base_key_usage}
     */
    readonly baseKeyUsage: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage;
    /**
     * extended_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#extended_key_usage PrivatecaCertificateAuthority#extended_key_usage}
     */
    readonly extendedKeyUsage: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage;
    /**
     * unknown_extended_key_usages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#unknown_extended_key_usages PrivatecaCertificateAuthority#unknown_extended_key_usages}
     */
    readonly unknownExtendedKeyUsages?: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[];
}
export declare class PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _baseKeyUsage?;
    private __baseKeyUsageOutput;
    get baseKeyUsage(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageOutputReference;
    putBaseKeyUsage(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage): void;
    get baseKeyUsageInput(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage?;
    private __extendedKeyUsageOutput;
    get extendedKeyUsage(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference;
    putExtendedKeyUsage(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage): void;
    get extendedKeyUsageInput(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages?;
    get unknownExtendedKeyUsages(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | undefined;
    set unknownExtendedKeyUsages(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | undefined);
    resetUnknownExtendedKeyUsages(): void;
    get unknownExtendedKeyUsagesInput(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#object_id_path PrivatecaCertificateAuthority#object_id_path}
     */
    readonly objectIdPath: number[];
}
export interface PrivatecaCertificateAuthorityConfigX509Config {
    /**
     * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#aia_ocsp_servers PrivatecaCertificateAuthority#aia_ocsp_servers}
     */
    readonly aiaOcspServers?: string[];
    /**
     * additional_extensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#additional_extensions PrivatecaCertificateAuthority#additional_extensions}
     */
    readonly additionalExtensions?: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[];
    /**
     * ca_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#ca_options PrivatecaCertificateAuthority#ca_options}
     */
    readonly caOptions: PrivatecaCertificateAuthorityConfigX509ConfigCaOptions;
    /**
     * key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#key_usage PrivatecaCertificateAuthority#key_usage}
     */
    readonly keyUsage: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage;
    /**
     * policy_ids block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#policy_ids PrivatecaCertificateAuthority#policy_ids}
     */
    readonly policyIds?: PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[];
}
export declare class PrivatecaCertificateAuthorityConfigX509ConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aiaOcspServers?;
    get aiaOcspServers(): string[] | undefined;
    set aiaOcspServers(value: string[] | undefined);
    resetAiaOcspServers(): void;
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions?;
    get additionalExtensions(): PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[] | undefined;
    set additionalExtensions(value: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[] | undefined);
    resetAdditionalExtensions(): void;
    get additionalExtensionsInput(): PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[] | undefined;
    private _caOptions?;
    private __caOptionsOutput;
    get caOptions(): PrivatecaCertificateAuthorityConfigX509ConfigCaOptionsOutputReference;
    putCaOptions(value: PrivatecaCertificateAuthorityConfigX509ConfigCaOptions): void;
    get caOptionsInput(): PrivatecaCertificateAuthorityConfigX509ConfigCaOptions | undefined;
    private _keyUsage?;
    private __keyUsageOutput;
    get keyUsage(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageOutputReference;
    putKeyUsage(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage): void;
    get keyUsageInput(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage | undefined;
    private _policyIds?;
    get policyIds(): PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[] | undefined;
    set policyIds(value: PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[] | undefined);
    resetPolicyIds(): void;
    get policyIdsInput(): PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[] | undefined;
}
export interface PrivatecaCertificateAuthorityConfigA {
    /**
     * subject_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#subject_config PrivatecaCertificateAuthority#subject_config}
     */
    readonly subjectConfig: PrivatecaCertificateAuthorityConfigSubjectConfig;
    /**
     * x509_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#x509_config PrivatecaCertificateAuthority#x509_config}
     */
    readonly x509Config: PrivatecaCertificateAuthorityConfigX509Config;
}
export declare class PrivatecaCertificateAuthorityConfigAOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _subjectConfig?;
    private __subjectConfigOutput;
    get subjectConfig(): PrivatecaCertificateAuthorityConfigSubjectConfigOutputReference;
    putSubjectConfig(value: PrivatecaCertificateAuthorityConfigSubjectConfig): void;
    get subjectConfigInput(): PrivatecaCertificateAuthorityConfigSubjectConfig | undefined;
    private _x509Config?;
    private __x509ConfigOutput;
    get x509Config(): PrivatecaCertificateAuthorityConfigX509ConfigOutputReference;
    putX509Config(value: PrivatecaCertificateAuthorityConfigX509Config): void;
    get x509ConfigInput(): PrivatecaCertificateAuthorityConfigX509Config | undefined;
}
export interface PrivatecaCertificateAuthorityKeySpec {
    /**
     * The algorithm to use for creating a managed Cloud KMS key for a for a simplified experience.
     *
     * All managed keys will be have their ProtectionLevel as HSM. Possible values: ["SIGN_HASH_ALGORITHM_UNSPECIFIED", "RSA_PSS_2048_SHA256", "RSA_PSS_3072_SHA256", "RSA_PSS_4096_SHA256", "RSA_PKCS1_2048_SHA256", "RSA_PKCS1_3072_SHA256", "RSA_PKCS1_4096_SHA256", "EC_P256_SHA256", "EC_P384_SHA384"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#algorithm PrivatecaCertificateAuthority#algorithm}
     */
    readonly algorithm?: string;
    /**
     * The resource name for an existing Cloud KMS CryptoKeyVersion in the format 'projects/*\/locations/*\/keyRings/*\/cryptoKeys/*\/cryptoKeyVersions/*'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#cloud_kms_key_version PrivatecaCertificateAuthority#cloud_kms_key_version}
     */
    readonly cloudKmsKeyVersion?: string;
}
export declare class PrivatecaCertificateAuthorityKeySpecOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _algorithm?;
    get algorithm(): string | undefined;
    set algorithm(value: string | undefined);
    resetAlgorithm(): void;
    get algorithmInput(): string | undefined;
    private _cloudKmsKeyVersion?;
    get cloudKmsKeyVersion(): string | undefined;
    set cloudKmsKeyVersion(value: string | undefined);
    resetCloudKmsKeyVersion(): void;
    get cloudKmsKeyVersionInput(): string | undefined;
}
export interface PrivatecaCertificateAuthorityTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#create PrivatecaCertificateAuthority#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html#delete PrivatecaCertificateAuthority#delete}.
     */
    readonly delete?: string;
}
export declare class PrivatecaCertificateAuthorityTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html google_privateca_certificate_authority}.
 */
export declare class PrivatecaCertificateAuthority extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority.html google_privateca_certificate_authority} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: PrivatecaCertificateAuthorityConfig);
    accessUrls(index: string): PrivatecaCertificateAuthorityAccessUrls;
    private _certificateAuthorityId?;
    get certificateAuthorityId(): string;
    set certificateAuthorityId(value: string);
    get certificateAuthorityIdInput(): string | undefined;
    get createTime(): string;
    private _gcsBucket?;
    get gcsBucket(): string | undefined;
    set gcsBucket(value: string | undefined);
    resetGcsBucket(): void;
    get gcsBucketInput(): string | undefined;
    get id(): string;
    private _ignoreActiveCertificatesOnDeletion?;
    get ignoreActiveCertificatesOnDeletion(): boolean | cdktf.IResolvable | undefined;
    set ignoreActiveCertificatesOnDeletion(value: boolean | cdktf.IResolvable | undefined);
    resetIgnoreActiveCertificatesOnDeletion(): void;
    get ignoreActiveCertificatesOnDeletionInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _lifetime?;
    get lifetime(): string | undefined;
    set lifetime(value: string | undefined);
    resetLifetime(): void;
    get lifetimeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    get pemCaCertificates(): string[];
    private _pool?;
    get pool(): string;
    set pool(value: string);
    get poolInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    resetType(): void;
    get typeInput(): string | undefined;
    get updateTime(): string;
    private _config?;
    private __configOutput;
    get config(): PrivatecaCertificateAuthorityConfigAOutputReference;
    putConfig(value: PrivatecaCertificateAuthorityConfigA): void;
    get configInput(): PrivatecaCertificateAuthorityConfigA | undefined;
    private _keySpec?;
    private __keySpecOutput;
    get keySpec(): PrivatecaCertificateAuthorityKeySpecOutputReference;
    putKeySpec(value: PrivatecaCertificateAuthorityKeySpec): void;
    get keySpecInput(): PrivatecaCertificateAuthorityKeySpec | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): PrivatecaCertificateAuthorityTimeoutsOutputReference;
    putTimeouts(value: PrivatecaCertificateAuthorityTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): PrivatecaCertificateAuthorityTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
