import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatecaCaPoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Labels with user-defined metadata.
     *
     * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
     * "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#labels PrivatecaCaPool#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Location of the CaPool. A full list of valid locations can be found by running 'gcloud privateca locations list'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#location PrivatecaCaPool#location}
     */
    readonly location: string;
    /**
     * The name for this CaPool.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#name PrivatecaCaPool#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#project PrivatecaCaPool#project}.
     */
    readonly project?: string;
    /**
     * The Tier of this CaPool. Possible values: ["ENTERPRISE", "DEVOPS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#tier PrivatecaCaPool#tier}
     */
    readonly tier: string;
    /**
     * issuance_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#issuance_policy PrivatecaCaPool#issuance_policy}
     */
    readonly issuancePolicy?: PrivatecaCaPoolIssuancePolicy;
    /**
     * publishing_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#publishing_options PrivatecaCaPool#publishing_options}
     */
    readonly publishingOptions?: PrivatecaCaPoolPublishingOptions;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#timeouts PrivatecaCaPool#timeouts}
     */
    readonly timeouts?: PrivatecaCaPoolTimeouts;
}
export interface PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes {
    /**
     * When true, allows callers to create Certificates by specifying a CertificateConfig.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#allow_config_based_issuance PrivatecaCaPool#allow_config_based_issuance}
     */
    readonly allowConfigBasedIssuance: boolean | cdktf.IResolvable;
    /**
     * When true, allows callers to create Certificates by specifying a CSR.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#allow_csr_based_issuance PrivatecaCaPool#allow_csr_based_issuance}
     */
    readonly allowCsrBasedIssuance: boolean | cdktf.IResolvable;
}
export declare class PrivatecaCaPoolIssuancePolicyAllowedIssuanceModesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowConfigBasedIssuance?;
    get allowConfigBasedIssuance(): boolean | cdktf.IResolvable;
    set allowConfigBasedIssuance(value: boolean | cdktf.IResolvable);
    get allowConfigBasedIssuanceInput(): boolean | cdktf.IResolvable | undefined;
    private _allowCsrBasedIssuance?;
    get allowCsrBasedIssuance(): boolean | cdktf.IResolvable;
    set allowCsrBasedIssuance(value: boolean | cdktf.IResolvable);
    get allowCsrBasedIssuanceInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve {
    /**
     * The algorithm used. Possible values: ["ECDSA_P256", "ECDSA_P384", "EDDSA_25519"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#signature_algorithm PrivatecaCaPool#signature_algorithm}
     */
    readonly signatureAlgorithm: string;
}
export declare class PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _signatureAlgorithm?;
    get signatureAlgorithm(): string;
    set signatureAlgorithm(value: string);
    get signatureAlgorithmInput(): string | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa {
    /**
     * The maximum allowed RSA modulus size, in bits.
     *
     * If this is not set, or if set to zero, the
     * service will not enforce an explicit upper bound on RSA modulus sizes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#max_modulus_size PrivatecaCaPool#max_modulus_size}
     */
    readonly maxModulusSize?: string;
    /**
     * The minimum allowed RSA modulus size, in bits.
     *
     * If this is not set, or if set to zero, the
     * service-level min RSA modulus size will continue to apply.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#min_modulus_size PrivatecaCaPool#min_modulus_size}
     */
    readonly minModulusSize?: string;
}
export declare class PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxModulusSize?;
    get maxModulusSize(): string | undefined;
    set maxModulusSize(value: string | undefined);
    resetMaxModulusSize(): void;
    get maxModulusSizeInput(): string | undefined;
    private _minModulusSize?;
    get minModulusSize(): string | undefined;
    set minModulusSize(value: string | undefined);
    resetMinModulusSize(): void;
    get minModulusSizeInput(): string | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyAllowedKeyTypes {
    /**
     * elliptic_curve block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#elliptic_curve PrivatecaCaPool#elliptic_curve}
     */
    readonly ellipticCurve?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve;
    /**
     * rsa block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#rsa PrivatecaCaPool#rsa}
     */
    readonly rsa?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#object_id_path PrivatecaCaPool#object_id_path}
     */
    readonly objectIdPath: number[];
}
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions {
    /**
     * Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#critical PrivatecaCaPool#critical}
     */
    readonly critical: boolean | cdktf.IResolvable;
    /**
     * The value of this X.509 extension. A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#value PrivatecaCaPool#value}
     */
    readonly value: string;
    /**
     * object_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#object_id PrivatecaCaPool#object_id}
     */
    readonly objectId: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions {
    /**
     * Refers to the "CA" X.509 extension, which is a boolean value. When this value is missing, the extension will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#is_ca PrivatecaCaPool#is_ca}
     */
    readonly isCa?: boolean | cdktf.IResolvable;
    /**
     * Refers to the path length restriction X.509 extension. For a CA certificate, this value describes the depth of subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. If this value is missing, the max path length will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#max_issuer_path_length PrivatecaCaPool#max_issuer_path_length}
     */
    readonly maxIssuerPathLength?: number;
}
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isCa?;
    get isCa(): boolean | cdktf.IResolvable | undefined;
    set isCa(value: boolean | cdktf.IResolvable | undefined);
    resetIsCa(): void;
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    get maxIssuerPathLength(): number | undefined;
    set maxIssuerPathLength(value: number | undefined);
    resetMaxIssuerPathLength(): void;
    get maxIssuerPathLengthInput(): number | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage {
    /**
     * The key may be used to sign certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#cert_sign PrivatecaCaPool#cert_sign}
     */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#content_commitment PrivatecaCaPool#content_commitment}
     */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used sign certificate revocation lists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#crl_sign PrivatecaCaPool#crl_sign}
     */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#data_encipherment PrivatecaCaPool#data_encipherment}
     */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to decipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#decipher_only PrivatecaCaPool#decipher_only}
     */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for digital signatures.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#digital_signature PrivatecaCaPool#digital_signature}
     */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#encipher_only PrivatecaCaPool#encipher_only}
     */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used in a key agreement protocol.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#key_agreement PrivatecaCaPool#key_agreement}
     */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher other keys.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#key_encipherment PrivatecaCaPool#key_encipherment}
     */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _certSign?;
    get certSign(): boolean | cdktf.IResolvable | undefined;
    set certSign(value: boolean | cdktf.IResolvable | undefined);
    resetCertSign(): void;
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    get contentCommitment(): boolean | cdktf.IResolvable | undefined;
    set contentCommitment(value: boolean | cdktf.IResolvable | undefined);
    resetContentCommitment(): void;
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    get crlSign(): boolean | cdktf.IResolvable | undefined;
    set crlSign(value: boolean | cdktf.IResolvable | undefined);
    resetCrlSign(): void;
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    get dataEncipherment(): boolean | cdktf.IResolvable | undefined;
    set dataEncipherment(value: boolean | cdktf.IResolvable | undefined);
    resetDataEncipherment(): void;
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    get decipherOnly(): boolean | cdktf.IResolvable | undefined;
    set decipherOnly(value: boolean | cdktf.IResolvable | undefined);
    resetDecipherOnly(): void;
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    get digitalSignature(): boolean | cdktf.IResolvable | undefined;
    set digitalSignature(value: boolean | cdktf.IResolvable | undefined);
    resetDigitalSignature(): void;
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    get encipherOnly(): boolean | cdktf.IResolvable | undefined;
    set encipherOnly(value: boolean | cdktf.IResolvable | undefined);
    resetEncipherOnly(): void;
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    get keyAgreement(): boolean | cdktf.IResolvable | undefined;
    set keyAgreement(value: boolean | cdktf.IResolvable | undefined);
    resetKeyAgreement(): void;
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    get keyEncipherment(): boolean | cdktf.IResolvable | undefined;
    set keyEncipherment(value: boolean | cdktf.IResolvable | undefined);
    resetKeyEncipherment(): void;
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage {
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#client_auth PrivatecaCaPool#client_auth}
     */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#code_signing PrivatecaCaPool#code_signing}
     */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#email_protection PrivatecaCaPool#email_protection}
     */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#ocsp_signing PrivatecaCaPool#ocsp_signing}
     */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#server_auth PrivatecaCaPool#server_auth}
     */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#time_stamping PrivatecaCaPool#time_stamping}
     */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _clientAuth?;
    get clientAuth(): boolean | cdktf.IResolvable | undefined;
    set clientAuth(value: boolean | cdktf.IResolvable | undefined);
    resetClientAuth(): void;
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    get codeSigning(): boolean | cdktf.IResolvable | undefined;
    set codeSigning(value: boolean | cdktf.IResolvable | undefined);
    resetCodeSigning(): void;
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    get emailProtection(): boolean | cdktf.IResolvable | undefined;
    set emailProtection(value: boolean | cdktf.IResolvable | undefined);
    resetEmailProtection(): void;
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    get ocspSigning(): boolean | cdktf.IResolvable | undefined;
    set ocspSigning(value: boolean | cdktf.IResolvable | undefined);
    resetOcspSigning(): void;
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    get serverAuth(): boolean | cdktf.IResolvable | undefined;
    set serverAuth(value: boolean | cdktf.IResolvable | undefined);
    resetServerAuth(): void;
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    get timeStamping(): boolean | cdktf.IResolvable | undefined;
    set timeStamping(value: boolean | cdktf.IResolvable | undefined);
    resetTimeStamping(): void;
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#object_id_path PrivatecaCaPool#object_id_path}
     */
    readonly objectIdPath: number[];
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage {
    /**
     * base_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#base_key_usage PrivatecaCaPool#base_key_usage}
     */
    readonly baseKeyUsage: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage;
    /**
     * extended_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#extended_key_usage PrivatecaCaPool#extended_key_usage}
     */
    readonly extendedKeyUsage: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage;
    /**
     * unknown_extended_key_usages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#unknown_extended_key_usages PrivatecaCaPool#unknown_extended_key_usages}
     */
    readonly unknownExtendedKeyUsages?: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[];
}
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _baseKeyUsage?;
    private __baseKeyUsageOutput;
    get baseKeyUsage(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageOutputReference;
    putBaseKeyUsage(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage): void;
    get baseKeyUsageInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage?;
    private __extendedKeyUsageOutput;
    get extendedKeyUsage(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageOutputReference;
    putExtendedKeyUsage(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage): void;
    get extendedKeyUsageInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages?;
    get unknownExtendedKeyUsages(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | undefined;
    set unknownExtendedKeyUsages(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | undefined);
    resetUnknownExtendedKeyUsages(): void;
    get unknownExtendedKeyUsagesInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#object_id_path PrivatecaCaPool#object_id_path}
     */
    readonly objectIdPath: number[];
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValues {
    /**
     * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#aia_ocsp_servers PrivatecaCaPool#aia_ocsp_servers}
     */
    readonly aiaOcspServers?: string[];
    /**
     * additional_extensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#additional_extensions PrivatecaCaPool#additional_extensions}
     */
    readonly additionalExtensions?: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[];
    /**
     * ca_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#ca_options PrivatecaCaPool#ca_options}
     */
    readonly caOptions: PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions;
    /**
     * key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#key_usage PrivatecaCaPool#key_usage}
     */
    readonly keyUsage: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage;
    /**
     * policy_ids block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#policy_ids PrivatecaCaPool#policy_ids}
     */
    readonly policyIds?: PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[];
}
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aiaOcspServers?;
    get aiaOcspServers(): string[] | undefined;
    set aiaOcspServers(value: string[] | undefined);
    resetAiaOcspServers(): void;
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions?;
    get additionalExtensions(): PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | undefined;
    set additionalExtensions(value: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | undefined);
    resetAdditionalExtensions(): void;
    get additionalExtensionsInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | undefined;
    private _caOptions?;
    private __caOptionsOutput;
    get caOptions(): PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsOutputReference;
    putCaOptions(value: PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions): void;
    get caOptionsInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions | undefined;
    private _keyUsage?;
    private __keyUsageOutput;
    get keyUsage(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageOutputReference;
    putKeyUsage(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage): void;
    get keyUsageInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage | undefined;
    private _policyIds?;
    get policyIds(): PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | undefined;
    set policyIds(value: PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | undefined);
    resetPolicyIds(): void;
    get policyIdsInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression {
    /**
     * Description of the expression.
     *
     * This is a longer text which describes the expression, e.g. when hovered over it in a UI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#description PrivatecaCaPool#description}
     */
    readonly description?: string;
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#expression PrivatecaCaPool#expression}
     */
    readonly expression: string;
    /**
     * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#location PrivatecaCaPool#location}
     */
    readonly location?: string;
    /**
     * Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#title PrivatecaCaPool#title}
     */
    readonly title?: string;
}
export declare class PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string | undefined;
    set title(value: string | undefined);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyIdentityConstraints {
    /**
     * If this is set, the SubjectAltNames extension may be copied from a certificate request into the signed certificate.
     *
     * Otherwise, the requested SubjectAltNames will be discarded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#allow_subject_alt_names_passthrough PrivatecaCaPool#allow_subject_alt_names_passthrough}
     */
    readonly allowSubjectAltNamesPassthrough: boolean | cdktf.IResolvable;
    /**
     * If this is set, the Subject field may be copied from a certificate request into the signed certificate.
     *
     * Otherwise, the requested Subject will be discarded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#allow_subject_passthrough PrivatecaCaPool#allow_subject_passthrough}
     */
    readonly allowSubjectPassthrough: boolean | cdktf.IResolvable;
    /**
     * cel_expression block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#cel_expression PrivatecaCaPool#cel_expression}
     */
    readonly celExpression?: PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression;
}
export declare class PrivatecaCaPoolIssuancePolicyIdentityConstraintsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowSubjectAltNamesPassthrough?;
    get allowSubjectAltNamesPassthrough(): boolean | cdktf.IResolvable;
    set allowSubjectAltNamesPassthrough(value: boolean | cdktf.IResolvable);
    get allowSubjectAltNamesPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _allowSubjectPassthrough?;
    get allowSubjectPassthrough(): boolean | cdktf.IResolvable;
    set allowSubjectPassthrough(value: boolean | cdktf.IResolvable);
    get allowSubjectPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _celExpression?;
    private __celExpressionOutput;
    get celExpression(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionOutputReference;
    putCelExpression(value: PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression | undefined): void;
    resetCelExpression(): void;
    get celExpressionInput(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression | undefined;
}
export interface PrivatecaCaPoolIssuancePolicy {
    /**
     * The maximum lifetime allowed for issued Certificates.
     *
     * Note that if the issuing CertificateAuthority
     * expires before a Certificate's requested maximumLifetime, the effective lifetime will be explicitly truncated to match it.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#maximum_lifetime PrivatecaCaPool#maximum_lifetime}
     */
    readonly maximumLifetime?: string;
    /**
     * allowed_issuance_modes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#allowed_issuance_modes PrivatecaCaPool#allowed_issuance_modes}
     */
    readonly allowedIssuanceModes?: PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes;
    /**
     * allowed_key_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#allowed_key_types PrivatecaCaPool#allowed_key_types}
     */
    readonly allowedKeyTypes?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[];
    /**
     * baseline_values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#baseline_values PrivatecaCaPool#baseline_values}
     */
    readonly baselineValues?: PrivatecaCaPoolIssuancePolicyBaselineValues;
    /**
     * identity_constraints block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#identity_constraints PrivatecaCaPool#identity_constraints}
     */
    readonly identityConstraints?: PrivatecaCaPoolIssuancePolicyIdentityConstraints;
}
export declare class PrivatecaCaPoolIssuancePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maximumLifetime?;
    get maximumLifetime(): string | undefined;
    set maximumLifetime(value: string | undefined);
    resetMaximumLifetime(): void;
    get maximumLifetimeInput(): string | undefined;
    private _allowedIssuanceModes?;
    private __allowedIssuanceModesOutput;
    get allowedIssuanceModes(): PrivatecaCaPoolIssuancePolicyAllowedIssuanceModesOutputReference;
    putAllowedIssuanceModes(value: PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes | undefined): void;
    resetAllowedIssuanceModes(): void;
    get allowedIssuanceModesInput(): PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes | undefined;
    private _allowedKeyTypes?;
    get allowedKeyTypes(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | undefined;
    set allowedKeyTypes(value: PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | undefined);
    resetAllowedKeyTypes(): void;
    get allowedKeyTypesInput(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | undefined;
    private _baselineValues?;
    private __baselineValuesOutput;
    get baselineValues(): PrivatecaCaPoolIssuancePolicyBaselineValuesOutputReference;
    putBaselineValues(value: PrivatecaCaPoolIssuancePolicyBaselineValues | undefined): void;
    resetBaselineValues(): void;
    get baselineValuesInput(): PrivatecaCaPoolIssuancePolicyBaselineValues | undefined;
    private _identityConstraints?;
    private __identityConstraintsOutput;
    get identityConstraints(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsOutputReference;
    putIdentityConstraints(value: PrivatecaCaPoolIssuancePolicyIdentityConstraints | undefined): void;
    resetIdentityConstraints(): void;
    get identityConstraintsInput(): PrivatecaCaPoolIssuancePolicyIdentityConstraints | undefined;
}
export interface PrivatecaCaPoolPublishingOptions {
    /**
     * When true, publishes each CertificateAuthority's CA certificate and includes its URL in the "Authority Information Access" X.509 extension in all issued Certificates. If this is false, the CA certificate will not be published and the corresponding X.509 extension will not be written in issued certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#publish_ca_cert PrivatecaCaPool#publish_ca_cert}
     */
    readonly publishCaCert: boolean | cdktf.IResolvable;
    /**
     * When true, publishes each CertificateAuthority's CRL and includes its URL in the "CRL Distribution Points" X.509 extension in all issued Certificates. If this is false, CRLs will not be published and the corresponding X.509 extension will not be written in issued certificates. CRLs will expire 7 days from their creation. However, we will rebuild daily. CRLs are also rebuilt shortly after a certificate is revoked.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#publish_crl PrivatecaCaPool#publish_crl}
     */
    readonly publishCrl: boolean | cdktf.IResolvable;
}
export declare class PrivatecaCaPoolPublishingOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _publishCaCert?;
    get publishCaCert(): boolean | cdktf.IResolvable;
    set publishCaCert(value: boolean | cdktf.IResolvable);
    get publishCaCertInput(): boolean | cdktf.IResolvable | undefined;
    private _publishCrl?;
    get publishCrl(): boolean | cdktf.IResolvable;
    set publishCrl(value: boolean | cdktf.IResolvable);
    get publishCrlInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCaPoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#create PrivatecaCaPool#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#delete PrivatecaCaPool#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#update PrivatecaCaPool#update}.
     */
    readonly update?: string;
}
export declare class PrivatecaCaPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html google_privateca_ca_pool}.
 */
export declare class PrivatecaCaPool extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html google_privateca_ca_pool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: PrivatecaCaPoolConfig);
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _issuancePolicy?;
    private __issuancePolicyOutput;
    get issuancePolicy(): PrivatecaCaPoolIssuancePolicyOutputReference;
    putIssuancePolicy(value: PrivatecaCaPoolIssuancePolicy | undefined): void;
    resetIssuancePolicy(): void;
    get issuancePolicyInput(): PrivatecaCaPoolIssuancePolicy | undefined;
    private _publishingOptions?;
    private __publishingOptionsOutput;
    get publishingOptions(): PrivatecaCaPoolPublishingOptionsOutputReference;
    putPublishingOptions(value: PrivatecaCaPoolPublishingOptions | undefined): void;
    resetPublishingOptions(): void;
    get publishingOptionsInput(): PrivatecaCaPoolPublishingOptions | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): PrivatecaCaPoolTimeoutsOutputReference;
    putTimeouts(value: PrivatecaCaPoolTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): PrivatecaCaPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
