import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatecaCaPoolIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_policy.html#ca_pool PrivatecaCaPoolIamPolicy#ca_pool}.
     */
    readonly caPool: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_policy.html#location PrivatecaCaPoolIamPolicy#location}.
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_policy.html#policy_data PrivatecaCaPoolIamPolicy#policy_data}.
     */
    readonly policyData: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_policy.html#project PrivatecaCaPoolIamPolicy#project}.
     */
    readonly project?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_policy.html google_privateca_ca_pool_iam_policy}.
 */
export declare class PrivatecaCaPoolIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_policy.html google_privateca_ca_pool_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: PrivatecaCaPoolIamPolicyConfig);
    private _caPool?;
    get caPool(): string;
    set caPool(value: string);
    get caPoolInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
