import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OsConfigPatchDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the patch deployment. Length of the description is limited to 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#description OsConfigPatchDeployment#description}
     */
    readonly description?: string;
    /**
     * Duration of the patch.
     *
     * After the duration ends, the patch times out.
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#duration OsConfigPatchDeployment#duration}
     */
    readonly duration?: string;
    /**
     * A name for the patch deployment in the project.
     *
     * When creating a name the following rules apply:
     * Must contain only lowercase letters, numbers, and hyphens.
     * Must start with a letter.
     * Must be between 1-63 characters.
     * Must end with a number or a letter.
     * Must be unique within the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#patch_deployment_id OsConfigPatchDeployment#patch_deployment_id}
     */
    readonly patchDeploymentId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#project OsConfigPatchDeployment#project}.
     */
    readonly project?: string;
    /**
     * instance_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#instance_filter OsConfigPatchDeployment#instance_filter}
     */
    readonly instanceFilter: OsConfigPatchDeploymentInstanceFilter;
    /**
     * one_time_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#one_time_schedule OsConfigPatchDeployment#one_time_schedule}
     */
    readonly oneTimeSchedule?: OsConfigPatchDeploymentOneTimeSchedule;
    /**
     * patch_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#patch_config OsConfigPatchDeployment#patch_config}
     */
    readonly patchConfig?: OsConfigPatchDeploymentPatchConfig;
    /**
     * recurring_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#recurring_schedule OsConfigPatchDeployment#recurring_schedule}
     */
    readonly recurringSchedule?: OsConfigPatchDeploymentRecurringSchedule;
    /**
     * rollout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#rollout OsConfigPatchDeployment#rollout}
     */
    readonly rollout?: OsConfigPatchDeploymentRollout;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#timeouts OsConfigPatchDeployment#timeouts}
     */
    readonly timeouts?: OsConfigPatchDeploymentTimeouts;
}
export interface OsConfigPatchDeploymentInstanceFilterGroupLabels {
    /**
     * Compute Engine instance labels that must be present for a VM instance to be targeted by this filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#labels OsConfigPatchDeployment#labels}
     */
    readonly labels: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export interface OsConfigPatchDeploymentInstanceFilter {
    /**
     * Target all VM instances in the project. If true, no other criteria is permitted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#all OsConfigPatchDeployment#all}
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * Targets VMs whose name starts with one of these prefixes.
     *
     * Similar to labels, this is another way to group
     * VMs when targeting configs, for example prefix="prod-".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#instance_name_prefixes OsConfigPatchDeployment#instance_name_prefixes}
     */
    readonly instanceNamePrefixes?: string[];
    /**
     * Targets any of the VM instances specified. Instances are specified by their URI in the 'form zones/{{zone}}/instances/{{instance_name}}', 'projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}', or 'https://www.googleapis.com/compute/v1/projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#instances OsConfigPatchDeployment#instances}
     */
    readonly instances?: string[];
    /**
     * Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#zones OsConfigPatchDeployment#zones}
     */
    readonly zones?: string[];
    /**
     * group_labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#group_labels OsConfigPatchDeployment#group_labels}
     */
    readonly groupLabels?: OsConfigPatchDeploymentInstanceFilterGroupLabels[];
}
export declare class OsConfigPatchDeploymentInstanceFilterOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _all?;
    get all(): boolean | cdktf.IResolvable | undefined;
    set all(value: boolean | cdktf.IResolvable | undefined);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _instanceNamePrefixes?;
    get instanceNamePrefixes(): string[] | undefined;
    set instanceNamePrefixes(value: string[] | undefined);
    resetInstanceNamePrefixes(): void;
    get instanceNamePrefixesInput(): string[] | undefined;
    private _instances?;
    get instances(): string[] | undefined;
    set instances(value: string[] | undefined);
    resetInstances(): void;
    get instancesInput(): string[] | undefined;
    private _zones?;
    get zones(): string[] | undefined;
    set zones(value: string[] | undefined);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _groupLabels?;
    get groupLabels(): OsConfigPatchDeploymentInstanceFilterGroupLabels[] | undefined;
    set groupLabels(value: OsConfigPatchDeploymentInstanceFilterGroupLabels[] | undefined);
    resetGroupLabels(): void;
    get groupLabelsInput(): OsConfigPatchDeploymentInstanceFilterGroupLabels[] | undefined;
}
export interface OsConfigPatchDeploymentOneTimeSchedule {
    /**
     * The desired patch job execution time. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#execute_time OsConfigPatchDeployment#execute_time}
     */
    readonly executeTime: string;
}
export declare class OsConfigPatchDeploymentOneTimeScheduleOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _executeTime?;
    get executeTime(): string;
    set executeTime(value: string);
    get executeTimeInput(): string | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigApt {
    /**
     * List of packages to exclude from update. These packages will be excluded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#excludes OsConfigPatchDeployment#excludes}
     */
    readonly excludes?: string[];
    /**
     * An exclusive list of packages to be updated.
     *
     * These are the only packages that will be updated.
     * If these packages are not installed, they will be ignored. This field cannot be specified with
     * any other patch configuration fields.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#exclusive_packages OsConfigPatchDeployment#exclusive_packages}
     */
    readonly exclusivePackages?: string[];
    /**
     * By changing the type to DIST, the patching is performed using apt-get dist-upgrade instead. Possible values: ["DIST", "UPGRADE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#type OsConfigPatchDeployment#type}
     */
    readonly type?: string;
}
export declare class OsConfigPatchDeploymentPatchConfigAptOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _excludes?;
    get excludes(): string[] | undefined;
    set excludes(value: string[] | undefined);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    private _exclusivePackages?;
    get exclusivePackages(): string[] | undefined;
    set exclusivePackages(value: string[] | undefined);
    resetExclusivePackages(): void;
    get exclusivePackagesInput(): string[] | undefined;
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigGoo {
    /**
     * goo update settings. Use this setting to override the default goo patch rules.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#enabled OsConfigPatchDeployment#enabled}
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare class OsConfigPatchDeploymentPatchConfigGooOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject {
    /**
     * Bucket of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#bucket OsConfigPatchDeployment#bucket}
     */
    readonly bucket: string;
    /**
     * Generation number of the Cloud Storage object.
     *
     * This is used to ensure that the ExecStep specified by this PatchJob does not change.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#generation_number OsConfigPatchDeployment#generation_number}
     */
    readonly generationNumber: string;
    /**
     * Name of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#object OsConfigPatchDeployment#object}
     */
    readonly object: string;
}
export declare class OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generationNumber?;
    get generationNumber(): string;
    set generationNumber(value: string);
    get generationNumberInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig {
    /**
     * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
     */
    readonly allowedSuccessCodes?: number[];
    /**
     * The script interpreter to use to run the script.
     *
     * If no interpreter is specified the script will
     * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#interpreter OsConfigPatchDeployment#interpreter}
     */
    readonly interpreter?: string;
    /**
     * An absolute path to the executable on the VM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#local_path OsConfigPatchDeployment#local_path}
     */
    readonly localPath?: string;
    /**
     * gcs_object block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#gcs_object OsConfigPatchDeployment#gcs_object}
     */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject;
}
export declare class OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowedSuccessCodes?;
    get allowedSuccessCodes(): number[] | undefined;
    set allowedSuccessCodes(value: number[] | undefined);
    resetAllowedSuccessCodes(): void;
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string | undefined;
    set interpreter(value: string | undefined);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _localPath?;
    get localPath(): string | undefined;
    set localPath(value: string | undefined);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcsObject?;
    private __gcsObjectOutput;
    get gcsObject(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectOutputReference;
    putGcsObject(value: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject | undefined): void;
    resetGcsObject(): void;
    get gcsObjectInput(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject {
    /**
     * Bucket of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#bucket OsConfigPatchDeployment#bucket}
     */
    readonly bucket: string;
    /**
     * Generation number of the Cloud Storage object.
     *
     * This is used to ensure that the ExecStep specified by this PatchJob does not change.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#generation_number OsConfigPatchDeployment#generation_number}
     */
    readonly generationNumber: string;
    /**
     * Name of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#object OsConfigPatchDeployment#object}
     */
    readonly object: string;
}
export declare class OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generationNumber?;
    get generationNumber(): string;
    set generationNumber(value: string);
    get generationNumberInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig {
    /**
     * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
     */
    readonly allowedSuccessCodes?: number[];
    /**
     * The script interpreter to use to run the script.
     *
     * If no interpreter is specified the script will
     * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#interpreter OsConfigPatchDeployment#interpreter}
     */
    readonly interpreter?: string;
    /**
     * An absolute path to the executable on the VM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#local_path OsConfigPatchDeployment#local_path}
     */
    readonly localPath?: string;
    /**
     * gcs_object block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#gcs_object OsConfigPatchDeployment#gcs_object}
     */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject;
}
export declare class OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowedSuccessCodes?;
    get allowedSuccessCodes(): number[] | undefined;
    set allowedSuccessCodes(value: number[] | undefined);
    resetAllowedSuccessCodes(): void;
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string | undefined;
    set interpreter(value: string | undefined);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _localPath?;
    get localPath(): string | undefined;
    set localPath(value: string | undefined);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcsObject?;
    private __gcsObjectOutput;
    get gcsObject(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectOutputReference;
    putGcsObject(value: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject | undefined): void;
    resetGcsObject(): void;
    get gcsObjectInput(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPostStep {
    /**
     * linux_exec_step_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#linux_exec_step_config OsConfigPatchDeployment#linux_exec_step_config}
     */
    readonly linuxExecStepConfig?: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig;
    /**
     * windows_exec_step_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#windows_exec_step_config OsConfigPatchDeployment#windows_exec_step_config}
     */
    readonly windowsExecStepConfig?: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig;
}
export declare class OsConfigPatchDeploymentPatchConfigPostStepOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _linuxExecStepConfig?;
    private __linuxExecStepConfigOutput;
    get linuxExecStepConfig(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigOutputReference;
    putLinuxExecStepConfig(value: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig | undefined): void;
    resetLinuxExecStepConfig(): void;
    get linuxExecStepConfigInput(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig | undefined;
    private _windowsExecStepConfig?;
    private __windowsExecStepConfigOutput;
    get windowsExecStepConfig(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigOutputReference;
    putWindowsExecStepConfig(value: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig | undefined): void;
    resetWindowsExecStepConfig(): void;
    get windowsExecStepConfigInput(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject {
    /**
     * Bucket of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#bucket OsConfigPatchDeployment#bucket}
     */
    readonly bucket: string;
    /**
     * Generation number of the Cloud Storage object.
     *
     * This is used to ensure that the ExecStep specified by this PatchJob does not change.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#generation_number OsConfigPatchDeployment#generation_number}
     */
    readonly generationNumber: string;
    /**
     * Name of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#object OsConfigPatchDeployment#object}
     */
    readonly object: string;
}
export declare class OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generationNumber?;
    get generationNumber(): string;
    set generationNumber(value: string);
    get generationNumberInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig {
    /**
     * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
     */
    readonly allowedSuccessCodes?: number[];
    /**
     * The script interpreter to use to run the script.
     *
     * If no interpreter is specified the script will
     * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#interpreter OsConfigPatchDeployment#interpreter}
     */
    readonly interpreter?: string;
    /**
     * An absolute path to the executable on the VM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#local_path OsConfigPatchDeployment#local_path}
     */
    readonly localPath?: string;
    /**
     * gcs_object block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#gcs_object OsConfigPatchDeployment#gcs_object}
     */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject;
}
export declare class OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowedSuccessCodes?;
    get allowedSuccessCodes(): number[] | undefined;
    set allowedSuccessCodes(value: number[] | undefined);
    resetAllowedSuccessCodes(): void;
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string | undefined;
    set interpreter(value: string | undefined);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _localPath?;
    get localPath(): string | undefined;
    set localPath(value: string | undefined);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcsObject?;
    private __gcsObjectOutput;
    get gcsObject(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectOutputReference;
    putGcsObject(value: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject | undefined): void;
    resetGcsObject(): void;
    get gcsObjectInput(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject {
    /**
     * Bucket of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#bucket OsConfigPatchDeployment#bucket}
     */
    readonly bucket: string;
    /**
     * Generation number of the Cloud Storage object.
     *
     * This is used to ensure that the ExecStep specified by this PatchJob does not change.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#generation_number OsConfigPatchDeployment#generation_number}
     */
    readonly generationNumber: string;
    /**
     * Name of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#object OsConfigPatchDeployment#object}
     */
    readonly object: string;
}
export declare class OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generationNumber?;
    get generationNumber(): string;
    set generationNumber(value: string);
    get generationNumberInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig {
    /**
     * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
     */
    readonly allowedSuccessCodes?: number[];
    /**
     * The script interpreter to use to run the script.
     *
     * If no interpreter is specified the script will
     * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#interpreter OsConfigPatchDeployment#interpreter}
     */
    readonly interpreter?: string;
    /**
     * An absolute path to the executable on the VM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#local_path OsConfigPatchDeployment#local_path}
     */
    readonly localPath?: string;
    /**
     * gcs_object block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#gcs_object OsConfigPatchDeployment#gcs_object}
     */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject;
}
export declare class OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowedSuccessCodes?;
    get allowedSuccessCodes(): number[] | undefined;
    set allowedSuccessCodes(value: number[] | undefined);
    resetAllowedSuccessCodes(): void;
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string | undefined;
    set interpreter(value: string | undefined);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _localPath?;
    get localPath(): string | undefined;
    set localPath(value: string | undefined);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcsObject?;
    private __gcsObjectOutput;
    get gcsObject(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectOutputReference;
    putGcsObject(value: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject | undefined): void;
    resetGcsObject(): void;
    get gcsObjectInput(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPreStep {
    /**
     * linux_exec_step_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#linux_exec_step_config OsConfigPatchDeployment#linux_exec_step_config}
     */
    readonly linuxExecStepConfig?: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig;
    /**
     * windows_exec_step_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#windows_exec_step_config OsConfigPatchDeployment#windows_exec_step_config}
     */
    readonly windowsExecStepConfig?: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig;
}
export declare class OsConfigPatchDeploymentPatchConfigPreStepOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _linuxExecStepConfig?;
    private __linuxExecStepConfigOutput;
    get linuxExecStepConfig(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigOutputReference;
    putLinuxExecStepConfig(value: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig | undefined): void;
    resetLinuxExecStepConfig(): void;
    get linuxExecStepConfigInput(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig | undefined;
    private _windowsExecStepConfig?;
    private __windowsExecStepConfigOutput;
    get windowsExecStepConfig(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigOutputReference;
    putWindowsExecStepConfig(value: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig | undefined): void;
    resetWindowsExecStepConfig(): void;
    get windowsExecStepConfigInput(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigWindowsUpdate {
    /**
     * Only apply updates of these windows update classifications.
     *
     * If empty, all updates are applied. Possible values: ["CRITICAL", "SECURITY", "DEFINITION", "DRIVER", "FEATURE_PACK", "SERVICE_PACK", "TOOL", "UPDATE_ROLLUP", "UPDATE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#classifications OsConfigPatchDeployment#classifications}
     */
    readonly classifications?: string[];
    /**
     * List of KBs to exclude from update.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#excludes OsConfigPatchDeployment#excludes}
     */
    readonly excludes?: string[];
    /**
     * An exclusive list of kbs to be updated.
     *
     * These are the only patches that will be updated.
     * This field must not be used with other patch configurations.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#exclusive_patches OsConfigPatchDeployment#exclusive_patches}
     */
    readonly exclusivePatches?: string[];
}
export declare class OsConfigPatchDeploymentPatchConfigWindowsUpdateOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _classifications?;
    get classifications(): string[] | undefined;
    set classifications(value: string[] | undefined);
    resetClassifications(): void;
    get classificationsInput(): string[] | undefined;
    private _excludes?;
    get excludes(): string[] | undefined;
    set excludes(value: string[] | undefined);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    private _exclusivePatches?;
    get exclusivePatches(): string[] | undefined;
    set exclusivePatches(value: string[] | undefined);
    resetExclusivePatches(): void;
    get exclusivePatchesInput(): string[] | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigYum {
    /**
     * List of packages to exclude from update. These packages will be excluded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#excludes OsConfigPatchDeployment#excludes}
     */
    readonly excludes?: string[];
    /**
     * An exclusive list of packages to be updated.
     *
     * These are the only packages that will be updated.
     * If these packages are not installed, they will be ignored. This field cannot be specified with
     * any other patch configuration fields.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#exclusive_packages OsConfigPatchDeployment#exclusive_packages}
     */
    readonly exclusivePackages?: string[];
    /**
     * Will cause patch to run yum update-minimal instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#minimal OsConfigPatchDeployment#minimal}
     */
    readonly minimal?: boolean | cdktf.IResolvable;
    /**
     * Adds the --security flag to yum update. Not supported on all platforms.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#security OsConfigPatchDeployment#security}
     */
    readonly security?: boolean | cdktf.IResolvable;
}
export declare class OsConfigPatchDeploymentPatchConfigYumOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _excludes?;
    get excludes(): string[] | undefined;
    set excludes(value: string[] | undefined);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    private _exclusivePackages?;
    get exclusivePackages(): string[] | undefined;
    set exclusivePackages(value: string[] | undefined);
    resetExclusivePackages(): void;
    get exclusivePackagesInput(): string[] | undefined;
    private _minimal?;
    get minimal(): boolean | cdktf.IResolvable | undefined;
    set minimal(value: boolean | cdktf.IResolvable | undefined);
    resetMinimal(): void;
    get minimalInput(): boolean | cdktf.IResolvable | undefined;
    private _security?;
    get security(): boolean | cdktf.IResolvable | undefined;
    set security(value: boolean | cdktf.IResolvable | undefined);
    resetSecurity(): void;
    get securityInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigZypper {
    /**
     * Install only patches with these categories. Common categories include security, recommended, and feature.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#categories OsConfigPatchDeployment#categories}
     */
    readonly categories?: string[];
    /**
     * List of packages to exclude from update.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#excludes OsConfigPatchDeployment#excludes}
     */
    readonly excludes?: string[];
    /**
     * An exclusive list of patches to be updated.
     *
     * These are the only patches that will be installed using 'zypper patch patch:' command.
     * This field must not be used with any other patch configuration fields.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#exclusive_patches OsConfigPatchDeployment#exclusive_patches}
     */
    readonly exclusivePatches?: string[];
    /**
     * Install only patches with these severities. Common severities include critical, important, moderate, and low.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#severities OsConfigPatchDeployment#severities}
     */
    readonly severities?: string[];
    /**
     * Adds the --with-optional flag to zypper patch.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#with_optional OsConfigPatchDeployment#with_optional}
     */
    readonly withOptional?: boolean | cdktf.IResolvable;
    /**
     * Adds the --with-update flag, to zypper patch.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#with_update OsConfigPatchDeployment#with_update}
     */
    readonly withUpdate?: boolean | cdktf.IResolvable;
}
export declare class OsConfigPatchDeploymentPatchConfigZypperOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _categories?;
    get categories(): string[] | undefined;
    set categories(value: string[] | undefined);
    resetCategories(): void;
    get categoriesInput(): string[] | undefined;
    private _excludes?;
    get excludes(): string[] | undefined;
    set excludes(value: string[] | undefined);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    private _exclusivePatches?;
    get exclusivePatches(): string[] | undefined;
    set exclusivePatches(value: string[] | undefined);
    resetExclusivePatches(): void;
    get exclusivePatchesInput(): string[] | undefined;
    private _severities?;
    get severities(): string[] | undefined;
    set severities(value: string[] | undefined);
    resetSeverities(): void;
    get severitiesInput(): string[] | undefined;
    private _withOptional?;
    get withOptional(): boolean | cdktf.IResolvable | undefined;
    set withOptional(value: boolean | cdktf.IResolvable | undefined);
    resetWithOptional(): void;
    get withOptionalInput(): boolean | cdktf.IResolvable | undefined;
    private _withUpdate?;
    get withUpdate(): boolean | cdktf.IResolvable | undefined;
    set withUpdate(value: boolean | cdktf.IResolvable | undefined);
    resetWithUpdate(): void;
    get withUpdateInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OsConfigPatchDeploymentPatchConfig {
    /**
     * Post-patch reboot settings. Possible values: ["DEFAULT", "ALWAYS", "NEVER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#reboot_config OsConfigPatchDeployment#reboot_config}
     */
    readonly rebootConfig?: string;
    /**
     * apt block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#apt OsConfigPatchDeployment#apt}
     */
    readonly apt?: OsConfigPatchDeploymentPatchConfigApt;
    /**
     * goo block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#goo OsConfigPatchDeployment#goo}
     */
    readonly goo?: OsConfigPatchDeploymentPatchConfigGoo;
    /**
     * post_step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#post_step OsConfigPatchDeployment#post_step}
     */
    readonly postStep?: OsConfigPatchDeploymentPatchConfigPostStep;
    /**
     * pre_step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#pre_step OsConfigPatchDeployment#pre_step}
     */
    readonly preStep?: OsConfigPatchDeploymentPatchConfigPreStep;
    /**
     * windows_update block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#windows_update OsConfigPatchDeployment#windows_update}
     */
    readonly windowsUpdate?: OsConfigPatchDeploymentPatchConfigWindowsUpdate;
    /**
     * yum block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#yum OsConfigPatchDeployment#yum}
     */
    readonly yum?: OsConfigPatchDeploymentPatchConfigYum;
    /**
     * zypper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#zypper OsConfigPatchDeployment#zypper}
     */
    readonly zypper?: OsConfigPatchDeploymentPatchConfigZypper;
}
export declare class OsConfigPatchDeploymentPatchConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _rebootConfig?;
    get rebootConfig(): string | undefined;
    set rebootConfig(value: string | undefined);
    resetRebootConfig(): void;
    get rebootConfigInput(): string | undefined;
    private _apt?;
    private __aptOutput;
    get apt(): OsConfigPatchDeploymentPatchConfigAptOutputReference;
    putApt(value: OsConfigPatchDeploymentPatchConfigApt | undefined): void;
    resetApt(): void;
    get aptInput(): OsConfigPatchDeploymentPatchConfigApt | undefined;
    private _goo?;
    private __gooOutput;
    get goo(): OsConfigPatchDeploymentPatchConfigGooOutputReference;
    putGoo(value: OsConfigPatchDeploymentPatchConfigGoo | undefined): void;
    resetGoo(): void;
    get gooInput(): OsConfigPatchDeploymentPatchConfigGoo | undefined;
    private _postStep?;
    private __postStepOutput;
    get postStep(): OsConfigPatchDeploymentPatchConfigPostStepOutputReference;
    putPostStep(value: OsConfigPatchDeploymentPatchConfigPostStep | undefined): void;
    resetPostStep(): void;
    get postStepInput(): OsConfigPatchDeploymentPatchConfigPostStep | undefined;
    private _preStep?;
    private __preStepOutput;
    get preStep(): OsConfigPatchDeploymentPatchConfigPreStepOutputReference;
    putPreStep(value: OsConfigPatchDeploymentPatchConfigPreStep | undefined): void;
    resetPreStep(): void;
    get preStepInput(): OsConfigPatchDeploymentPatchConfigPreStep | undefined;
    private _windowsUpdate?;
    private __windowsUpdateOutput;
    get windowsUpdate(): OsConfigPatchDeploymentPatchConfigWindowsUpdateOutputReference;
    putWindowsUpdate(value: OsConfigPatchDeploymentPatchConfigWindowsUpdate | undefined): void;
    resetWindowsUpdate(): void;
    get windowsUpdateInput(): OsConfigPatchDeploymentPatchConfigWindowsUpdate | undefined;
    private _yum?;
    private __yumOutput;
    get yum(): OsConfigPatchDeploymentPatchConfigYumOutputReference;
    putYum(value: OsConfigPatchDeploymentPatchConfigYum | undefined): void;
    resetYum(): void;
    get yumInput(): OsConfigPatchDeploymentPatchConfigYum | undefined;
    private _zypper?;
    private __zypperOutput;
    get zypper(): OsConfigPatchDeploymentPatchConfigZypperOutputReference;
    putZypper(value: OsConfigPatchDeploymentPatchConfigZypper | undefined): void;
    resetZypper(): void;
    get zypperInput(): OsConfigPatchDeploymentPatchConfigZypper | undefined;
}
export interface OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth {
    /**
     * A day of the week. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#day_of_week OsConfigPatchDeployment#day_of_week}
     */
    readonly dayOfWeek: string;
    /**
     * Week number in a month.
     *
     * 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#week_ordinal OsConfigPatchDeployment#week_ordinal}
     */
    readonly weekOrdinal: number;
}
export declare class OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
    private _weekOrdinal?;
    get weekOrdinal(): number;
    set weekOrdinal(value: number);
    get weekOrdinalInput(): number | undefined;
}
export interface OsConfigPatchDeploymentRecurringScheduleMonthly {
    /**
     * One day of the month.
     *
     * 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month.
     * Months without the target day will be skipped. For example, a schedule to run "every month on the 31st"
     * will not run in February, April, June, etc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#month_day OsConfigPatchDeployment#month_day}
     */
    readonly monthDay?: number;
    /**
     * week_day_of_month block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#week_day_of_month OsConfigPatchDeployment#week_day_of_month}
     */
    readonly weekDayOfMonth?: OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth;
}
export declare class OsConfigPatchDeploymentRecurringScheduleMonthlyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _monthDay?;
    get monthDay(): number | undefined;
    set monthDay(value: number | undefined);
    resetMonthDay(): void;
    get monthDayInput(): number | undefined;
    private _weekDayOfMonth?;
    private __weekDayOfMonthOutput;
    get weekDayOfMonth(): OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthOutputReference;
    putWeekDayOfMonth(value: OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth | undefined): void;
    resetWeekDayOfMonth(): void;
    get weekDayOfMonthInput(): OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth | undefined;
}
export interface OsConfigPatchDeploymentRecurringScheduleTimeOfDay {
    /**
     * Hours of day in 24 hour format.
     *
     * Should be from 0 to 23.
     * An API may choose to allow the value "24:00:00" for scenarios like business closing time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#hours OsConfigPatchDeployment#hours}
     */
    readonly hours?: number;
    /**
     * Minutes of hour of day. Must be from 0 to 59.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#minutes OsConfigPatchDeployment#minutes}
     */
    readonly minutes?: number;
    /**
     * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#nanos OsConfigPatchDeployment#nanos}
     */
    readonly nanos?: number;
    /**
     * Seconds of minutes of the time.
     *
     * Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#seconds OsConfigPatchDeployment#seconds}
     */
    readonly seconds?: number;
}
export declare class OsConfigPatchDeploymentRecurringScheduleTimeOfDayOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hours?;
    get hours(): number | undefined;
    set hours(value: number | undefined);
    resetHours(): void;
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number | undefined;
    set minutes(value: number | undefined);
    resetMinutes(): void;
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number | undefined;
    set seconds(value: number | undefined);
    resetSeconds(): void;
    get secondsInput(): number | undefined;
}
export interface OsConfigPatchDeploymentRecurringScheduleTimeZone {
    /**
     * IANA Time Zone Database time zone, e.g. "America/New_York".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#id OsConfigPatchDeployment#id}
     */
    readonly id: string;
    /**
     * IANA Time Zone Database version number, e.g. "2019a".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#version OsConfigPatchDeployment#version}
     */
    readonly version?: string;
}
export declare class OsConfigPatchDeploymentRecurringScheduleTimeZoneOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _version?;
    get version(): string | undefined;
    set version(value: string | undefined);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface OsConfigPatchDeploymentRecurringScheduleWeekly {
    /**
     * IANA Time Zone Database time zone, e.g. "America/New_York". Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#day_of_week OsConfigPatchDeployment#day_of_week}
     */
    readonly dayOfWeek: string;
}
export declare class OsConfigPatchDeploymentRecurringScheduleWeeklyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
}
export interface OsConfigPatchDeploymentRecurringSchedule {
    /**
     * The end time at which a recurring patch deployment schedule is no longer active.
     *
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#end_time OsConfigPatchDeployment#end_time}
     */
    readonly endTime?: string;
    /**
     * The time that the recurring schedule becomes effective.
     *
     * Defaults to createTime of the patch deployment.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#start_time OsConfigPatchDeployment#start_time}
     */
    readonly startTime?: string;
    /**
     * monthly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#monthly OsConfigPatchDeployment#monthly}
     */
    readonly monthly?: OsConfigPatchDeploymentRecurringScheduleMonthly;
    /**
     * time_of_day block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#time_of_day OsConfigPatchDeployment#time_of_day}
     */
    readonly timeOfDay: OsConfigPatchDeploymentRecurringScheduleTimeOfDay;
    /**
     * time_zone block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#time_zone OsConfigPatchDeployment#time_zone}
     */
    readonly timeZone: OsConfigPatchDeploymentRecurringScheduleTimeZone;
    /**
     * weekly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#weekly OsConfigPatchDeployment#weekly}
     */
    readonly weekly?: OsConfigPatchDeploymentRecurringScheduleWeekly;
}
export declare class OsConfigPatchDeploymentRecurringScheduleOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _endTime?;
    get endTime(): string | undefined;
    set endTime(value: string | undefined);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string | undefined;
    set startTime(value: string | undefined);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _monthly?;
    private __monthlyOutput;
    get monthly(): OsConfigPatchDeploymentRecurringScheduleMonthlyOutputReference;
    putMonthly(value: OsConfigPatchDeploymentRecurringScheduleMonthly | undefined): void;
    resetMonthly(): void;
    get monthlyInput(): OsConfigPatchDeploymentRecurringScheduleMonthly | undefined;
    private _timeOfDay?;
    private __timeOfDayOutput;
    get timeOfDay(): OsConfigPatchDeploymentRecurringScheduleTimeOfDayOutputReference;
    putTimeOfDay(value: OsConfigPatchDeploymentRecurringScheduleTimeOfDay): void;
    get timeOfDayInput(): OsConfigPatchDeploymentRecurringScheduleTimeOfDay | undefined;
    private _timeZone?;
    private __timeZoneOutput;
    get timeZone(): OsConfigPatchDeploymentRecurringScheduleTimeZoneOutputReference;
    putTimeZone(value: OsConfigPatchDeploymentRecurringScheduleTimeZone): void;
    get timeZoneInput(): OsConfigPatchDeploymentRecurringScheduleTimeZone | undefined;
    private _weekly?;
    private __weeklyOutput;
    get weekly(): OsConfigPatchDeploymentRecurringScheduleWeeklyOutputReference;
    putWeekly(value: OsConfigPatchDeploymentRecurringScheduleWeekly | undefined): void;
    resetWeekly(): void;
    get weeklyInput(): OsConfigPatchDeploymentRecurringScheduleWeekly | undefined;
}
export interface OsConfigPatchDeploymentRolloutDisruptionBudget {
    /**
     * Specifies a fixed value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#fixed OsConfigPatchDeployment#fixed}
     */
    readonly fixed?: number;
    /**
     * Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#percentage OsConfigPatchDeployment#percentage}
     */
    readonly percentage?: number;
}
export declare class OsConfigPatchDeploymentRolloutDisruptionBudgetOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _fixed?;
    get fixed(): number | undefined;
    set fixed(value: number | undefined);
    resetFixed(): void;
    get fixedInput(): number | undefined;
    private _percentage?;
    get percentage(): number | undefined;
    set percentage(value: number | undefined);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface OsConfigPatchDeploymentRollout {
    /**
     * Mode of the patch rollout. Possible values: ["ZONE_BY_ZONE", "CONCURRENT_ZONES"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#mode OsConfigPatchDeployment#mode}
     */
    readonly mode: string;
    /**
     * disruption_budget block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#disruption_budget OsConfigPatchDeployment#disruption_budget}
     */
    readonly disruptionBudget: OsConfigPatchDeploymentRolloutDisruptionBudget;
}
export declare class OsConfigPatchDeploymentRolloutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _disruptionBudget?;
    private __disruptionBudgetOutput;
    get disruptionBudget(): OsConfigPatchDeploymentRolloutDisruptionBudgetOutputReference;
    putDisruptionBudget(value: OsConfigPatchDeploymentRolloutDisruptionBudget): void;
    get disruptionBudgetInput(): OsConfigPatchDeploymentRolloutDisruptionBudget | undefined;
}
export interface OsConfigPatchDeploymentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#create OsConfigPatchDeployment#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#delete OsConfigPatchDeployment#delete}.
     */
    readonly delete?: string;
}
export declare class OsConfigPatchDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html google_os_config_patch_deployment}.
 */
export declare class OsConfigPatchDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html google_os_config_patch_deployment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: OsConfigPatchDeploymentConfig);
    get createTime(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _duration?;
    get duration(): string | undefined;
    set duration(value: string | undefined);
    resetDuration(): void;
    get durationInput(): string | undefined;
    get id(): string;
    get lastExecuteTime(): string;
    get name(): string;
    private _patchDeploymentId?;
    get patchDeploymentId(): string;
    set patchDeploymentId(value: string);
    get patchDeploymentIdInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _instanceFilter?;
    private __instanceFilterOutput;
    get instanceFilter(): OsConfigPatchDeploymentInstanceFilterOutputReference;
    putInstanceFilter(value: OsConfigPatchDeploymentInstanceFilter): void;
    get instanceFilterInput(): OsConfigPatchDeploymentInstanceFilter | undefined;
    private _oneTimeSchedule?;
    private __oneTimeScheduleOutput;
    get oneTimeSchedule(): OsConfigPatchDeploymentOneTimeScheduleOutputReference;
    putOneTimeSchedule(value: OsConfigPatchDeploymentOneTimeSchedule | undefined): void;
    resetOneTimeSchedule(): void;
    get oneTimeScheduleInput(): OsConfigPatchDeploymentOneTimeSchedule | undefined;
    private _patchConfig?;
    private __patchConfigOutput;
    get patchConfig(): OsConfigPatchDeploymentPatchConfigOutputReference;
    putPatchConfig(value: OsConfigPatchDeploymentPatchConfig | undefined): void;
    resetPatchConfig(): void;
    get patchConfigInput(): OsConfigPatchDeploymentPatchConfig | undefined;
    private _recurringSchedule?;
    private __recurringScheduleOutput;
    get recurringSchedule(): OsConfigPatchDeploymentRecurringScheduleOutputReference;
    putRecurringSchedule(value: OsConfigPatchDeploymentRecurringSchedule | undefined): void;
    resetRecurringSchedule(): void;
    get recurringScheduleInput(): OsConfigPatchDeploymentRecurringSchedule | undefined;
    private _rollout?;
    private __rolloutOutput;
    get rollout(): OsConfigPatchDeploymentRolloutOutputReference;
    putRollout(value: OsConfigPatchDeploymentRollout | undefined): void;
    resetRollout(): void;
    get rolloutInput(): OsConfigPatchDeploymentRollout | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): OsConfigPatchDeploymentTimeoutsOutputReference;
    putTimeouts(value: OsConfigPatchDeploymentTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): OsConfigPatchDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
