import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#constraint OrganizationPolicy#constraint}
     */
    readonly constraint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#org_id OrganizationPolicy#org_id}.
     */
    readonly orgId: string;
    /**
     * Version of the Policy. Default version is 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#version OrganizationPolicy#version}
     */
    readonly version?: number;
    /**
     * boolean_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#boolean_policy OrganizationPolicy#boolean_policy}
     */
    readonly booleanPolicy?: OrganizationPolicyBooleanPolicy;
    /**
     * list_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#list_policy OrganizationPolicy#list_policy}
     */
    readonly listPolicy?: OrganizationPolicyListPolicy;
    /**
     * restore_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#restore_policy OrganizationPolicy#restore_policy}
     */
    readonly restorePolicy?: OrganizationPolicyRestorePolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#timeouts OrganizationPolicy#timeouts}
     */
    readonly timeouts?: OrganizationPolicyTimeouts;
}
export interface OrganizationPolicyBooleanPolicy {
    /**
     * If true, then the Policy is enforced. If false, then any configuration is acceptable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#enforced OrganizationPolicy#enforced}
     */
    readonly enforced: boolean | cdktf.IResolvable;
}
export declare class OrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enforced?;
    get enforced(): boolean | cdktf.IResolvable;
    set enforced(value: boolean | cdktf.IResolvable);
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OrganizationPolicyListPolicyAllow {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#all OrganizationPolicy#all}
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#values OrganizationPolicy#values}
     */
    readonly values?: string[];
}
export declare class OrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _all?;
    get all(): boolean | cdktf.IResolvable | undefined;
    set all(value: boolean | cdktf.IResolvable | undefined);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[] | undefined;
    set values(value: string[] | undefined);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface OrganizationPolicyListPolicyDeny {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#all OrganizationPolicy#all}
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#values OrganizationPolicy#values}
     */
    readonly values?: string[];
}
export declare class OrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _all?;
    get all(): boolean | cdktf.IResolvable | undefined;
    set all(value: boolean | cdktf.IResolvable | undefined);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[] | undefined;
    set values(value: string[] | undefined);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface OrganizationPolicyListPolicy {
    /**
     * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#inherit_from_parent OrganizationPolicy#inherit_from_parent}
     */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
     * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#suggested_value OrganizationPolicy#suggested_value}
     */
    readonly suggestedValue?: string;
    /**
     * allow block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#allow OrganizationPolicy#allow}
     */
    readonly allow?: OrganizationPolicyListPolicyAllow;
    /**
     * deny block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#deny OrganizationPolicy#deny}
     */
    readonly deny?: OrganizationPolicyListPolicyDeny;
}
export declare class OrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _inheritFromParent?;
    get inheritFromParent(): boolean | cdktf.IResolvable | undefined;
    set inheritFromParent(value: boolean | cdktf.IResolvable | undefined);
    resetInheritFromParent(): void;
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _suggestedValue?;
    get suggestedValue(): string | undefined;
    set suggestedValue(value: string | undefined);
    resetSuggestedValue(): void;
    get suggestedValueInput(): string | undefined;
    private _allow?;
    private __allowOutput;
    get allow(): OrganizationPolicyListPolicyAllowOutputReference;
    putAllow(value: OrganizationPolicyListPolicyAllow | undefined): void;
    resetAllow(): void;
    get allowInput(): OrganizationPolicyListPolicyAllow | undefined;
    private _deny?;
    private __denyOutput;
    get deny(): OrganizationPolicyListPolicyDenyOutputReference;
    putDeny(value: OrganizationPolicyListPolicyDeny | undefined): void;
    resetDeny(): void;
    get denyInput(): OrganizationPolicyListPolicyDeny | undefined;
}
export interface OrganizationPolicyRestorePolicy {
    /**
     * May only be set to true. If set, then the default Policy is restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#default OrganizationPolicy#default}
     */
    readonly default: boolean | cdktf.IResolvable;
}
export declare class OrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _default?;
    get default(): boolean | cdktf.IResolvable;
    set default(value: boolean | cdktf.IResolvable);
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OrganizationPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#create OrganizationPolicy#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#delete OrganizationPolicy#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#read OrganizationPolicy#read}.
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#update OrganizationPolicy#update}.
     */
    readonly update?: string;
}
export declare class OrganizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string | undefined;
    set read(value: string | undefined);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html google_organization_policy}.
 */
export declare class OrganizationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html google_organization_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: OrganizationPolicyConfig);
    private _constraint?;
    get constraint(): string;
    set constraint(value: string);
    get constraintInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    get updateTime(): string;
    private _version?;
    get version(): number | undefined;
    set version(value: number | undefined);
    resetVersion(): void;
    get versionInput(): number | undefined;
    private _booleanPolicy?;
    private __booleanPolicyOutput;
    get booleanPolicy(): OrganizationPolicyBooleanPolicyOutputReference;
    putBooleanPolicy(value: OrganizationPolicyBooleanPolicy | undefined): void;
    resetBooleanPolicy(): void;
    get booleanPolicyInput(): OrganizationPolicyBooleanPolicy | undefined;
    private _listPolicy?;
    private __listPolicyOutput;
    get listPolicy(): OrganizationPolicyListPolicyOutputReference;
    putListPolicy(value: OrganizationPolicyListPolicy | undefined): void;
    resetListPolicy(): void;
    get listPolicyInput(): OrganizationPolicyListPolicy | undefined;
    private _restorePolicy?;
    private __restorePolicyOutput;
    get restorePolicy(): OrganizationPolicyRestorePolicyOutputReference;
    putRestorePolicy(value: OrganizationPolicyRestorePolicy | undefined): void;
    resetRestorePolicy(): void;
    get restorePolicyInput(): OrganizationPolicyRestorePolicy | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): OrganizationPolicyTimeoutsOutputReference;
    putTimeouts(value: OrganizationPolicyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): OrganizationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
