import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrganizationIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The numeric ID of the organization in which you want to manage the audit logging config.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_policy.html#org_id OrganizationIamPolicy#org_id}
     */
    readonly orgId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_policy.html#policy_data OrganizationIamPolicy#policy_data}.
     */
    readonly policyData: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_iam_policy.html google_organization_iam_policy}.
 */
export declare class OrganizationIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_iam_policy.html google_organization_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: OrganizationIamPolicyConfig);
    get etag(): string;
    get id(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
