import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrganizationIamCustomRoleConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description for the role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html#description OrganizationIamCustomRole#description}
     */
    readonly description?: string;
    /**
     * The numeric ID of the organization in which you want to create a custom role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html#org_id OrganizationIamCustomRole#org_id}
     */
    readonly orgId: string;
    /**
     * The names of the permissions this role grants when bound in an IAM policy.
     *
     * At least one permission must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html#permissions OrganizationIamCustomRole#permissions}
     */
    readonly permissions: string[];
    /**
     * The role id to use for this role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html#role_id OrganizationIamCustomRole#role_id}
     */
    readonly roleId: string;
    /**
     * The current launch stage of the role. Defaults to GA.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html#stage OrganizationIamCustomRole#stage}
     */
    readonly stage?: string;
    /**
     * A human-readable title for the role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html#title OrganizationIamCustomRole#title}
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html google_organization_iam_custom_role}.
 */
export declare class OrganizationIamCustomRole extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html google_organization_iam_custom_role} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: OrganizationIamCustomRoleConfig);
    get deleted(): any;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _permissions?;
    get permissions(): string[];
    set permissions(value: string[]);
    get permissionsInput(): string[] | undefined;
    private _roleId?;
    get roleId(): string;
    set roleId(value: string);
    get roleIdInput(): string | undefined;
    private _stage?;
    get stage(): string | undefined;
    set stage(value: string | undefined);
    resetStage(): void;
    get stageInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
