import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrganizationAccessApprovalSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of email addresses to which notifications relating to approval requests should be sent.
     *
     * Notifications relating to a resource will be sent to all emails in the settings of ancestor
     * resources of that resource. A maximum of 50 email addresses are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings.html#notification_emails OrganizationAccessApprovalSettings#notification_emails}
     */
    readonly notificationEmails?: string[];
    /**
     * ID of the organization of the access approval settings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings.html#organization_id OrganizationAccessApprovalSettings#organization_id}
     */
    readonly organizationId: string;
    /**
     * enrolled_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings.html#enrolled_services OrganizationAccessApprovalSettings#enrolled_services}
     */
    readonly enrolledServices: OrganizationAccessApprovalSettingsEnrolledServices[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings.html#timeouts OrganizationAccessApprovalSettings#timeouts}
     */
    readonly timeouts?: OrganizationAccessApprovalSettingsTimeouts;
}
export interface OrganizationAccessApprovalSettingsEnrolledServices {
    /**
     * The product for which Access Approval will be enrolled. Allowed values are listed (case-sensitive): all appengine.googleapis.com bigquery.googleapis.com bigtable.googleapis.com cloudkms.googleapis.com compute.googleapis.com dataflow.googleapis.com iam.googleapis.com pubsub.googleapis.com storage.googleapis.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings.html#cloud_product OrganizationAccessApprovalSettings#cloud_product}
     */
    readonly cloudProduct: string;
    /**
     * The enrollment level of the service. Default value: "BLOCK_ALL" Possible values: ["BLOCK_ALL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings.html#enrollment_level OrganizationAccessApprovalSettings#enrollment_level}
     */
    readonly enrollmentLevel?: string;
}
export interface OrganizationAccessApprovalSettingsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings.html#create OrganizationAccessApprovalSettings#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings.html#delete OrganizationAccessApprovalSettings#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings.html#update OrganizationAccessApprovalSettings#update}.
     */
    readonly update?: string;
}
export declare class OrganizationAccessApprovalSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings.html google_organization_access_approval_settings}.
 */
export declare class OrganizationAccessApprovalSettings extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings.html google_organization_access_approval_settings} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: OrganizationAccessApprovalSettingsConfig);
    get enrolledAncestor(): any;
    get id(): string;
    get name(): string;
    private _notificationEmails?;
    get notificationEmails(): string[] | undefined;
    set notificationEmails(value: string[] | undefined);
    resetNotificationEmails(): void;
    get notificationEmailsInput(): string[] | undefined;
    private _organizationId?;
    get organizationId(): string;
    set organizationId(value: string);
    get organizationIdInput(): string | undefined;
    private _enrolledServices?;
    get enrolledServices(): OrganizationAccessApprovalSettingsEnrolledServices[];
    set enrolledServices(value: OrganizationAccessApprovalSettingsEnrolledServices[]);
    get enrolledServicesInput(): OrganizationAccessApprovalSettingsEnrolledServices[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): OrganizationAccessApprovalSettingsTimeoutsOutputReference;
    putTimeouts(value: OrganizationAccessApprovalSettingsTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): OrganizationAccessApprovalSettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
