import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrgPolicyPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Immutable.
     *
     * The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number}/policies/{constraint_name}` * `folders/{folder_id}/policies/{constraint_name}` * `organizations/{organization_id}/policies/{constraint_name}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id}/policies/{constraint_name}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#name OrgPolicyPolicy#name}
     */
    readonly name: string;
    /**
     * The parent of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#parent OrgPolicyPolicy#parent}
     */
    readonly parent: string;
    /**
     * spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#spec OrgPolicyPolicy#spec}
     */
    readonly spec?: OrgPolicyPolicySpec;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#timeouts OrgPolicyPolicy#timeouts}
     */
    readonly timeouts?: OrgPolicyPolicyTimeouts;
}
export interface OrgPolicyPolicySpecRulesCondition {
    /**
     * Optional.
     *
     * Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#description OrgPolicyPolicy#description}
     */
    readonly description?: string;
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#expression OrgPolicyPolicy#expression}
     */
    readonly expression?: string;
    /**
     * Optional.
     *
     * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#location OrgPolicyPolicy#location}
     */
    readonly location?: string;
    /**
     * Optional.
     *
     * Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#title OrgPolicyPolicy#title}
     */
    readonly title?: string;
}
export declare class OrgPolicyPolicySpecRulesConditionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string | undefined;
    set expression(value: string | undefined);
    resetExpression(): void;
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string | undefined;
    set title(value: string | undefined);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface OrgPolicyPolicySpecRulesValues {
    /**
     * List of values allowed at this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#allowed_values OrgPolicyPolicy#allowed_values}
     */
    readonly allowedValues?: string[];
    /**
     * List of values denied at this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#denied_values OrgPolicyPolicy#denied_values}
     */
    readonly deniedValues?: string[];
}
export declare class OrgPolicyPolicySpecRulesValuesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowedValues?;
    get allowedValues(): string[] | undefined;
    set allowedValues(value: string[] | undefined);
    resetAllowedValues(): void;
    get allowedValuesInput(): string[] | undefined;
    private _deniedValues?;
    get deniedValues(): string[] | undefined;
    set deniedValues(value: string[] | undefined);
    resetDeniedValues(): void;
    get deniedValuesInput(): string[] | undefined;
}
export interface OrgPolicyPolicySpecRules {
    /**
     * Setting this to true means that all values are allowed.
     *
     * This field can be set only in Policies for list constraints.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#allow_all OrgPolicyPolicy#allow_all}
     */
    readonly allowAll?: string;
    /**
     * Setting this to true means that all values are denied.
     *
     * This field can be set only in Policies for list constraints.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#deny_all OrgPolicyPolicy#deny_all}
     */
    readonly denyAll?: string;
    /**
     * If `true`, then the `Policy` is enforced.
     *
     * If `false`, then any configuration is acceptable. This field can be set only in Policies for boolean constraints.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#enforce OrgPolicyPolicy#enforce}
     */
    readonly enforce?: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#condition OrgPolicyPolicy#condition}
     */
    readonly condition?: OrgPolicyPolicySpecRulesCondition;
    /**
     * values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#values OrgPolicyPolicy#values}
     */
    readonly values?: OrgPolicyPolicySpecRulesValues;
}
export interface OrgPolicyPolicySpec {
    /**
     * Determines the inheritance behavior for this `Policy`.
     *
     * If `inherit_from_parent` is true, PolicyRules set higher up in the hierarchy (up to the closest root) are inherited and present in the effective policy. If it is false, then no rules are inherited, and this Policy becomes the new root for evaluation. This field can be set only for Policies which configure list constraints.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#inherit_from_parent OrgPolicyPolicy#inherit_from_parent}
     */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
     * Ignores policies set above this resource and restores the `constraint_default` enforcement behavior of the specific `Constraint` at this resource.
     *
     * This field can be set in policies for either list or boolean constraints. If set, `rules` must be empty and `inherit_from_parent` must be set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#reset OrgPolicyPolicy#reset}
     */
    readonly reset?: boolean | cdktf.IResolvable;
    /**
     * rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#rules OrgPolicyPolicy#rules}
     */
    readonly rules?: OrgPolicyPolicySpecRules[];
}
export declare class OrgPolicyPolicySpecOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _inheritFromParent?;
    get inheritFromParent(): boolean | cdktf.IResolvable | undefined;
    set inheritFromParent(value: boolean | cdktf.IResolvable | undefined);
    resetInheritFromParent(): void;
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _reset?;
    get reset(): boolean | cdktf.IResolvable | undefined;
    set reset(value: boolean | cdktf.IResolvable | undefined);
    resetReset(): void;
    get resetInput(): boolean | cdktf.IResolvable | undefined;
    private _rules?;
    get rules(): OrgPolicyPolicySpecRules[] | undefined;
    set rules(value: OrgPolicyPolicySpecRules[] | undefined);
    resetRules(): void;
    get rulesInput(): OrgPolicyPolicySpecRules[] | undefined;
}
export interface OrgPolicyPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#create OrgPolicyPolicy#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#delete OrgPolicyPolicy#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#update OrgPolicyPolicy#update}.
     */
    readonly update?: string;
}
export declare class OrgPolicyPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html google_org_policy_policy}.
 */
export declare class OrgPolicyPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html google_org_policy_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: OrgPolicyPolicyConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _spec?;
    private __specOutput;
    get spec(): OrgPolicyPolicySpecOutputReference;
    putSpec(value: OrgPolicyPolicySpec | undefined): void;
    resetSpec(): void;
    get specInput(): OrgPolicyPolicySpec | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): OrgPolicyPolicyTimeoutsOutputReference;
    putTimeouts(value: OrgPolicyPolicyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): OrgPolicyPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
