import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NotebooksInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The size of the boot disk in GB attached to this instance, up to a maximum of 64000 GB (64 TB).
     *
     * The minimum recommended value is 100 GB.
     * If not specified, this defaults to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#boot_disk_size_gb NotebooksInstance#boot_disk_size_gb}
     */
    readonly bootDiskSizeGb?: number;
    /**
     * Possible disk types for notebook instances. Possible values: ["DISK_TYPE_UNSPECIFIED", "PD_STANDARD", "PD_SSD", "PD_BALANCED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#boot_disk_type NotebooksInstance#boot_disk_type}
     */
    readonly bootDiskType?: string;
    /**
     * Instance creation time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#create_time NotebooksInstance#create_time}
     */
    readonly createTime?: string;
    /**
     * Specify a custom Cloud Storage path where the GPU driver is stored.
     *
     * If not specified, we'll automatically choose from official GPU drivers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#custom_gpu_driver_path NotebooksInstance#custom_gpu_driver_path}
     */
    readonly customGpuDriverPath?: string;
    /**
     * The size of the data disk in GB attached to this instance, up to a maximum of 64000 GB (64 TB).
     *
     * You can choose the size of the data disk based on how big your notebooks and data are.
     * If not specified, this defaults to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#data_disk_size_gb NotebooksInstance#data_disk_size_gb}
     */
    readonly dataDiskSizeGb?: number;
    /**
     * Possible disk types for notebook instances. Possible values: ["DISK_TYPE_UNSPECIFIED", "PD_STANDARD", "PD_SSD", "PD_BALANCED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#data_disk_type NotebooksInstance#data_disk_type}
     */
    readonly dataDiskType?: string;
    /**
     * Disk encryption method used on the boot and data disks, defaults to GMEK. Possible values: ["DISK_ENCRYPTION_UNSPECIFIED", "GMEK", "CMEK"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#disk_encryption NotebooksInstance#disk_encryption}
     */
    readonly diskEncryption?: string;
    /**
     * Whether the end user authorizes Google Cloud to install GPU driver on this instance.
     *
     * If this field is empty or set to false, the GPU driver
     * won't be installed. Only applicable to instances with GPUs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#install_gpu_driver NotebooksInstance#install_gpu_driver}
     */
    readonly installGpuDriver?: boolean | cdktf.IResolvable;
    /**
     * The list of owners of this instance after creation.
     *
     * Format: alias@example.com.
     * Currently supports one owner only.
     * If not specified, all of the service account users of
     * your VM instance's service account can use the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#instance_owners NotebooksInstance#instance_owners}
     */
    readonly instanceOwners?: string[];
    /**
     * The KMS key used to encrypt the disks, only applicable if diskEncryption is CMEK. Format: projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#kms_key NotebooksInstance#kms_key}
     */
    readonly kmsKey?: string;
    /**
     * Labels to apply to this instance.
     *
     * These can be later modified by the setLabels method.
     * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#labels NotebooksInstance#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * A reference to the zone where the machine resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#location NotebooksInstance#location}
     */
    readonly location: string;
    /**
     * A reference to a machine type which defines VM kind.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#machine_type NotebooksInstance#machine_type}
     */
    readonly machineType: string;
    /**
     * Custom metadata to apply to this instance.
     *
     * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#metadata NotebooksInstance#metadata}
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The name specified for the Notebook instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#name NotebooksInstance#name}
     */
    readonly name: string;
    /**
     * The name of the VPC that this instance is in. Format: projects/{project_id}/global/networks/{network_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#network NotebooksInstance#network}
     */
    readonly network?: string;
    /**
     * The notebook instance will not register with the proxy..
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#no_proxy_access NotebooksInstance#no_proxy_access}
     */
    readonly noProxyAccess?: boolean | cdktf.IResolvable;
    /**
     * No public IP will be assigned to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#no_public_ip NotebooksInstance#no_public_ip}
     */
    readonly noPublicIp?: boolean | cdktf.IResolvable;
    /**
     * If true, the data disk will not be auto deleted when deleting the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#no_remove_data_disk NotebooksInstance#no_remove_data_disk}
     */
    readonly noRemoveDataDisk?: boolean | cdktf.IResolvable;
    /**
     * Path to a Bash script that automatically runs after a notebook instance fully boots up.
     *
     * The path must be a URL
     * or Cloud Storage path (gs://path-to-file/file-name).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#post_startup_script NotebooksInstance#post_startup_script}
     */
    readonly postStartupScript?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#project NotebooksInstance#project}.
     */
    readonly project?: string;
    /**
     * The service account on this instance, giving access to other Google Cloud services.
     *
     * You can use any service account within
     * the same project, but you must have the service account user
     * permission to use the instance. If not specified,
     * the Compute Engine default service account is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#service_account NotebooksInstance#service_account}
     */
    readonly serviceAccount?: string;
    /**
     * Optional.
     *
     * The URIs of service account scopes to be included in Compute Engine instances.
     * If not specified, the following scopes are defined:
     * - https://www.googleapis.com/auth/cloud-platform
     * - https://www.googleapis.com/auth/userinfo.email
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#service_account_scopes NotebooksInstance#service_account_scopes}
     */
    readonly serviceAccountScopes?: string[];
    /**
     * The name of the subnet that this instance is in. Format: projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#subnet NotebooksInstance#subnet}
     */
    readonly subnet?: string;
    /**
     * The Compute Engine tags to add to runtime.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#tags NotebooksInstance#tags}
     */
    readonly tags?: string[];
    /**
     * Instance update time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#update_time NotebooksInstance#update_time}
     */
    readonly updateTime?: string;
    /**
     * accelerator_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#accelerator_config NotebooksInstance#accelerator_config}
     */
    readonly acceleratorConfig?: NotebooksInstanceAcceleratorConfig;
    /**
     * container_image block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#container_image NotebooksInstance#container_image}
     */
    readonly containerImage?: NotebooksInstanceContainerImage;
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#shielded_instance_config NotebooksInstance#shielded_instance_config}
     */
    readonly shieldedInstanceConfig?: NotebooksInstanceShieldedInstanceConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#timeouts NotebooksInstance#timeouts}
     */
    readonly timeouts?: NotebooksInstanceTimeouts;
    /**
     * vm_image block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#vm_image NotebooksInstance#vm_image}
     */
    readonly vmImage?: NotebooksInstanceVmImage;
}
export interface NotebooksInstanceAcceleratorConfig {
    /**
     * Count of cores of this accelerator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#core_count NotebooksInstance#core_count}
     */
    readonly coreCount: number;
    /**
     * Type of this accelerator. Possible values: ["ACCELERATOR_TYPE_UNSPECIFIED", "NVIDIA_TESLA_K80", "NVIDIA_TESLA_P100", "NVIDIA_TESLA_V100", "NVIDIA_TESLA_P4", "NVIDIA_TESLA_T4", "NVIDIA_TESLA_T4_VWS", "NVIDIA_TESLA_P100_VWS", "NVIDIA_TESLA_P4_VWS", "NVIDIA_TESLA_A100", "TPU_V2", "TPU_V3"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#type NotebooksInstance#type}
     */
    readonly type: string;
}
export declare class NotebooksInstanceAcceleratorConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _coreCount?;
    get coreCount(): number;
    set coreCount(value: number);
    get coreCountInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface NotebooksInstanceContainerImage {
    /**
     * The path to the container image repository. For example: gcr.io/{project_id}/{imageName}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#repository NotebooksInstance#repository}
     */
    readonly repository: string;
    /**
     * The tag of the container image. If not specified, this defaults to the latest tag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#tag NotebooksInstance#tag}
     */
    readonly tag?: string;
}
export declare class NotebooksInstanceContainerImageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _tag?;
    get tag(): string | undefined;
    set tag(value: string | undefined);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export interface NotebooksInstanceShieldedInstanceConfig {
    /**
     * Defines whether the instance has integrity monitoring enabled.
     *
     * Enables monitoring and attestation of the
     * boot integrity of the instance. The attestation is performed against the integrity policy baseline.
     * This baseline is initially derived from the implicitly trusted boot image when the instance is created.
     * Enabled by default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#enable_integrity_monitoring NotebooksInstance#enable_integrity_monitoring}
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Defines whether the instance has Secure Boot enabled.
     *
     * Secure Boot helps ensure that the system only runs
     * authentic software by verifying the digital signature of all boot components, and halting the boot process
     * if signature verification fails.
     * Disabled by default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#enable_secure_boot NotebooksInstance#enable_secure_boot}
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
     * Defines whether the instance has the vTPM enabled. Enabled by default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#enable_vtpm NotebooksInstance#enable_vtpm}
     */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare class NotebooksInstanceShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable | undefined;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable | undefined);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable | undefined;
    set enableSecureBoot(value: boolean | cdktf.IResolvable | undefined);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable | undefined;
    set enableVtpm(value: boolean | cdktf.IResolvable | undefined);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface NotebooksInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#create NotebooksInstance#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#delete NotebooksInstance#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#update NotebooksInstance#update}.
     */
    readonly update?: string;
}
export declare class NotebooksInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface NotebooksInstanceVmImage {
    /**
     * Use this VM image family to find the image; the newest image in this family will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#image_family NotebooksInstance#image_family}
     */
    readonly imageFamily?: string;
    /**
     * Use VM image name to find the image.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#image_name NotebooksInstance#image_name}
     */
    readonly imageName?: string;
    /**
     * The name of the Google Cloud project that this VM image belongs to. Format: projects/{project_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html#project NotebooksInstance#project}
     */
    readonly project: string;
}
export declare class NotebooksInstanceVmImageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _imageFamily?;
    get imageFamily(): string | undefined;
    set imageFamily(value: string | undefined);
    resetImageFamily(): void;
    get imageFamilyInput(): string | undefined;
    private _imageName?;
    get imageName(): string | undefined;
    set imageName(value: string | undefined);
    resetImageName(): void;
    get imageNameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html google_notebooks_instance}.
 */
export declare class NotebooksInstance extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance.html google_notebooks_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: NotebooksInstanceConfig);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number | undefined;
    set bootDiskSizeGb(value: number | undefined);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string | undefined;
    set bootDiskType(value: string | undefined);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _createTime?;
    get createTime(): string | undefined;
    set createTime(value: string | undefined);
    resetCreateTime(): void;
    get createTimeInput(): string | undefined;
    private _customGpuDriverPath?;
    get customGpuDriverPath(): string | undefined;
    set customGpuDriverPath(value: string | undefined);
    resetCustomGpuDriverPath(): void;
    get customGpuDriverPathInput(): string | undefined;
    private _dataDiskSizeGb?;
    get dataDiskSizeGb(): number | undefined;
    set dataDiskSizeGb(value: number | undefined);
    resetDataDiskSizeGb(): void;
    get dataDiskSizeGbInput(): number | undefined;
    private _dataDiskType?;
    get dataDiskType(): string | undefined;
    set dataDiskType(value: string | undefined);
    resetDataDiskType(): void;
    get dataDiskTypeInput(): string | undefined;
    private _diskEncryption?;
    get diskEncryption(): string | undefined;
    set diskEncryption(value: string | undefined);
    resetDiskEncryption(): void;
    get diskEncryptionInput(): string | undefined;
    get id(): string;
    private _installGpuDriver?;
    get installGpuDriver(): boolean | cdktf.IResolvable | undefined;
    set installGpuDriver(value: boolean | cdktf.IResolvable | undefined);
    resetInstallGpuDriver(): void;
    get installGpuDriverInput(): boolean | cdktf.IResolvable | undefined;
    private _instanceOwners?;
    get instanceOwners(): string[] | undefined;
    set instanceOwners(value: string[] | undefined);
    resetInstanceOwners(): void;
    get instanceOwnersInput(): string[] | undefined;
    private _kmsKey?;
    get kmsKey(): string | undefined;
    set kmsKey(value: string | undefined);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string | undefined;
    set network(value: string | undefined);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _noProxyAccess?;
    get noProxyAccess(): boolean | cdktf.IResolvable | undefined;
    set noProxyAccess(value: boolean | cdktf.IResolvable | undefined);
    resetNoProxyAccess(): void;
    get noProxyAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _noPublicIp?;
    get noPublicIp(): boolean | cdktf.IResolvable | undefined;
    set noPublicIp(value: boolean | cdktf.IResolvable | undefined);
    resetNoPublicIp(): void;
    get noPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _noRemoveDataDisk?;
    get noRemoveDataDisk(): boolean | cdktf.IResolvable | undefined;
    set noRemoveDataDisk(value: boolean | cdktf.IResolvable | undefined);
    resetNoRemoveDataDisk(): void;
    get noRemoveDataDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _postStartupScript?;
    get postStartupScript(): string | undefined;
    set postStartupScript(value: string | undefined);
    resetPostStartupScript(): void;
    get postStartupScriptInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get proxyUri(): string;
    private _serviceAccount?;
    get serviceAccount(): string | undefined;
    set serviceAccount(value: string | undefined);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _serviceAccountScopes?;
    get serviceAccountScopes(): string[] | undefined;
    set serviceAccountScopes(value: string[] | undefined);
    resetServiceAccountScopes(): void;
    get serviceAccountScopesInput(): string[] | undefined;
    get state(): string;
    private _subnet?;
    get subnet(): string | undefined;
    set subnet(value: string | undefined);
    resetSubnet(): void;
    get subnetInput(): string | undefined;
    private _tags?;
    get tags(): string[] | undefined;
    set tags(value: string[] | undefined);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _updateTime?;
    get updateTime(): string | undefined;
    set updateTime(value: string | undefined);
    resetUpdateTime(): void;
    get updateTimeInput(): string | undefined;
    private _acceleratorConfig?;
    private __acceleratorConfigOutput;
    get acceleratorConfig(): NotebooksInstanceAcceleratorConfigOutputReference;
    putAcceleratorConfig(value: NotebooksInstanceAcceleratorConfig | undefined): void;
    resetAcceleratorConfig(): void;
    get acceleratorConfigInput(): NotebooksInstanceAcceleratorConfig | undefined;
    private _containerImage?;
    private __containerImageOutput;
    get containerImage(): NotebooksInstanceContainerImageOutputReference;
    putContainerImage(value: NotebooksInstanceContainerImage | undefined): void;
    resetContainerImage(): void;
    get containerImageInput(): NotebooksInstanceContainerImage | undefined;
    private _shieldedInstanceConfig?;
    private __shieldedInstanceConfigOutput;
    get shieldedInstanceConfig(): NotebooksInstanceShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: NotebooksInstanceShieldedInstanceConfig | undefined): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): NotebooksInstanceShieldedInstanceConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): NotebooksInstanceTimeoutsOutputReference;
    putTimeouts(value: NotebooksInstanceTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): NotebooksInstanceTimeouts | undefined;
    private _vmImage?;
    private __vmImageOutput;
    get vmImage(): NotebooksInstanceVmImageOutputReference;
    putVmImage(value: NotebooksInstanceVmImage | undefined): void;
    resetVmImage(): void;
    get vmImageInput(): NotebooksInstanceVmImage | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
