import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NotebooksEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * A brief description of this environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#description NotebooksEnvironment#description}
     */
    readonly description?: string;
    /**
     * Display name of this environment for the UI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#display_name NotebooksEnvironment#display_name}
     */
    readonly displayName?: string;
    /**
     * A reference to the zone where the machine resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#location NotebooksEnvironment#location}
     */
    readonly location: string;
    /**
     * The name specified for the Environment instance. Format: projects/{project_id}/locations/{location}/environments/{environmentId}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#name NotebooksEnvironment#name}
     */
    readonly name: string;
    /**
     * Path to a Bash script that automatically runs after a notebook instance fully boots up.
     *
     * The path must be a URL or Cloud Storage path. Example: "gs://path-to-file/file-name"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#post_startup_script NotebooksEnvironment#post_startup_script}
     */
    readonly postStartupScript?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#project NotebooksEnvironment#project}.
     */
    readonly project?: string;
    /**
     * container_image block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#container_image NotebooksEnvironment#container_image}
     */
    readonly containerImage?: NotebooksEnvironmentContainerImage;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#timeouts NotebooksEnvironment#timeouts}
     */
    readonly timeouts?: NotebooksEnvironmentTimeouts;
    /**
     * vm_image block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#vm_image NotebooksEnvironment#vm_image}
     */
    readonly vmImage?: NotebooksEnvironmentVmImage;
}
export interface NotebooksEnvironmentContainerImage {
    /**
     * The path to the container image repository. For example: gcr.io/{project_id}/{imageName}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#repository NotebooksEnvironment#repository}
     */
    readonly repository: string;
    /**
     * The tag of the container image. If not specified, this defaults to the latest tag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#tag NotebooksEnvironment#tag}
     */
    readonly tag?: string;
}
export declare class NotebooksEnvironmentContainerImageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _tag?;
    get tag(): string | undefined;
    set tag(value: string | undefined);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export interface NotebooksEnvironmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#create NotebooksEnvironment#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#delete NotebooksEnvironment#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#update NotebooksEnvironment#update}.
     */
    readonly update?: string;
}
export declare class NotebooksEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface NotebooksEnvironmentVmImage {
    /**
     * Use this VM image family to find the image; the newest image in this family will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#image_family NotebooksEnvironment#image_family}
     */
    readonly imageFamily?: string;
    /**
     * Use VM image name to find the image.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#image_name NotebooksEnvironment#image_name}
     */
    readonly imageName?: string;
    /**
     * The name of the Google Cloud project that this VM image belongs to. Format: projects/{project_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#project NotebooksEnvironment#project}
     */
    readonly project: string;
}
export declare class NotebooksEnvironmentVmImageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _imageFamily?;
    get imageFamily(): string | undefined;
    set imageFamily(value: string | undefined);
    resetImageFamily(): void;
    get imageFamilyInput(): string | undefined;
    private _imageName?;
    get imageName(): string | undefined;
    set imageName(value: string | undefined);
    resetImageName(): void;
    get imageNameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html google_notebooks_environment}.
 */
export declare class NotebooksEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html google_notebooks_environment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: NotebooksEnvironmentConfig);
    get createTime(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _postStartupScript?;
    get postStartupScript(): string | undefined;
    set postStartupScript(value: string | undefined);
    resetPostStartupScript(): void;
    get postStartupScriptInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _containerImage?;
    private __containerImageOutput;
    get containerImage(): NotebooksEnvironmentContainerImageOutputReference;
    putContainerImage(value: NotebooksEnvironmentContainerImage | undefined): void;
    resetContainerImage(): void;
    get containerImageInput(): NotebooksEnvironmentContainerImage | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): NotebooksEnvironmentTimeoutsOutputReference;
    putTimeouts(value: NotebooksEnvironmentTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): NotebooksEnvironmentTimeouts | undefined;
    private _vmImage?;
    private __vmImageOutput;
    get vmImage(): NotebooksEnvironmentVmImageOutputReference;
    putVmImage(value: NotebooksEnvironmentVmImage | undefined): void;
    resetVmImage(): void;
    get vmImageInput(): NotebooksEnvironmentVmImage | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
