import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkServicesEdgeCacheOriginConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#description NetworkServicesEdgeCacheOrigin#description}
     */
    readonly description?: string;
    /**
     * The Origin resource to try when the current origin cannot be reached.
     *
     * After maxAttempts is reached, the configured failoverOrigin will be used to fulfil the request.
     *
     * The value of timeout.maxAttemptsTimeout dictates the timeout across all origins.
     * A reference to a Topic resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#failover_origin NetworkServicesEdgeCacheOrigin#failover_origin}
     */
    readonly failoverOrigin?: string;
    /**
     * Set of label tags associated with the EdgeCache resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#labels NetworkServicesEdgeCacheOrigin#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The maximum number of attempts to cache fill from this origin.
     *
     * Another attempt is made when a cache fill fails with one of the retryConditions.
     *
     * Once maxAttempts to this origin have failed the failoverOrigin will be used, if one is specified. That failoverOrigin may specify its own maxAttempts,
     * retryConditions and failoverOrigin to control its own cache fill failures.
     *
     * The total number of allowed attempts to cache fill across this and failover origins is limited to four.
     * The total time allowed for cache fill attempts across this and failover origins can be controlled with maxAttemptsTimeout.
     *
     * The last valid response from an origin will be returned to the client.
     * If no origin returns a valid response, an HTTP 503 will be returned to the client.
     *
     * Defaults to 1. Must be a value greater than 0 and less than 4.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#max_attempts NetworkServicesEdgeCacheOrigin#max_attempts}
     */
    readonly maxAttempts?: number;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is created.
     * The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
     * and all following characters must be a dash, underscore, letter or digit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#name NetworkServicesEdgeCacheOrigin#name}
     */
    readonly name: string;
    /**
     * A fully qualified domain name (FQDN) or IP address reachable over the public Internet, or the address of a Google Cloud Storage bucket.
     *
     * This address will be used as the origin for cache requests - e.g. FQDN: media-backend.example.com IPv4:35.218.1.1 IPv6:[2607:f8b0:4012:809::200e] Cloud Storage: gs://bucketname
     *
     * When providing an FQDN (hostname), it must be publicly resolvable (e.g. via Google public DNS) and IP addresses must be publicly routable.
     * If a Cloud Storage bucket is provided, it must be in the canonical "gs://bucketname" format. Other forms, such as "storage.googleapis.com", will be rejected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#origin_address NetworkServicesEdgeCacheOrigin#origin_address}
     */
    readonly originAddress: string;
    /**
     * The port to connect to the origin on.
     *
     * Defaults to port 443 for HTTP2 and HTTPS protocols, and port 80 for HTTP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#port NetworkServicesEdgeCacheOrigin#port}
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#project NetworkServicesEdgeCacheOrigin#project}.
     */
    readonly project?: string;
    /**
     * The protocol to use to connect to the configured origin.
     *
     * Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for both security & performance.
     *
     * When using HTTP2 or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must be presented by the origin server. Possible values: ["HTTP2", "HTTPS", "HTTP"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#protocol NetworkServicesEdgeCacheOrigin#protocol}
     */
    readonly protocol?: string;
    /**
     * Specifies one or more retry conditions for the configured origin.
     *
     * If the failure mode during a connection attempt to the origin matches the configured retryCondition(s),
     * the origin request will be retried up to maxAttempts times. The failoverOrigin, if configured, will then be used to satisfy the request.
     *
     * The default retryCondition is "CONNECT_FAILURE".
     *
     * retryConditions apply to this origin, and not subsequent failoverOrigin(s),
     * which may specify their own retryConditions and maxAttempts.
     *
     * Valid values are:
     *
     * - CONNECT_FAILURE: Retry on failures connecting to origins, for example due to connection timeouts.
     * - HTTP_5XX: Retry if the origin responds with any 5xx response code, or if the origin does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
     * - GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502, 503 or 504.
     * - RETRIABLE_4XX: Retry for retriable 4xx response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many Requests)
     * - NOT_FOUND: Retry if the origin returns a HTTP 404 (Not Found). This can be useful when generating video content, and the segment is not available yet. Possible values: ["CONNECT_FAILURE", "HTTP_5XX", "GATEWAY_ERROR", "RETRIABLE_4XX", "NOT_FOUND"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#retry_conditions NetworkServicesEdgeCacheOrigin#retry_conditions}
     */
    readonly retryConditions?: string[];
    /**
     * timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#timeout NetworkServicesEdgeCacheOrigin#timeout}
     */
    readonly timeout?: NetworkServicesEdgeCacheOriginTimeout;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#timeouts NetworkServicesEdgeCacheOrigin#timeouts}
     */
    readonly timeouts?: NetworkServicesEdgeCacheOriginTimeouts;
}
export interface NetworkServicesEdgeCacheOriginTimeout {
    /**
     * The maximum duration to wait for the origin connection to be established, including DNS lookup, TLS handshake and TCP/QUIC connection establishment.
     *
     * Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#connect_timeout NetworkServicesEdgeCacheOrigin#connect_timeout}
     */
    readonly connectTimeout?: string;
    /**
     * The maximum time across all connection attempts to the origin, including failover origins, before returning an error to the client.
     *
     * A HTTP 503 will be returned if the timeout is reached before a response is returned.
     *
     * Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#max_attempts_timeout NetworkServicesEdgeCacheOrigin#max_attempts_timeout}
     */
    readonly maxAttemptsTimeout?: string;
    /**
     * The maximum duration to wait for data to arrive when reading from the HTTP connection/stream.
     *
     * Defaults to 5 seconds. The timeout must be a value between 1s and 30s.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#response_timeout NetworkServicesEdgeCacheOrigin#response_timeout}
     */
    readonly responseTimeout?: string;
}
export declare class NetworkServicesEdgeCacheOriginTimeoutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _connectTimeout?;
    get connectTimeout(): string | undefined;
    set connectTimeout(value: string | undefined);
    resetConnectTimeout(): void;
    get connectTimeoutInput(): string | undefined;
    private _maxAttemptsTimeout?;
    get maxAttemptsTimeout(): string | undefined;
    set maxAttemptsTimeout(value: string | undefined);
    resetMaxAttemptsTimeout(): void;
    get maxAttemptsTimeoutInput(): string | undefined;
    private _responseTimeout?;
    get responseTimeout(): string | undefined;
    set responseTimeout(value: string | undefined);
    resetResponseTimeout(): void;
    get responseTimeoutInput(): string | undefined;
}
export interface NetworkServicesEdgeCacheOriginTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#create NetworkServicesEdgeCacheOrigin#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#delete NetworkServicesEdgeCacheOrigin#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#update NetworkServicesEdgeCacheOrigin#update}.
     */
    readonly update?: string;
}
export declare class NetworkServicesEdgeCacheOriginTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html google_network_services_edge_cache_origin}.
 */
export declare class NetworkServicesEdgeCacheOrigin extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html google_network_services_edge_cache_origin} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: NetworkServicesEdgeCacheOriginConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _failoverOrigin?;
    get failoverOrigin(): string | undefined;
    set failoverOrigin(value: string | undefined);
    resetFailoverOrigin(): void;
    get failoverOriginInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _maxAttempts?;
    get maxAttempts(): number | undefined;
    set maxAttempts(value: number | undefined);
    resetMaxAttempts(): void;
    get maxAttemptsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _originAddress?;
    get originAddress(): string;
    set originAddress(value: string);
    get originAddressInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _protocol?;
    get protocol(): string | undefined;
    set protocol(value: string | undefined);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _retryConditions?;
    get retryConditions(): string[] | undefined;
    set retryConditions(value: string[] | undefined);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _timeout?;
    private __timeoutOutput;
    get timeout(): NetworkServicesEdgeCacheOriginTimeoutOutputReference;
    putTimeout(value: NetworkServicesEdgeCacheOriginTimeout | undefined): void;
    resetTimeout(): void;
    get timeoutInput(): NetworkServicesEdgeCacheOriginTimeout | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): NetworkServicesEdgeCacheOriginTimeoutsOutputReference;
    putTimeouts(value: NetworkServicesEdgeCacheOriginTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkServicesEdgeCacheOriginTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
