import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkServicesEdgeCacheKeysetConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#description NetworkServicesEdgeCacheKeyset#description}
     */
    readonly description?: string;
    /**
     * Set of label tags associated with the EdgeCache resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#labels NetworkServicesEdgeCacheKeyset#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is created.
     * The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
     * and all following characters must be a dash, underscore, letter or digit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#name NetworkServicesEdgeCacheKeyset#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#project NetworkServicesEdgeCacheKeyset#project}.
     */
    readonly project?: string;
    /**
     * public_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#public_key NetworkServicesEdgeCacheKeyset#public_key}
     */
    readonly publicKey: NetworkServicesEdgeCacheKeysetPublicKey[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#timeouts NetworkServicesEdgeCacheKeyset#timeouts}
     */
    readonly timeouts?: NetworkServicesEdgeCacheKeysetTimeouts;
}
export interface NetworkServicesEdgeCacheKeysetPublicKey {
    /**
     * The ID of the public key.
     *
     * The ID must be 1-63 characters long, and comply with RFC1035.
     * The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]*
     * which means the first character must be a letter, and all following characters must be a dash, underscore, letter or digit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#id NetworkServicesEdgeCacheKeyset#id}
     */
    readonly id: string;
    /**
     * The base64-encoded value of the Ed25519 public key.
     *
     * The base64 encoding can be padded (44 bytes) or unpadded (43 bytes).
     * Representations or encodings of the public key other than this will be rejected with an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#value NetworkServicesEdgeCacheKeyset#value}
     */
    readonly value: string;
}
export interface NetworkServicesEdgeCacheKeysetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#create NetworkServicesEdgeCacheKeyset#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#delete NetworkServicesEdgeCacheKeyset#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#update NetworkServicesEdgeCacheKeyset#update}.
     */
    readonly update?: string;
}
export declare class NetworkServicesEdgeCacheKeysetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html google_network_services_edge_cache_keyset}.
 */
export declare class NetworkServicesEdgeCacheKeyset extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html google_network_services_edge_cache_keyset} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: NetworkServicesEdgeCacheKeysetConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _publicKey?;
    get publicKey(): NetworkServicesEdgeCacheKeysetPublicKey[];
    set publicKey(value: NetworkServicesEdgeCacheKeysetPublicKey[]);
    get publicKeyInput(): NetworkServicesEdgeCacheKeysetPublicKey[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): NetworkServicesEdgeCacheKeysetTimeoutsOutputReference;
    putTimeouts(value: NetworkServicesEdgeCacheKeysetTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkServicesEdgeCacheKeysetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
