import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkManagementConnectivityTestConfig extends cdktf.TerraformMetaArguments {
    /**
     * The user-supplied description of the Connectivity Test. Maximum of 512 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#description NetworkManagementConnectivityTest#description}
     */
    readonly description?: string;
    /**
     * Resource labels to represent user-provided metadata.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#labels NetworkManagementConnectivityTest#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Unique name for the connectivity test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#name NetworkManagementConnectivityTest#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#project NetworkManagementConnectivityTest#project}.
     */
    readonly project?: string;
    /**
     * IP Protocol of the test. When not provided, "TCP" is assumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#protocol NetworkManagementConnectivityTest#protocol}
     */
    readonly protocol?: string;
    /**
     * Other projects that may be relevant for reachability analysis. This is applicable to scenarios where a test can cross project boundaries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#related_projects NetworkManagementConnectivityTest#related_projects}
     */
    readonly relatedProjects?: string[];
    /**
     * destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#destination NetworkManagementConnectivityTest#destination}
     */
    readonly destination: NetworkManagementConnectivityTestDestination;
    /**
     * source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#source NetworkManagementConnectivityTest#source}
     */
    readonly source: NetworkManagementConnectivityTestSource;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#timeouts NetworkManagementConnectivityTest#timeouts}
     */
    readonly timeouts?: NetworkManagementConnectivityTestTimeouts;
}
export interface NetworkManagementConnectivityTestDestination {
    /**
     * A Compute Engine instance URI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#instance NetworkManagementConnectivityTest#instance}
     */
    readonly instance?: string;
    /**
     * The IP address of the endpoint, which can be an external or internal IP.
     *
     * An IPv6 address is only allowed when the test's
     * destination is a global load balancer VIP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#ip_address NetworkManagementConnectivityTest#ip_address}
     */
    readonly ipAddress?: string;
    /**
     * A Compute Engine network URI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#network NetworkManagementConnectivityTest#network}
     */
    readonly network?: string;
    /**
     * The IP protocol port of the endpoint. Only applicable when protocol is TCP or UDP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#port NetworkManagementConnectivityTest#port}
     */
    readonly port?: number;
    /**
     * Project ID where the endpoint is located.
     *
     * The Project ID can be
     * derived from the URI if you provide a VM instance or network URI.
     * The following are two cases where you must provide the project ID:
     * 1. Only the IP address is specified, and the IP address is within
     * a GCP project. 2. When you are using Shared VPC and the IP address
     * that you provide is from the service project. In this case, the
     * network that the IP address resides in is defined in the host
     * project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#project_id NetworkManagementConnectivityTest#project_id}
     */
    readonly projectId?: string;
}
export declare class NetworkManagementConnectivityTestDestinationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _instance?;
    get instance(): string | undefined;
    set instance(value: string | undefined);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string | undefined;
    set ipAddress(value: string | undefined);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _network?;
    get network(): string | undefined;
    set network(value: string | undefined);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _projectId?;
    get projectId(): string | undefined;
    set projectId(value: string | undefined);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
}
export interface NetworkManagementConnectivityTestSource {
    /**
     * A Compute Engine instance URI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#instance NetworkManagementConnectivityTest#instance}
     */
    readonly instance?: string;
    /**
     * The IP address of the endpoint, which can be an external or internal IP.
     *
     * An IPv6 address is only allowed when the test's
     * destination is a global load balancer VIP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#ip_address NetworkManagementConnectivityTest#ip_address}
     */
    readonly ipAddress?: string;
    /**
     * A Compute Engine network URI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#network NetworkManagementConnectivityTest#network}
     */
    readonly network?: string;
    /**
     * Type of the network where the endpoint is located. Possible values: ["GCP_NETWORK", "NON_GCP_NETWORK"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#network_type NetworkManagementConnectivityTest#network_type}
     */
    readonly networkType?: string;
    /**
     * The IP protocol port of the endpoint. Only applicable when protocol is TCP or UDP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#port NetworkManagementConnectivityTest#port}
     */
    readonly port?: number;
    /**
     * Project ID where the endpoint is located.
     *
     * The Project ID can be
     * derived from the URI if you provide a VM instance or network URI.
     * The following are two cases where you must provide the project ID:
     *
     * 1. Only the IP address is specified, and the IP address is
     * within a GCP project.
     * 2. When you are using Shared VPC and the IP address
     * that you provide is from the service project. In this case,
     * the network that the IP address resides in is defined in the
     * host project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#project_id NetworkManagementConnectivityTest#project_id}
     */
    readonly projectId?: string;
}
export declare class NetworkManagementConnectivityTestSourceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _instance?;
    get instance(): string | undefined;
    set instance(value: string | undefined);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string | undefined;
    set ipAddress(value: string | undefined);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _network?;
    get network(): string | undefined;
    set network(value: string | undefined);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkType?;
    get networkType(): string | undefined;
    set networkType(value: string | undefined);
    resetNetworkType(): void;
    get networkTypeInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _projectId?;
    get projectId(): string | undefined;
    set projectId(value: string | undefined);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
}
export interface NetworkManagementConnectivityTestTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#create NetworkManagementConnectivityTest#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#delete NetworkManagementConnectivityTest#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#update NetworkManagementConnectivityTest#update}.
     */
    readonly update?: string;
}
export declare class NetworkManagementConnectivityTestTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html google_network_management_connectivity_test}.
 */
export declare class NetworkManagementConnectivityTest extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html google_network_management_connectivity_test} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: NetworkManagementConnectivityTestConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _protocol?;
    get protocol(): string | undefined;
    set protocol(value: string | undefined);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _relatedProjects?;
    get relatedProjects(): string[] | undefined;
    set relatedProjects(value: string[] | undefined);
    resetRelatedProjects(): void;
    get relatedProjectsInput(): string[] | undefined;
    private _destination?;
    private __destinationOutput;
    get destination(): NetworkManagementConnectivityTestDestinationOutputReference;
    putDestination(value: NetworkManagementConnectivityTestDestination): void;
    get destinationInput(): NetworkManagementConnectivityTestDestination | undefined;
    private _source?;
    private __sourceOutput;
    get source(): NetworkManagementConnectivityTestSourceOutputReference;
    putSource(value: NetworkManagementConnectivityTestSource): void;
    get sourceInput(): NetworkManagementConnectivityTestSource | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): NetworkManagementConnectivityTestTimeoutsOutputReference;
    putTimeouts(value: NetworkManagementConnectivityTestTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkManagementConnectivityTestTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
