import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitoringUptimeCheckConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-friendly name for the uptime check configuration.
     *
     * The display name should be unique within a Stackdriver Workspace in order to make it easier to identify; however, uniqueness is not enforced.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#display_name MonitoringUptimeCheckConfig#display_name}
     */
    readonly displayName: string;
    /**
     * How often, in seconds, the uptime check is performed.
     *
     * Currently, the only supported values are 60s (1 minute), 300s (5 minutes), 600s (10 minutes), and 900s (15 minutes). Optional, defaults to 300s.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#period MonitoringUptimeCheckConfig#period}
     */
    readonly period?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#project MonitoringUptimeCheckConfig#project}.
     */
    readonly project?: string;
    /**
     * The list of regions from which the check will be run.
     *
     * Some regions contain one location, and others contain more than one. If this field is specified, enough regions to include a minimum of 3 locations must be provided, or an error message is returned. Not specifying this field will result in uptime checks running from all regions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#selected_regions MonitoringUptimeCheckConfig#selected_regions}
     */
    readonly selectedRegions?: string[];
    /**
     * The maximum amount of time to wait for the request to complete (must be between 1 and 60 seconds).
     *
     * Accepted formats https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.Duration
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#timeout MonitoringUptimeCheckConfig#timeout}
     */
    readonly timeout: string;
    /**
     * content_matchers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#content_matchers MonitoringUptimeCheckConfig#content_matchers}
     */
    readonly contentMatchers?: MonitoringUptimeCheckConfigContentMatchers[];
    /**
     * http_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#http_check MonitoringUptimeCheckConfig#http_check}
     */
    readonly httpCheck?: MonitoringUptimeCheckConfigHttpCheck;
    /**
     * monitored_resource block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#monitored_resource MonitoringUptimeCheckConfig#monitored_resource}
     */
    readonly monitoredResource?: MonitoringUptimeCheckConfigMonitoredResource;
    /**
     * resource_group block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#resource_group MonitoringUptimeCheckConfig#resource_group}
     */
    readonly resourceGroup?: MonitoringUptimeCheckConfigResourceGroup;
    /**
     * tcp_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#tcp_check MonitoringUptimeCheckConfig#tcp_check}
     */
    readonly tcpCheck?: MonitoringUptimeCheckConfigTcpCheck;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#timeouts MonitoringUptimeCheckConfig#timeouts}
     */
    readonly timeouts?: MonitoringUptimeCheckConfigTimeouts;
}
export interface MonitoringUptimeCheckConfigContentMatchers {
    /**
     * String or regex content to match (max 1024 bytes).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#content MonitoringUptimeCheckConfig#content}
     */
    readonly content: string;
    /**
     * The type of content matcher that will be applied to the server output, compared to the content string when the check is run.
     *
     * Default value: "CONTAINS_STRING" Possible values: ["CONTAINS_STRING", "NOT_CONTAINS_STRING", "MATCHES_REGEX", "NOT_MATCHES_REGEX"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#matcher MonitoringUptimeCheckConfig#matcher}
     */
    readonly matcher?: string;
}
export interface MonitoringUptimeCheckConfigHttpCheckAuthInfo {
    /**
     * The password to authenticate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#password MonitoringUptimeCheckConfig#password}
     */
    readonly password: string;
    /**
     * The username to authenticate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#username MonitoringUptimeCheckConfig#username}
     */
    readonly username: string;
}
export declare class MonitoringUptimeCheckConfigHttpCheckAuthInfoOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface MonitoringUptimeCheckConfigHttpCheck {
    /**
     * The request body associated with the HTTP POST request.
     *
     * If contentType is URL_ENCODED, the body passed in must be URL-encoded. Users can provide a Content-Length header via the headers field or the API will do so. If the requestMethod is GET and body is not empty, the API will return an error. The maximum byte size is 1 megabyte. Note - As with all bytes fields JSON representations are base64 encoded. e.g. "foo=bar" in URL-encoded form is "foo%3Dbar" and in base64 encoding is "Zm9vJTI1M0RiYXI=".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#body MonitoringUptimeCheckConfig#body}
     */
    readonly body?: string;
    /**
     * The content type to use for the check. Possible values: ["TYPE_UNSPECIFIED", "URL_ENCODED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#content_type MonitoringUptimeCheckConfig#content_type}
     */
    readonly contentType?: string;
    /**
     * The list of headers to send as part of the uptime check request.
     *
     * If two headers have the same key and different values, they should be entered as a single header, with the value being a comma-separated list of all the desired values as described at https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two separate headers with the same key in a Create call will cause the first to be overwritten by the second. The maximum number of headers allowed is 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#headers MonitoringUptimeCheckConfig#headers}
     */
    readonly headers?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Boolean specifying whether to encrypt the header information.
     *
     * Encryption should be specified for any headers related to authentication that you do not wish to be seen when retrieving the configuration. The server will be responsible for encrypting the headers. On Get/List calls, if mask_headers is set to True then the headers will be obscured with ******.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#mask_headers MonitoringUptimeCheckConfig#mask_headers}
     */
    readonly maskHeaders?: boolean | cdktf.IResolvable;
    /**
     * The path to the page to run the check against.
     *
     * Will be combined with the host (specified within the MonitoredResource) and port to construct the full URL. Optional (defaults to "/").
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#path MonitoringUptimeCheckConfig#path}
     */
    readonly path?: string;
    /**
     * The port to the page to run the check against.
     *
     * Will be combined with host (specified within the MonitoredResource) and path to construct the full URL. Optional (defaults to 80 without SSL, or 443 with SSL).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#port MonitoringUptimeCheckConfig#port}
     */
    readonly port?: number;
    /**
     * The HTTP request method to use for the check.
     *
     * If set to METHOD_UNSPECIFIED then requestMethod defaults to GET. Default value: "GET" Possible values: ["METHOD_UNSPECIFIED", "GET", "POST"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#request_method MonitoringUptimeCheckConfig#request_method}
     */
    readonly requestMethod?: string;
    /**
     * If true, use HTTPS instead of HTTP to run the check.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#use_ssl MonitoringUptimeCheckConfig#use_ssl}
     */
    readonly useSsl?: boolean | cdktf.IResolvable;
    /**
     * Boolean specifying whether to include SSL certificate validation as a part of the Uptime check.
     *
     * Only applies to checks where monitoredResource is set to uptime_url. If useSsl is false, setting validateSsl to true has no effect.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#validate_ssl MonitoringUptimeCheckConfig#validate_ssl}
     */
    readonly validateSsl?: boolean | cdktf.IResolvable;
    /**
     * auth_info block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#auth_info MonitoringUptimeCheckConfig#auth_info}
     */
    readonly authInfo?: MonitoringUptimeCheckConfigHttpCheckAuthInfo;
}
export declare class MonitoringUptimeCheckConfigHttpCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _body?;
    get body(): string | undefined;
    set body(value: string | undefined);
    resetBody(): void;
    get bodyInput(): string | undefined;
    private _contentType?;
    get contentType(): string | undefined;
    set contentType(value: string | undefined);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _headers?;
    get headers(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set headers(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _maskHeaders?;
    get maskHeaders(): boolean | cdktf.IResolvable | undefined;
    set maskHeaders(value: boolean | cdktf.IResolvable | undefined);
    resetMaskHeaders(): void;
    get maskHeadersInput(): boolean | cdktf.IResolvable | undefined;
    private _path?;
    get path(): string | undefined;
    set path(value: string | undefined);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _requestMethod?;
    get requestMethod(): string | undefined;
    set requestMethod(value: string | undefined);
    resetRequestMethod(): void;
    get requestMethodInput(): string | undefined;
    private _useSsl?;
    get useSsl(): boolean | cdktf.IResolvable | undefined;
    set useSsl(value: boolean | cdktf.IResolvable | undefined);
    resetUseSsl(): void;
    get useSslInput(): boolean | cdktf.IResolvable | undefined;
    private _validateSsl?;
    get validateSsl(): boolean | cdktf.IResolvable | undefined;
    set validateSsl(value: boolean | cdktf.IResolvable | undefined);
    resetValidateSsl(): void;
    get validateSslInput(): boolean | cdktf.IResolvable | undefined;
    private _authInfo?;
    private __authInfoOutput;
    get authInfo(): MonitoringUptimeCheckConfigHttpCheckAuthInfoOutputReference;
    putAuthInfo(value: MonitoringUptimeCheckConfigHttpCheckAuthInfo | undefined): void;
    resetAuthInfo(): void;
    get authInfoInput(): MonitoringUptimeCheckConfigHttpCheckAuthInfo | undefined;
}
export interface MonitoringUptimeCheckConfigMonitoredResource {
    /**
     * Values for all of the labels listed in the associated monitored resource descriptor.
     *
     * For example, Compute Engine VM instances use the labels "project_id", "instance_id", and "zone".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#labels MonitoringUptimeCheckConfig#labels}
     */
    readonly labels: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The monitored resource type.
     *
     * This field must match the type field of a MonitoredResourceDescriptor (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.monitoredResourceDescriptors#MonitoredResourceDescriptor) object. For example, the type of a Compute Engine VM instance is gce_instance. For a list of types, see Monitoring resource types (https://cloud.google.com/monitoring/api/resources) and Logging resource types (https://cloud.google.com/logging/docs/api/v2/resource-list).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#type MonitoringUptimeCheckConfig#type}
     */
    readonly type: string;
}
export declare class MonitoringUptimeCheckConfigMonitoredResourceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MonitoringUptimeCheckConfigResourceGroup {
    /**
     * The group of resources being monitored. Should be the 'name' of a group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#group_id MonitoringUptimeCheckConfig#group_id}
     */
    readonly groupId?: string;
    /**
     * The resource type of the group members. Possible values: ["RESOURCE_TYPE_UNSPECIFIED", "INSTANCE", "AWS_ELB_LOAD_BALANCER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#resource_type MonitoringUptimeCheckConfig#resource_type}
     */
    readonly resourceType?: string;
}
export declare class MonitoringUptimeCheckConfigResourceGroupOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _groupId?;
    get groupId(): string | undefined;
    set groupId(value: string | undefined);
    resetGroupId(): void;
    get groupIdInput(): string | undefined;
    private _resourceType?;
    get resourceType(): string | undefined;
    set resourceType(value: string | undefined);
    resetResourceType(): void;
    get resourceTypeInput(): string | undefined;
}
export interface MonitoringUptimeCheckConfigTcpCheck {
    /**
     * The port to the page to run the check against.
     *
     * Will be combined with host (specified within the MonitoredResource) to construct the full URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#port MonitoringUptimeCheckConfig#port}
     */
    readonly port: number;
}
export declare class MonitoringUptimeCheckConfigTcpCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
}
export interface MonitoringUptimeCheckConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#create MonitoringUptimeCheckConfig#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#delete MonitoringUptimeCheckConfig#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#update MonitoringUptimeCheckConfig#update}.
     */
    readonly update?: string;
}
export declare class MonitoringUptimeCheckConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html google_monitoring_uptime_check_config}.
 */
export declare class MonitoringUptimeCheckConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html google_monitoring_uptime_check_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: MonitoringUptimeCheckConfigConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _period?;
    get period(): string | undefined;
    set period(value: string | undefined);
    resetPeriod(): void;
    get periodInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _selectedRegions?;
    get selectedRegions(): string[] | undefined;
    set selectedRegions(value: string[] | undefined);
    resetSelectedRegions(): void;
    get selectedRegionsInput(): string[] | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    get timeoutInput(): string | undefined;
    get uptimeCheckId(): string;
    private _contentMatchers?;
    get contentMatchers(): MonitoringUptimeCheckConfigContentMatchers[] | undefined;
    set contentMatchers(value: MonitoringUptimeCheckConfigContentMatchers[] | undefined);
    resetContentMatchers(): void;
    get contentMatchersInput(): MonitoringUptimeCheckConfigContentMatchers[] | undefined;
    private _httpCheck?;
    private __httpCheckOutput;
    get httpCheck(): MonitoringUptimeCheckConfigHttpCheckOutputReference;
    putHttpCheck(value: MonitoringUptimeCheckConfigHttpCheck | undefined): void;
    resetHttpCheck(): void;
    get httpCheckInput(): MonitoringUptimeCheckConfigHttpCheck | undefined;
    private _monitoredResource?;
    private __monitoredResourceOutput;
    get monitoredResource(): MonitoringUptimeCheckConfigMonitoredResourceOutputReference;
    putMonitoredResource(value: MonitoringUptimeCheckConfigMonitoredResource | undefined): void;
    resetMonitoredResource(): void;
    get monitoredResourceInput(): MonitoringUptimeCheckConfigMonitoredResource | undefined;
    private _resourceGroup?;
    private __resourceGroupOutput;
    get resourceGroup(): MonitoringUptimeCheckConfigResourceGroupOutputReference;
    putResourceGroup(value: MonitoringUptimeCheckConfigResourceGroup | undefined): void;
    resetResourceGroup(): void;
    get resourceGroupInput(): MonitoringUptimeCheckConfigResourceGroup | undefined;
    private _tcpCheck?;
    private __tcpCheckOutput;
    get tcpCheck(): MonitoringUptimeCheckConfigTcpCheckOutputReference;
    putTcpCheck(value: MonitoringUptimeCheckConfigTcpCheck | undefined): void;
    resetTcpCheck(): void;
    get tcpCheckInput(): MonitoringUptimeCheckConfigTcpCheck | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): MonitoringUptimeCheckConfigTimeoutsOutputReference;
    putTimeouts(value: MonitoringUptimeCheckConfigTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): MonitoringUptimeCheckConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
