import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitoringSloConfig extends cdktf.TerraformMetaArguments {
    /**
     * A calendar period, semantically "since the start of the current <calendarPeriod>". Possible values: ["DAY", "WEEK", "FORTNIGHT", "MONTH"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#calendar_period MonitoringSlo#calendar_period}
     */
    readonly calendarPeriod?: string;
    /**
     * Name used for UI elements listing this SLO.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#display_name MonitoringSlo#display_name}
     */
    readonly displayName?: string;
    /**
     * The fraction of service that must be good in order for this objective to be met.
     *
     * 0 < goal <= 0.999
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#goal MonitoringSlo#goal}
     */
    readonly goal: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#project MonitoringSlo#project}.
     */
    readonly project?: string;
    /**
     * A rolling time period, semantically "in the past X days". Must be between 1 to 30 days, inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#rolling_period_days MonitoringSlo#rolling_period_days}
     */
    readonly rollingPeriodDays?: number;
    /**
     * ID of the service to which this SLO belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#service MonitoringSlo#service}
     */
    readonly service: string;
    /**
     * The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#slo_id MonitoringSlo#slo_id}
     */
    readonly sloId?: string;
    /**
     * basic_sli block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#basic_sli MonitoringSlo#basic_sli}
     */
    readonly basicSli?: MonitoringSloBasicSli;
    /**
     * request_based_sli block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#request_based_sli MonitoringSlo#request_based_sli}
     */
    readonly requestBasedSli?: MonitoringSloRequestBasedSli;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#timeouts MonitoringSlo#timeouts}
     */
    readonly timeouts?: MonitoringSloTimeouts;
    /**
     * windows_based_sli block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#windows_based_sli MonitoringSlo#windows_based_sli}
     */
    readonly windowsBasedSli?: MonitoringSloWindowsBasedSli;
}
export interface MonitoringSloBasicSliAvailability {
    /**
     * Whether an availability SLI is enabled or not. Must be set to true. Defaults to 'true'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#enabled MonitoringSlo#enabled}
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare class MonitoringSloBasicSliAvailabilityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable | undefined;
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MonitoringSloBasicSliLatency {
    /**
     * A duration string, e.g. 10s. Good service is defined to be the count of requests made to this service that return in no more than threshold.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#threshold MonitoringSlo#threshold}
     */
    readonly threshold: string;
}
export declare class MonitoringSloBasicSliLatencyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _threshold?;
    get threshold(): string;
    set threshold(value: string);
    get thresholdInput(): string | undefined;
}
export interface MonitoringSloBasicSli {
    /**
     * An optional set of locations to which this SLI is relevant.
     *
     * Telemetry from other locations will not be used to calculate
     * performance for this SLI. If omitted, this SLI applies to all
     * locations in which the Service has activity. For service types
     * that don't support breaking down by location, setting this
     * field will result in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#location MonitoringSlo#location}
     */
    readonly location?: string[];
    /**
     * An optional set of RPCs to which this SLI is relevant.
     *
     * Telemetry from other methods will not be used to calculate
     * performance for this SLI. If omitted, this SLI applies to all
     * the Service's methods. For service types that don't support
     * breaking down by method, setting this field will result in an
     * error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#method MonitoringSlo#method}
     */
    readonly method?: string[];
    /**
     * The set of API versions to which this SLI is relevant.
     *
     * Telemetry from other API versions will not be used to
     * calculate performance for this SLI. If omitted,
     * this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this
     * field will result in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#version MonitoringSlo#version}
     */
    readonly version?: string[];
    /**
     * availability block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#availability MonitoringSlo#availability}
     */
    readonly availability?: MonitoringSloBasicSliAvailability;
    /**
     * latency block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#latency MonitoringSlo#latency}
     */
    readonly latency?: MonitoringSloBasicSliLatency;
}
export declare class MonitoringSloBasicSliOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _location?;
    get location(): string[] | undefined;
    set location(value: string[] | undefined);
    resetLocation(): void;
    get locationInput(): string[] | undefined;
    private _method?;
    get method(): string[] | undefined;
    set method(value: string[] | undefined);
    resetMethod(): void;
    get methodInput(): string[] | undefined;
    private _version?;
    get version(): string[] | undefined;
    set version(value: string[] | undefined);
    resetVersion(): void;
    get versionInput(): string[] | undefined;
    private _availability?;
    private __availabilityOutput;
    get availability(): MonitoringSloBasicSliAvailabilityOutputReference;
    putAvailability(value: MonitoringSloBasicSliAvailability | undefined): void;
    resetAvailability(): void;
    get availabilityInput(): MonitoringSloBasicSliAvailability | undefined;
    private _latency?;
    private __latencyOutput;
    get latency(): MonitoringSloBasicSliLatencyOutputReference;
    putLatency(value: MonitoringSloBasicSliLatency | undefined): void;
    resetLatency(): void;
    get latencyInput(): MonitoringSloBasicSliLatency | undefined;
}
export interface MonitoringSloRequestBasedSliDistributionCutRange {
    /**
     * max value for the range (inclusive). If not given, will be set to "infinity", defining an open range ">= range.min".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#max MonitoringSlo#max}
     */
    readonly max?: number;
    /**
     * Min value for the range (inclusive). If not given, will be set to "-infinity", defining an open range "< range.max".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#min MonitoringSlo#min}
     */
    readonly min?: number;
}
export declare class MonitoringSloRequestBasedSliDistributionCutRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _max?;
    get max(): number | undefined;
    set max(value: number | undefined);
    resetMax(): void;
    get maxInput(): number | undefined;
    private _min?;
    get min(): number | undefined;
    set min(value: number | undefined);
    resetMin(): void;
    get minInput(): number | undefined;
}
export interface MonitoringSloRequestBasedSliDistributionCut {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) aggregating values to quantify the good service provided.
     *
     * Must have ValueType = DISTRIBUTION and
     * MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#distribution_filter MonitoringSlo#distribution_filter}
     */
    readonly distributionFilter: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#range MonitoringSlo#range}
     */
    readonly range: MonitoringSloRequestBasedSliDistributionCutRange;
}
export declare class MonitoringSloRequestBasedSliDistributionCutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _distributionFilter?;
    get distributionFilter(): string;
    set distributionFilter(value: string);
    get distributionFilterInput(): string | undefined;
    private _range?;
    private __rangeOutput;
    get range(): MonitoringSloRequestBasedSliDistributionCutRangeOutputReference;
    putRange(value: MonitoringSloRequestBasedSliDistributionCutRange): void;
    get rangeInput(): MonitoringSloRequestBasedSliDistributionCutRange | undefined;
}
export interface MonitoringSloRequestBasedSliGoodTotalRatio {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying bad service provided, either demanded service that was not provided or demanded service that was of inadequate quality.
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
     * must be set (good + bad = total is assumed).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#bad_service_filter MonitoringSlo#bad_service_filter}
     */
    readonly badServiceFilter?: string;
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying good service provided. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
     * must be set (good + bad = total is assumed).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#good_service_filter MonitoringSlo#good_service_filter}
     */
    readonly goodServiceFilter?: string;
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying total demanded service.
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
     * must be set (good + bad = total is assumed).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#total_service_filter MonitoringSlo#total_service_filter}
     */
    readonly totalServiceFilter?: string;
}
export declare class MonitoringSloRequestBasedSliGoodTotalRatioOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _badServiceFilter?;
    get badServiceFilter(): string | undefined;
    set badServiceFilter(value: string | undefined);
    resetBadServiceFilter(): void;
    get badServiceFilterInput(): string | undefined;
    private _goodServiceFilter?;
    get goodServiceFilter(): string | undefined;
    set goodServiceFilter(value: string | undefined);
    resetGoodServiceFilter(): void;
    get goodServiceFilterInput(): string | undefined;
    private _totalServiceFilter?;
    get totalServiceFilter(): string | undefined;
    set totalServiceFilter(value: string | undefined);
    resetTotalServiceFilter(): void;
    get totalServiceFilterInput(): string | undefined;
}
export interface MonitoringSloRequestBasedSli {
    /**
     * distribution_cut block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#distribution_cut MonitoringSlo#distribution_cut}
     */
    readonly distributionCut?: MonitoringSloRequestBasedSliDistributionCut;
    /**
     * good_total_ratio block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#good_total_ratio MonitoringSlo#good_total_ratio}
     */
    readonly goodTotalRatio?: MonitoringSloRequestBasedSliGoodTotalRatio;
}
export declare class MonitoringSloRequestBasedSliOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _distributionCut?;
    private __distributionCutOutput;
    get distributionCut(): MonitoringSloRequestBasedSliDistributionCutOutputReference;
    putDistributionCut(value: MonitoringSloRequestBasedSliDistributionCut | undefined): void;
    resetDistributionCut(): void;
    get distributionCutInput(): MonitoringSloRequestBasedSliDistributionCut | undefined;
    private _goodTotalRatio?;
    private __goodTotalRatioOutput;
    get goodTotalRatio(): MonitoringSloRequestBasedSliGoodTotalRatioOutputReference;
    putGoodTotalRatio(value: MonitoringSloRequestBasedSliGoodTotalRatio | undefined): void;
    resetGoodTotalRatio(): void;
    get goodTotalRatioInput(): MonitoringSloRequestBasedSliGoodTotalRatio | undefined;
}
export interface MonitoringSloTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#create MonitoringSlo#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#delete MonitoringSlo#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#update MonitoringSlo#update}.
     */
    readonly update?: string;
}
export declare class MonitoringSloTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability {
    /**
     * Whether an availability SLI is enabled or not. Must be set to 'true. Defaults to 'true'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#enabled MonitoringSlo#enabled}
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable | undefined;
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency {
    /**
     * A duration string, e.g. 10s. Good service is defined to be the count of requests made to this service that return in no more than threshold.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#threshold MonitoringSlo#threshold}
     */
    readonly threshold: string;
}
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _threshold?;
    get threshold(): string;
    set threshold(value: string);
    get thresholdInput(): string | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance {
    /**
     * An optional set of locations to which this SLI is relevant.
     *
     * Telemetry from other locations will not be used to calculate
     * performance for this SLI. If omitted, this SLI applies to all
     * locations in which the Service has activity. For service types
     * that don't support breaking down by location, setting this
     * field will result in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#location MonitoringSlo#location}
     */
    readonly location?: string[];
    /**
     * An optional set of RPCs to which this SLI is relevant.
     *
     * Telemetry from other methods will not be used to calculate
     * performance for this SLI. If omitted, this SLI applies to all
     * the Service's methods. For service types that don't support
     * breaking down by method, setting this field will result in an
     * error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#method MonitoringSlo#method}
     */
    readonly method?: string[];
    /**
     * The set of API versions to which this SLI is relevant.
     *
     * Telemetry from other API versions will not be used to
     * calculate performance for this SLI. If omitted,
     * this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this
     * field will result in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#version MonitoringSlo#version}
     */
    readonly version?: string[];
    /**
     * availability block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#availability MonitoringSlo#availability}
     */
    readonly availability?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability;
    /**
     * latency block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#latency MonitoringSlo#latency}
     */
    readonly latency?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency;
}
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _location?;
    get location(): string[] | undefined;
    set location(value: string[] | undefined);
    resetLocation(): void;
    get locationInput(): string[] | undefined;
    private _method?;
    get method(): string[] | undefined;
    set method(value: string[] | undefined);
    resetMethod(): void;
    get methodInput(): string[] | undefined;
    private _version?;
    get version(): string[] | undefined;
    set version(value: string[] | undefined);
    resetVersion(): void;
    get versionInput(): string[] | undefined;
    private _availability?;
    private __availabilityOutput;
    get availability(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityOutputReference;
    putAvailability(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability | undefined): void;
    resetAvailability(): void;
    get availabilityInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability | undefined;
    private _latency?;
    private __latencyOutput;
    get latency(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyOutputReference;
    putLatency(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency | undefined): void;
    resetLatency(): void;
    get latencyInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange {
    /**
     * max value for the range (inclusive). If not given, will be set to "infinity", defining an open range ">= range.min".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#max MonitoringSlo#max}
     */
    readonly max?: number;
    /**
     * Min value for the range (inclusive). If not given, will be set to "-infinity", defining an open range "< range.max".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#min MonitoringSlo#min}
     */
    readonly min?: number;
}
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _max?;
    get max(): number | undefined;
    set max(value: number | undefined);
    resetMax(): void;
    get maxInput(): number | undefined;
    private _min?;
    get min(): number | undefined;
    set min(value: number | undefined);
    resetMin(): void;
    get minInput(): number | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) aggregating values to quantify the good service provided.
     *
     * Must have ValueType = DISTRIBUTION and
     * MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#distribution_filter MonitoringSlo#distribution_filter}
     */
    readonly distributionFilter: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#range MonitoringSlo#range}
     */
    readonly range: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange;
}
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _distributionFilter?;
    get distributionFilter(): string;
    set distributionFilter(value: string);
    get distributionFilterInput(): string | undefined;
    private _range?;
    private __rangeOutput;
    get range(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeOutputReference;
    putRange(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange): void;
    get rangeInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying bad service provided, either demanded service that was not provided or demanded service that was of inadequate quality. Exactly two of good, bad, or total service filter must be defined (where good + bad = total is assumed).
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#bad_service_filter MonitoringSlo#bad_service_filter}
     */
    readonly badServiceFilter?: string;
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying good service provided. Exactly two of good, bad, or total service filter must be defined (where good + bad = total is assumed).
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#good_service_filter MonitoringSlo#good_service_filter}
     */
    readonly goodServiceFilter?: string;
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying total demanded service. Exactly two of good, bad, or total service filter must be defined (where good + bad = total is assumed).
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#total_service_filter MonitoringSlo#total_service_filter}
     */
    readonly totalServiceFilter?: string;
}
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _badServiceFilter?;
    get badServiceFilter(): string | undefined;
    set badServiceFilter(value: string | undefined);
    resetBadServiceFilter(): void;
    get badServiceFilterInput(): string | undefined;
    private _goodServiceFilter?;
    get goodServiceFilter(): string | undefined;
    set goodServiceFilter(value: string | undefined);
    resetGoodServiceFilter(): void;
    get goodServiceFilterInput(): string | undefined;
    private _totalServiceFilter?;
    get totalServiceFilter(): string | undefined;
    set totalServiceFilter(value: string | undefined);
    resetTotalServiceFilter(): void;
    get totalServiceFilterInput(): string | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance {
    /**
     * distribution_cut block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#distribution_cut MonitoringSlo#distribution_cut}
     */
    readonly distributionCut?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut;
    /**
     * good_total_ratio block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#good_total_ratio MonitoringSlo#good_total_ratio}
     */
    readonly goodTotalRatio?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio;
}
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _distributionCut?;
    private __distributionCutOutput;
    get distributionCut(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutOutputReference;
    putDistributionCut(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut | undefined): void;
    resetDistributionCut(): void;
    get distributionCutInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut | undefined;
    private _goodTotalRatio?;
    private __goodTotalRatioOutput;
    get goodTotalRatio(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioOutputReference;
    putGoodTotalRatio(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio | undefined): void;
    resetGoodTotalRatio(): void;
    get goodTotalRatioInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThreshold {
    /**
     * If window performance >= threshold, the window is counted as good.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#threshold MonitoringSlo#threshold}
     */
    readonly threshold?: number;
    /**
     * basic_sli_performance block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#basic_sli_performance MonitoringSlo#basic_sli_performance}
     */
    readonly basicSliPerformance?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance;
    /**
     * performance block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#performance MonitoringSlo#performance}
     */
    readonly performance?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance;
}
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _threshold?;
    get threshold(): number | undefined;
    set threshold(value: number | undefined);
    resetThreshold(): void;
    get thresholdInput(): number | undefined;
    private _basicSliPerformance?;
    private __basicSliPerformanceOutput;
    get basicSliPerformance(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceOutputReference;
    putBasicSliPerformance(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance | undefined): void;
    resetBasicSliPerformance(): void;
    get basicSliPerformanceInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance | undefined;
    private _performance?;
    private __performanceOutput;
    get performance(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceOutputReference;
    putPerformance(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance | undefined): void;
    resetPerformance(): void;
    get performanceInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance | undefined;
}
export interface MonitoringSloWindowsBasedSliMetricMeanInRangeRange {
    /**
     * max value for the range (inclusive). If not given, will be set to "infinity", defining an open range ">= range.min".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#max MonitoringSlo#max}
     */
    readonly max?: number;
    /**
     * Min value for the range (inclusive). If not given, will be set to "-infinity", defining an open range "< range.max".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#min MonitoringSlo#min}
     */
    readonly min?: number;
}
export declare class MonitoringSloWindowsBasedSliMetricMeanInRangeRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _max?;
    get max(): number | undefined;
    set max(value: number | undefined);
    resetMax(): void;
    get maxInput(): number | undefined;
    private _min?;
    get min(): number | undefined;
    set min(value: number | undefined);
    resetMin(): void;
    get minInput(): number | undefined;
}
export interface MonitoringSloWindowsBasedSliMetricMeanInRange {
    /**
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) specifying the TimeSeries to use for evaluating window The provided TimeSeries must have ValueType = INT64 or ValueType = DOUBLE and MetricKind = GAUGE. Mean value 'X' should satisfy 'range.min <= X <= range.max' under good service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#time_series MonitoringSlo#time_series}
     */
    readonly timeSeries: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#range MonitoringSlo#range}
     */
    readonly range: MonitoringSloWindowsBasedSliMetricMeanInRangeRange;
}
export declare class MonitoringSloWindowsBasedSliMetricMeanInRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _timeSeries?;
    get timeSeries(): string;
    set timeSeries(value: string);
    get timeSeriesInput(): string | undefined;
    private _range?;
    private __rangeOutput;
    get range(): MonitoringSloWindowsBasedSliMetricMeanInRangeRangeOutputReference;
    putRange(value: MonitoringSloWindowsBasedSliMetricMeanInRangeRange): void;
    get rangeInput(): MonitoringSloWindowsBasedSliMetricMeanInRangeRange | undefined;
}
export interface MonitoringSloWindowsBasedSliMetricSumInRangeRange {
    /**
     * max value for the range (inclusive). If not given, will be set to "infinity", defining an open range ">= range.min".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#max MonitoringSlo#max}
     */
    readonly max?: number;
    /**
     * Min value for the range (inclusive). If not given, will be set to "-infinity", defining an open range "< range.max".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#min MonitoringSlo#min}
     */
    readonly min?: number;
}
export declare class MonitoringSloWindowsBasedSliMetricSumInRangeRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _max?;
    get max(): number | undefined;
    set max(value: number | undefined);
    resetMax(): void;
    get maxInput(): number | undefined;
    private _min?;
    get min(): number | undefined;
    set min(value: number | undefined);
    resetMin(): void;
    get minInput(): number | undefined;
}
export interface MonitoringSloWindowsBasedSliMetricSumInRange {
    /**
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) specifying the TimeSeries to use for evaluating window quality. The provided TimeSeries must have ValueType = INT64 or ValueType = DOUBLE and MetricKind = GAUGE.
     *
     * Summed value 'X' should satisfy
     * 'range.min <= X <= range.max' for a good window.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#time_series MonitoringSlo#time_series}
     */
    readonly timeSeries: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#range MonitoringSlo#range}
     */
    readonly range: MonitoringSloWindowsBasedSliMetricSumInRangeRange;
}
export declare class MonitoringSloWindowsBasedSliMetricSumInRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _timeSeries?;
    get timeSeries(): string;
    set timeSeries(value: string);
    get timeSeriesInput(): string | undefined;
    private _range?;
    private __rangeOutput;
    get range(): MonitoringSloWindowsBasedSliMetricSumInRangeRangeOutputReference;
    putRange(value: MonitoringSloWindowsBasedSliMetricSumInRangeRange): void;
    get rangeInput(): MonitoringSloWindowsBasedSliMetricSumInRangeRange | undefined;
}
export interface MonitoringSloWindowsBasedSli {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) with ValueType = BOOL. The window is good if any true values appear in the window. One of 'good_bad_metric_filter', 'good_total_ratio_threshold', 'metric_mean_in_range', 'metric_sum_in_range' must be set for 'windows_based_sli'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#good_bad_metric_filter MonitoringSlo#good_bad_metric_filter}
     */
    readonly goodBadMetricFilter?: string;
    /**
     * Duration over which window quality is evaluated, given as a duration string "{X}s" representing X seconds.
     *
     * Must be an
     * integer fraction of a day and at least 60s.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#window_period MonitoringSlo#window_period}
     */
    readonly windowPeriod?: string;
    /**
     * good_total_ratio_threshold block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#good_total_ratio_threshold MonitoringSlo#good_total_ratio_threshold}
     */
    readonly goodTotalRatioThreshold?: MonitoringSloWindowsBasedSliGoodTotalRatioThreshold;
    /**
     * metric_mean_in_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#metric_mean_in_range MonitoringSlo#metric_mean_in_range}
     */
    readonly metricMeanInRange?: MonitoringSloWindowsBasedSliMetricMeanInRange;
    /**
     * metric_sum_in_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#metric_sum_in_range MonitoringSlo#metric_sum_in_range}
     */
    readonly metricSumInRange?: MonitoringSloWindowsBasedSliMetricSumInRange;
}
export declare class MonitoringSloWindowsBasedSliOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _goodBadMetricFilter?;
    get goodBadMetricFilter(): string | undefined;
    set goodBadMetricFilter(value: string | undefined);
    resetGoodBadMetricFilter(): void;
    get goodBadMetricFilterInput(): string | undefined;
    private _windowPeriod?;
    get windowPeriod(): string | undefined;
    set windowPeriod(value: string | undefined);
    resetWindowPeriod(): void;
    get windowPeriodInput(): string | undefined;
    private _goodTotalRatioThreshold?;
    private __goodTotalRatioThresholdOutput;
    get goodTotalRatioThreshold(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdOutputReference;
    putGoodTotalRatioThreshold(value: MonitoringSloWindowsBasedSliGoodTotalRatioThreshold | undefined): void;
    resetGoodTotalRatioThreshold(): void;
    get goodTotalRatioThresholdInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThreshold | undefined;
    private _metricMeanInRange?;
    private __metricMeanInRangeOutput;
    get metricMeanInRange(): MonitoringSloWindowsBasedSliMetricMeanInRangeOutputReference;
    putMetricMeanInRange(value: MonitoringSloWindowsBasedSliMetricMeanInRange | undefined): void;
    resetMetricMeanInRange(): void;
    get metricMeanInRangeInput(): MonitoringSloWindowsBasedSliMetricMeanInRange | undefined;
    private _metricSumInRange?;
    private __metricSumInRangeOutput;
    get metricSumInRange(): MonitoringSloWindowsBasedSliMetricSumInRangeOutputReference;
    putMetricSumInRange(value: MonitoringSloWindowsBasedSliMetricSumInRange | undefined): void;
    resetMetricSumInRange(): void;
    get metricSumInRangeInput(): MonitoringSloWindowsBasedSliMetricSumInRange | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html google_monitoring_slo}.
 */
export declare class MonitoringSlo extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html google_monitoring_slo} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: MonitoringSloConfig);
    private _calendarPeriod?;
    get calendarPeriod(): string | undefined;
    set calendarPeriod(value: string | undefined);
    resetCalendarPeriod(): void;
    get calendarPeriodInput(): string | undefined;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _goal?;
    get goal(): number;
    set goal(value: number);
    get goalInput(): number | undefined;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _rollingPeriodDays?;
    get rollingPeriodDays(): number | undefined;
    set rollingPeriodDays(value: number | undefined);
    resetRollingPeriodDays(): void;
    get rollingPeriodDaysInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _sloId?;
    get sloId(): string | undefined;
    set sloId(value: string | undefined);
    resetSloId(): void;
    get sloIdInput(): string | undefined;
    private _basicSli?;
    private __basicSliOutput;
    get basicSli(): MonitoringSloBasicSliOutputReference;
    putBasicSli(value: MonitoringSloBasicSli | undefined): void;
    resetBasicSli(): void;
    get basicSliInput(): MonitoringSloBasicSli | undefined;
    private _requestBasedSli?;
    private __requestBasedSliOutput;
    get requestBasedSli(): MonitoringSloRequestBasedSliOutputReference;
    putRequestBasedSli(value: MonitoringSloRequestBasedSli | undefined): void;
    resetRequestBasedSli(): void;
    get requestBasedSliInput(): MonitoringSloRequestBasedSli | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): MonitoringSloTimeoutsOutputReference;
    putTimeouts(value: MonitoringSloTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): MonitoringSloTimeouts | undefined;
    private _windowsBasedSli?;
    private __windowsBasedSliOutput;
    get windowsBasedSli(): MonitoringSloWindowsBasedSliOutputReference;
    putWindowsBasedSli(value: MonitoringSloWindowsBasedSli | undefined): void;
    resetWindowsBasedSli(): void;
    get windowsBasedSliInput(): MonitoringSloWindowsBasedSli | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
