import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitoringGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * A user-assigned name for this group, used only for display purposes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#display_name MonitoringGroup#display_name}
     */
    readonly displayName: string;
    /**
     * The filter used to determine which monitored resources belong to this group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#filter MonitoringGroup#filter}
     */
    readonly filter: string;
    /**
     * If true, the members of this group are considered to be a cluster.
     *
     * The system can perform additional analysis on
     * groups that are clusters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#is_cluster MonitoringGroup#is_cluster}
     */
    readonly isCluster?: boolean | cdktf.IResolvable;
    /**
     * The name of the group's parent, if it has one.
     *
     * The format is
     * "projects/{project_id_or_number}/groups/{group_id}". For
     * groups with no parent, parentName is the empty string, "".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#parent_name MonitoringGroup#parent_name}
     */
    readonly parentName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#project MonitoringGroup#project}.
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#timeouts MonitoringGroup#timeouts}
     */
    readonly timeouts?: MonitoringGroupTimeouts;
}
export interface MonitoringGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#create MonitoringGroup#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#delete MonitoringGroup#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#update MonitoringGroup#update}.
     */
    readonly update?: string;
}
export declare class MonitoringGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html google_monitoring_group}.
 */
export declare class MonitoringGroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html google_monitoring_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: MonitoringGroupConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    get id(): string;
    private _isCluster?;
    get isCluster(): boolean | cdktf.IResolvable | undefined;
    set isCluster(value: boolean | cdktf.IResolvable | undefined);
    resetIsCluster(): void;
    get isClusterInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    private _parentName?;
    get parentName(): string | undefined;
    set parentName(value: string | undefined);
    resetParentName(): void;
    get parentNameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): MonitoringGroupTimeoutsOutputReference;
    putTimeouts(value: MonitoringGroupTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): MonitoringGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
