import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitoringDashboardConfig extends cdktf.TerraformMetaArguments {
    /**
     * The JSON representation of a dashboard, following the format at https://cloud.google.com/monitoring/api/ref_v3/rest/v1/projects.dashboards.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard.html#dashboard_json MonitoringDashboard#dashboard_json}
     */
    readonly dashboardJson: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard.html#project MonitoringDashboard#project}
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard.html#timeouts MonitoringDashboard#timeouts}
     */
    readonly timeouts?: MonitoringDashboardTimeouts;
}
export interface MonitoringDashboardTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard.html#create MonitoringDashboard#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard.html#delete MonitoringDashboard#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard.html#update MonitoringDashboard#update}.
     */
    readonly update?: string;
}
export declare class MonitoringDashboardTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard.html google_monitoring_dashboard}.
 */
export declare class MonitoringDashboard extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_dashboard.html google_monitoring_dashboard} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: MonitoringDashboardConfig);
    private _dashboardJson?;
    get dashboardJson(): string;
    set dashboardJson(value: string);
    get dashboardJsonInput(): string | undefined;
    get id(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): MonitoringDashboardTimeoutsOutputReference;
    putTimeouts(value: MonitoringDashboardTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): MonitoringDashboardTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
