import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MlEngineModelConfig extends cdktf.TerraformMetaArguments {
    /**
     * The description specified for the model when it was created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#description MlEngineModel#description}
     */
    readonly description?: string;
    /**
     * One or more labels that you can add, to organize your models.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#labels MlEngineModel#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The name specified for the model.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#name MlEngineModel#name}
     */
    readonly name: string;
    /**
     * If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#online_prediction_console_logging MlEngineModel#online_prediction_console_logging}
     */
    readonly onlinePredictionConsoleLogging?: boolean | cdktf.IResolvable;
    /**
     * If true, online prediction access logs are sent to StackDriver Logging.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#online_prediction_logging MlEngineModel#online_prediction_logging}
     */
    readonly onlinePredictionLogging?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#project MlEngineModel#project}.
     */
    readonly project?: string;
    /**
     * The list of regions where the model is going to be deployed. Currently only one region per model is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#regions MlEngineModel#regions}
     */
    readonly regions?: string[];
    /**
     * default_version block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#default_version MlEngineModel#default_version}
     */
    readonly defaultVersion?: MlEngineModelDefaultVersion;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#timeouts MlEngineModel#timeouts}
     */
    readonly timeouts?: MlEngineModelTimeouts;
}
export interface MlEngineModelDefaultVersion {
    /**
     * The name specified for the version when it was created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#name MlEngineModel#name}
     */
    readonly name: string;
}
export declare class MlEngineModelDefaultVersionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface MlEngineModelTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#create MlEngineModel#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#delete MlEngineModel#delete}.
     */
    readonly delete?: string;
}
export declare class MlEngineModelTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html google_ml_engine_model}.
 */
export declare class MlEngineModel extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html google_ml_engine_model} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: MlEngineModelConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _onlinePredictionConsoleLogging?;
    get onlinePredictionConsoleLogging(): boolean | cdktf.IResolvable | undefined;
    set onlinePredictionConsoleLogging(value: boolean | cdktf.IResolvable | undefined);
    resetOnlinePredictionConsoleLogging(): void;
    get onlinePredictionConsoleLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _onlinePredictionLogging?;
    get onlinePredictionLogging(): boolean | cdktf.IResolvable | undefined;
    set onlinePredictionLogging(value: boolean | cdktf.IResolvable | undefined);
    resetOnlinePredictionLogging(): void;
    get onlinePredictionLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _regions?;
    get regions(): string[] | undefined;
    set regions(value: string[] | undefined);
    resetRegions(): void;
    get regionsInput(): string[] | undefined;
    private _defaultVersion?;
    private __defaultVersionOutput;
    get defaultVersion(): MlEngineModelDefaultVersionOutputReference;
    putDefaultVersion(value: MlEngineModelDefaultVersion | undefined): void;
    resetDefaultVersion(): void;
    get defaultVersionInput(): MlEngineModelDefaultVersion | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): MlEngineModelTimeoutsOutputReference;
    putTimeouts(value: MlEngineModelTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): MlEngineModelTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
