import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MemcacheInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The full name of the GCE network to connect the instance to.  If not provided, 'default' will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#authorized_network MemcacheInstance#authorized_network}
     */
    readonly authorizedNetwork?: string;
    /**
     * A user-visible name for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#display_name MemcacheInstance#display_name}
     */
    readonly displayName?: string;
    /**
     * Resource labels to represent user-provided metadata.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#labels MemcacheInstance#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The major version of Memcached software.
     *
     * If not provided, latest supported version will be used.
     * Currently the latest supported major version is MEMCACHE_1_5. The minor version will be automatically
     * determined by our system based on the latest supported minor version. Default value: "MEMCACHE_1_5" Possible values: ["MEMCACHE_1_5"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#memcache_version MemcacheInstance#memcache_version}
     */
    readonly memcacheVersion?: string;
    /**
     * The resource name of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#name MemcacheInstance#name}
     */
    readonly name: string;
    /**
     * Number of nodes in the memcache instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#node_count MemcacheInstance#node_count}
     */
    readonly nodeCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#project MemcacheInstance#project}.
     */
    readonly project?: string;
    /**
     * The region of the Memcache instance. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#region MemcacheInstance#region}
     */
    readonly region?: string;
    /**
     * Zones where memcache nodes should be provisioned.  If not provided, all zones will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#zones MemcacheInstance#zones}
     */
    readonly zones?: string[];
    /**
     * memcache_parameters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#memcache_parameters MemcacheInstance#memcache_parameters}
     */
    readonly memcacheParameters?: MemcacheInstanceMemcacheParameters;
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#node_config MemcacheInstance#node_config}
     */
    readonly nodeConfig: MemcacheInstanceNodeConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#timeouts MemcacheInstance#timeouts}
     */
    readonly timeouts?: MemcacheInstanceTimeouts;
}
export declare class MemcacheInstanceMemcacheNodes extends cdktf.ComplexComputedList {
    get host(): string;
    get nodeId(): string;
    get port(): number;
    get state(): string;
    get zone(): string;
}
export interface MemcacheInstanceMemcacheParameters {
    /**
     * User-defined set of parameters to use in the memcache process.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#params MemcacheInstance#params}
     */
    readonly params?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class MemcacheInstanceMemcacheParametersOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _params?;
    get params(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set params(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetParams(): void;
    get paramsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface MemcacheInstanceNodeConfig {
    /**
     * Number of CPUs per node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#cpu_count MemcacheInstance#cpu_count}
     */
    readonly cpuCount: number;
    /**
     * Memory size in Mebibytes for each memcache node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#memory_size_mb MemcacheInstance#memory_size_mb}
     */
    readonly memorySizeMb: number;
}
export declare class MemcacheInstanceNodeConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cpuCount?;
    get cpuCount(): number;
    set cpuCount(value: number);
    get cpuCountInput(): number | undefined;
    private _memorySizeMb?;
    get memorySizeMb(): number;
    set memorySizeMb(value: number);
    get memorySizeMbInput(): number | undefined;
}
export interface MemcacheInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#create MemcacheInstance#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#delete MemcacheInstance#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html#update MemcacheInstance#update}.
     */
    readonly update?: string;
}
export declare class MemcacheInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html google_memcache_instance}.
 */
export declare class MemcacheInstance extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/memcache_instance.html google_memcache_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: MemcacheInstanceConfig);
    private _authorizedNetwork?;
    get authorizedNetwork(): string | undefined;
    set authorizedNetwork(value: string | undefined);
    resetAuthorizedNetwork(): void;
    get authorizedNetworkInput(): string | undefined;
    get createTime(): string;
    get discoveryEndpoint(): string;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    get memcacheFullVersion(): string;
    memcacheNodes(index: string): MemcacheInstanceMemcacheNodes;
    private _memcacheVersion?;
    get memcacheVersion(): string | undefined;
    set memcacheVersion(value: string | undefined);
    resetMemcacheVersion(): void;
    get memcacheVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    get nodeCountInput(): number | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _zones?;
    get zones(): string[] | undefined;
    set zones(value: string[] | undefined);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _memcacheParameters?;
    private __memcacheParametersOutput;
    get memcacheParameters(): MemcacheInstanceMemcacheParametersOutputReference;
    putMemcacheParameters(value: MemcacheInstanceMemcacheParameters | undefined): void;
    resetMemcacheParameters(): void;
    get memcacheParametersInput(): MemcacheInstanceMemcacheParameters | undefined;
    private _nodeConfig?;
    private __nodeConfigOutput;
    get nodeConfig(): MemcacheInstanceNodeConfigOutputReference;
    putNodeConfig(value: MemcacheInstanceNodeConfig): void;
    get nodeConfigInput(): MemcacheInstanceNodeConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): MemcacheInstanceTimeoutsOutputReference;
    putTimeouts(value: MemcacheInstanceTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): MemcacheInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
