import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoggingProjectExclusionConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_exclusion.html#description LoggingProjectExclusion#description}
     */
    readonly description?: string;
    /**
     * Whether this exclusion rule should be disabled or not. This defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_exclusion.html#disabled LoggingProjectExclusion#disabled}
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * The filter to apply when excluding logs. Only log entries that match the filter are excluded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_exclusion.html#filter LoggingProjectExclusion#filter}
     */
    readonly filter: string;
    /**
     * The name of the logging exclusion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_exclusion.html#name LoggingProjectExclusion#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_exclusion.html#project LoggingProjectExclusion#project}.
     */
    readonly project?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_project_exclusion.html google_logging_project_exclusion}.
 */
export declare class LoggingProjectExclusion extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_project_exclusion.html google_logging_project_exclusion} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: LoggingProjectExclusionConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable | undefined;
    set disabled(value: boolean | cdktf.IResolvable | undefined);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
