import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoggingMetricConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of this metric, which is used in documentation. The maximum length of the description is 8000 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#description LoggingMetric#description}
     */
    readonly description?: string;
    /**
     * An advanced logs filter (https://cloud.google.com/logging/docs/view/advanced-filters) which is used to match log entries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#filter LoggingMetric#filter}
     */
    readonly filter: string;
    /**
     * A map from a label key string to an extractor expression which is used to extract data from a log entry field and assign as the label value.
     *
     * Each label key specified in the LabelDescriptor must
     * have an associated extractor expression in this map. The syntax of the extractor expression is
     * the same as for the valueExtractor field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#label_extractors LoggingMetric#label_extractors}
     */
    readonly labelExtractors?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The client-assigned metric identifier.
     *
     * Examples - "error_count", "nginx/requests".
     * Metric identifiers are limited to 100 characters and can include only the following
     * characters A-Z, a-z, 0-9, and the special characters _-.,+!*',()%/. The forward-slash
     * character (/) denotes a hierarchy of name pieces, and it cannot be the first character
     * of the name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#name LoggingMetric#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#project LoggingMetric#project}.
     */
    readonly project?: string;
    /**
     * A valueExtractor is required when using a distribution logs-based metric to extract the values to record from a log entry.
     *
     * Two functions are supported for value extraction - EXTRACT(field) or
     * REGEXP_EXTRACT(field, regex). The argument are 1. field - The name of the log entry field from which
     * the value is to be extracted. 2. regex - A regular expression using the Google RE2 syntax
     * (https://github.com/google/re2/wiki/Syntax) with a single capture group to extract data from the specified
     * log entry field. The value of the field is converted to a string before applying the regex. It is an
     * error to specify a regex that does not include exactly one capture group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#value_extractor LoggingMetric#value_extractor}
     */
    readonly valueExtractor?: string;
    /**
     * bucket_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#bucket_options LoggingMetric#bucket_options}
     */
    readonly bucketOptions?: LoggingMetricBucketOptions;
    /**
     * metric_descriptor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#metric_descriptor LoggingMetric#metric_descriptor}
     */
    readonly metricDescriptor: LoggingMetricMetricDescriptor;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#timeouts LoggingMetric#timeouts}
     */
    readonly timeouts?: LoggingMetricTimeouts;
}
export interface LoggingMetricBucketOptionsExplicitBuckets {
    /**
     * The values must be monotonically increasing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#bounds LoggingMetric#bounds}
     */
    readonly bounds: number[];
}
export declare class LoggingMetricBucketOptionsExplicitBucketsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bounds?;
    get bounds(): number[];
    set bounds(value: number[]);
    get boundsInput(): number[] | undefined;
}
export interface LoggingMetricBucketOptionsExponentialBuckets {
    /**
     * Must be greater than 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#growth_factor LoggingMetric#growth_factor}
     */
    readonly growthFactor?: number;
    /**
     * Must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#num_finite_buckets LoggingMetric#num_finite_buckets}
     */
    readonly numFiniteBuckets?: number;
    /**
     * Must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#scale LoggingMetric#scale}
     */
    readonly scale?: number;
}
export declare class LoggingMetricBucketOptionsExponentialBucketsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _growthFactor?;
    get growthFactor(): number | undefined;
    set growthFactor(value: number | undefined);
    resetGrowthFactor(): void;
    get growthFactorInput(): number | undefined;
    private _numFiniteBuckets?;
    get numFiniteBuckets(): number | undefined;
    set numFiniteBuckets(value: number | undefined);
    resetNumFiniteBuckets(): void;
    get numFiniteBucketsInput(): number | undefined;
    private _scale?;
    get scale(): number | undefined;
    set scale(value: number | undefined);
    resetScale(): void;
    get scaleInput(): number | undefined;
}
export interface LoggingMetricBucketOptionsLinearBuckets {
    /**
     * Must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#num_finite_buckets LoggingMetric#num_finite_buckets}
     */
    readonly numFiniteBuckets?: number;
    /**
     * Lower bound of the first bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#offset LoggingMetric#offset}
     */
    readonly offset?: number;
    /**
     * Must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#width LoggingMetric#width}
     */
    readonly width?: number;
}
export declare class LoggingMetricBucketOptionsLinearBucketsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _numFiniteBuckets?;
    get numFiniteBuckets(): number | undefined;
    set numFiniteBuckets(value: number | undefined);
    resetNumFiniteBuckets(): void;
    get numFiniteBucketsInput(): number | undefined;
    private _offset?;
    get offset(): number | undefined;
    set offset(value: number | undefined);
    resetOffset(): void;
    get offsetInput(): number | undefined;
    private _width?;
    get width(): number | undefined;
    set width(value: number | undefined);
    resetWidth(): void;
    get widthInput(): number | undefined;
}
export interface LoggingMetricBucketOptions {
    /**
     * explicit_buckets block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#explicit_buckets LoggingMetric#explicit_buckets}
     */
    readonly explicitBuckets?: LoggingMetricBucketOptionsExplicitBuckets;
    /**
     * exponential_buckets block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#exponential_buckets LoggingMetric#exponential_buckets}
     */
    readonly exponentialBuckets?: LoggingMetricBucketOptionsExponentialBuckets;
    /**
     * linear_buckets block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#linear_buckets LoggingMetric#linear_buckets}
     */
    readonly linearBuckets?: LoggingMetricBucketOptionsLinearBuckets;
}
export declare class LoggingMetricBucketOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _explicitBuckets?;
    private __explicitBucketsOutput;
    get explicitBuckets(): LoggingMetricBucketOptionsExplicitBucketsOutputReference;
    putExplicitBuckets(value: LoggingMetricBucketOptionsExplicitBuckets | undefined): void;
    resetExplicitBuckets(): void;
    get explicitBucketsInput(): LoggingMetricBucketOptionsExplicitBuckets | undefined;
    private _exponentialBuckets?;
    private __exponentialBucketsOutput;
    get exponentialBuckets(): LoggingMetricBucketOptionsExponentialBucketsOutputReference;
    putExponentialBuckets(value: LoggingMetricBucketOptionsExponentialBuckets | undefined): void;
    resetExponentialBuckets(): void;
    get exponentialBucketsInput(): LoggingMetricBucketOptionsExponentialBuckets | undefined;
    private _linearBuckets?;
    private __linearBucketsOutput;
    get linearBuckets(): LoggingMetricBucketOptionsLinearBucketsOutputReference;
    putLinearBuckets(value: LoggingMetricBucketOptionsLinearBuckets | undefined): void;
    resetLinearBuckets(): void;
    get linearBucketsInput(): LoggingMetricBucketOptionsLinearBuckets | undefined;
}
export interface LoggingMetricMetricDescriptorLabels {
    /**
     * A human-readable description for the label.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#description LoggingMetric#description}
     */
    readonly description?: string;
    /**
     * The label key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#key LoggingMetric#key}
     */
    readonly key: string;
    /**
     * The type of data that can be assigned to the label. Default value: "STRING" Possible values: ["BOOL", "INT64", "STRING"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#value_type LoggingMetric#value_type}
     */
    readonly valueType?: string;
}
export interface LoggingMetricMetricDescriptor {
    /**
     * A concise name for the metric, which can be displayed in user interfaces.
     *
     * Use sentence case
     * without an ending period, for example "Request count". This field is optional but it is
     * recommended to be set for any metrics associated with user-visible concepts, such as Quota.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#display_name LoggingMetric#display_name}
     */
    readonly displayName?: string;
    /**
     * Whether the metric records instantaneous values, changes to a value, etc.
     *
     * Some combinations of metricKind and valueType might not be supported.
     * For counter metrics, set this to DELTA. Possible values: ["DELTA", "GAUGE", "CUMULATIVE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#metric_kind LoggingMetric#metric_kind}
     */
    readonly metricKind: string;
    /**
     * The unit in which the metric value is reported.
     *
     * It is only applicable if the valueType is
     * 'INT64', 'DOUBLE', or 'DISTRIBUTION'. The supported units are a subset of
     * [The Unified Code for Units of Measure](http://unitsofmeasure.org/ucum.html) standard
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#unit LoggingMetric#unit}
     */
    readonly unit?: string;
    /**
     * Whether the measurement is an integer, a floating-point number, etc.
     *
     * Some combinations of metricKind and valueType might not be supported.
     * For counter metrics, set this to INT64. Possible values: ["BOOL", "INT64", "DOUBLE", "STRING", "DISTRIBUTION", "MONEY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#value_type LoggingMetric#value_type}
     */
    readonly valueType: string;
    /**
     * labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#labels LoggingMetric#labels}
     */
    readonly labels?: LoggingMetricMetricDescriptorLabels[];
}
export declare class LoggingMetricMetricDescriptorOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _metricKind?;
    get metricKind(): string;
    set metricKind(value: string);
    get metricKindInput(): string | undefined;
    private _unit?;
    get unit(): string | undefined;
    set unit(value: string | undefined);
    resetUnit(): void;
    get unitInput(): string | undefined;
    private _valueType?;
    get valueType(): string;
    set valueType(value: string);
    get valueTypeInput(): string | undefined;
    private _labels?;
    get labels(): LoggingMetricMetricDescriptorLabels[] | undefined;
    set labels(value: LoggingMetricMetricDescriptorLabels[] | undefined);
    resetLabels(): void;
    get labelsInput(): LoggingMetricMetricDescriptorLabels[] | undefined;
}
export interface LoggingMetricTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#create LoggingMetric#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#delete LoggingMetric#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html#update LoggingMetric#update}.
     */
    readonly update?: string;
}
export declare class LoggingMetricTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html google_logging_metric}.
 */
export declare class LoggingMetric extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_metric.html google_logging_metric} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: LoggingMetricConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    get id(): string;
    private _labelExtractors?;
    get labelExtractors(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labelExtractors(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabelExtractors(): void;
    get labelExtractorsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _valueExtractor?;
    get valueExtractor(): string | undefined;
    set valueExtractor(value: string | undefined);
    resetValueExtractor(): void;
    get valueExtractorInput(): string | undefined;
    private _bucketOptions?;
    private __bucketOptionsOutput;
    get bucketOptions(): LoggingMetricBucketOptionsOutputReference;
    putBucketOptions(value: LoggingMetricBucketOptions | undefined): void;
    resetBucketOptions(): void;
    get bucketOptionsInput(): LoggingMetricBucketOptions | undefined;
    private _metricDescriptor?;
    private __metricDescriptorOutput;
    get metricDescriptor(): LoggingMetricMetricDescriptorOutputReference;
    putMetricDescriptor(value: LoggingMetricMetricDescriptor): void;
    get metricDescriptorInput(): LoggingMetricMetricDescriptor | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): LoggingMetricTimeoutsOutputReference;
    putTimeouts(value: LoggingMetricTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): LoggingMetricTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
