import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoggingFolderBucketConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the logging bucket. Logging automatically creates two log buckets: _Required and _Default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config.html#bucket_id LoggingFolderBucketConfig#bucket_id}
     */
    readonly bucketId: string;
    /**
     * An optional description for this bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config.html#description LoggingFolderBucketConfig#description}
     */
    readonly description?: string;
    /**
     * The parent resource that contains the logging bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config.html#folder LoggingFolderBucketConfig#folder}
     */
    readonly folder: string;
    /**
     * The location of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config.html#location LoggingFolderBucketConfig#location}
     */
    readonly location: string;
    /**
     * Logs will be retained by default for this amount of time, after which they will automatically be deleted.
     *
     * The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config.html#retention_days LoggingFolderBucketConfig#retention_days}
     */
    readonly retentionDays?: number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config.html google_logging_folder_bucket_config}.
 */
export declare class LoggingFolderBucketConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config.html google_logging_folder_bucket_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: LoggingFolderBucketConfigConfig);
    private _bucketId?;
    get bucketId(): string;
    set bucketId(value: string);
    get bucketIdInput(): string | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    get id(): string;
    get lifecycleState(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _retentionDays?;
    get retentionDays(): number | undefined;
    set retentionDays(value: number | undefined);
    resetRetentionDays(): void;
    get retentionDaysInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
