import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoggingBillingAccountSinkConfig extends cdktf.TerraformMetaArguments {
    /**
     * The billing account exported to the sink.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html#billing_account LoggingBillingAccountSink#billing_account}
     */
    readonly billingAccount: string;
    /**
     * A description of this sink. The maximum length of the description is 8000 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html#description LoggingBillingAccountSink#description}
     */
    readonly description?: string;
    /**
     * The destination of the sink (or, in other words, where logs are written to).
     *
     * Can be a Cloud Storage bucket, a PubSub topic, or a BigQuery dataset. Examples: "storage.googleapis.com/[GCS_BUCKET]" "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]" "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]" The writer associated with the sink must have access to write to the above resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html#destination LoggingBillingAccountSink#destination}
     */
    readonly destination: string;
    /**
     * If set to True, then this sink is disabled and it does not export any log entries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html#disabled LoggingBillingAccountSink#disabled}
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * The filter to apply when exporting logs. Only log entries that match the filter are exported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html#filter LoggingBillingAccountSink#filter}
     */
    readonly filter?: string;
    /**
     * The name of the logging sink.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html#name LoggingBillingAccountSink#name}
     */
    readonly name: string;
    /**
     * bigquery_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html#bigquery_options LoggingBillingAccountSink#bigquery_options}
     */
    readonly bigqueryOptions?: LoggingBillingAccountSinkBigqueryOptions;
    /**
     * exclusions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html#exclusions LoggingBillingAccountSink#exclusions}
     */
    readonly exclusions?: LoggingBillingAccountSinkExclusions[];
}
export interface LoggingBillingAccountSinkBigqueryOptions {
    /**
     * Whether to use BigQuery's partition tables.
     *
     * By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned tables the date suffix is no longer present and special query syntax has to be used instead. In both cases, tables are sharded based on UTC timezone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html#use_partitioned_tables LoggingBillingAccountSink#use_partitioned_tables}
     */
    readonly usePartitionedTables: boolean | cdktf.IResolvable;
}
export declare class LoggingBillingAccountSinkBigqueryOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _usePartitionedTables?;
    get usePartitionedTables(): boolean | cdktf.IResolvable;
    set usePartitionedTables(value: boolean | cdktf.IResolvable);
    get usePartitionedTablesInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LoggingBillingAccountSinkExclusions {
    /**
     * A description of this exclusion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html#description LoggingBillingAccountSink#description}
     */
    readonly description?: string;
    /**
     * If set to True, then this exclusion is disabled and it does not exclude any log entries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html#disabled LoggingBillingAccountSink#disabled}
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * An advanced logs filter that matches the log entries to be excluded.
     *
     * By using the sample function, you can exclude less than 100% of the matching log entries
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html#filter LoggingBillingAccountSink#filter}
     */
    readonly filter: string;
    /**
     * A client-assigned identifier, such as "load-balancer-exclusion".
     *
     * Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html#name LoggingBillingAccountSink#name}
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html google_logging_billing_account_sink}.
 */
export declare class LoggingBillingAccountSink extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_sink.html google_logging_billing_account_sink} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: LoggingBillingAccountSinkConfig);
    private _billingAccount?;
    get billingAccount(): string;
    set billingAccount(value: string);
    get billingAccountInput(): string | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable | undefined;
    set disabled(value: boolean | cdktf.IResolvable | undefined);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string | undefined;
    set filter(value: string | undefined);
    resetFilter(): void;
    get filterInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get writerIdentity(): string;
    private _bigqueryOptions?;
    private __bigqueryOptionsOutput;
    get bigqueryOptions(): LoggingBillingAccountSinkBigqueryOptionsOutputReference;
    putBigqueryOptions(value: LoggingBillingAccountSinkBigqueryOptions | undefined): void;
    resetBigqueryOptions(): void;
    get bigqueryOptionsInput(): LoggingBillingAccountSinkBigqueryOptions | undefined;
    private _exclusions?;
    get exclusions(): LoggingBillingAccountSinkExclusions[] | undefined;
    set exclusions(value: LoggingBillingAccountSinkExclusions[] | undefined);
    resetExclusions(): void;
    get exclusionsInput(): LoggingBillingAccountSinkExclusions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
